/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.tree;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import junit.framework.TestCase;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.tree.Container;
import org.astrogrid.store.tree.File;
import org.astrogrid.store.tree.Node;
import org.astrogrid.store.tree.TreeClient;
import org.astrogrid.store.tree.TreeClientDuplicateException;
import org.astrogrid.store.tree.TreeClientLoginException;
import org.astrogrid.store.tree.TreeClientSecurityException;

public class TreeClientTest
extends TestCase {
    public static final String TEST_STRING = "A short test string ....";
    public static final byte[] TEST_BYTES = new byte[]{65, 32, 115, 104, 111, 114, 116, 32, 98, 121, 116, 101, 32, 97, 114, 114, 97, 121, 32, 46, 46, 46, 46};
    protected TreeClient adapter;
    protected Ivorn account;
    protected String password;
    protected String container;

    protected void setTestAdapter(TreeClient adapter) {
        this.adapter = adapter;
    }

    public void setTestAccount(Ivorn ivorn) {
        this.account = ivorn;
    }

    public void setTestPassword(String pass) {
        this.password = pass;
    }

    public void setContainerName(String name) {
        this.container = name;
    }

    public String getContainerName() {
        return this.container;
    }

    public void initContainerName() {
        this.setContainerName("aladin-" + String.valueOf(System.currentTimeMillis()));
    }

    public void testAdapterNotNull() throws Exception {
        TreeClientTest.assertNotNull((Object)this.adapter);
    }

    public void testLoginNullAccount() throws Exception {
        try {
            this.adapter.login(null, this.password);
        }
        catch (IllegalArgumentException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testLoginNullPassword() throws Exception {
        try {
            this.adapter.login(this.account, null);
        }
        catch (IllegalArgumentException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected IllegalArgumentException");
    }

    public void testLoginWrongPassword() throws Exception {
        try {
            this.adapter.login(this.account, this.password + "WRONG");
        }
        catch (TreeClientLoginException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterLoginException");
    }

    public void testLoginValidPassword() throws Exception {
        TreeClientTest.assertNull((Object)this.adapter.getToken());
        this.adapter.login(this.account, this.password);
        TreeClientTest.assertNotNull((Object)this.adapter.getToken());
    }

    public void testGetRootFails() throws Exception {
        try {
            this.adapter.getRoot();
        }
        catch (TreeClientSecurityException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterSecurityException");
    }

    public void testGetRoot() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        TreeClientTest.assertNotNull((Object)root);
        TreeClientTest.assertTrue((boolean)root.isContainer());
    }

    public void testWorkflowNode() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Iterator iter = root.getChildNodes().iterator();
        while (iter.hasNext()) {
            Node next = (Node)iter.next();
            if (!"workflow".equals(next.getName())) continue;
            return;
        }
        TreeClientTest.fail((String)"Expected to find workflow container");
    }

    public void testAddContainer() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        TreeClientTest.assertNotNull((Object)root.addContainer(this.getContainerName()));
    }

    public void testFindContainer() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        root.addContainer(this.getContainerName());
        Object found = null;
        Iterator iter = root.getChildNodes().iterator();
        while (iter.hasNext()) {
            Node next = (Node)iter.next();
            if (!this.getContainerName().equals(next.getName())) continue;
            return;
        }
        TreeClientTest.fail((String)"Expected to find aladin container");
    }

    public void testDuplicateContainer() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        root.addContainer(this.getContainerName());
        try {
            root.addContainer(this.getContainerName());
        }
        catch (TreeClientDuplicateException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterDuplicateException");
    }

    public void testAddFile() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        TreeClientTest.assertNotNull((Object)node.addFile("data.txt"));
    }

    public void testDuplicateFile() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        node.addFile("results.txt");
        try {
            node.addFile("results.txt");
        }
        catch (TreeClientDuplicateException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterDuplicateException");
    }

    public void testFindFile() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        node.addFile("results.txt");
        Object found = null;
        Iterator iter = node.getChildNodes().iterator();
        while (iter.hasNext()) {
            Node next = (Node)iter.next();
            if (!"results.txt".equals(next.getName())) continue;
            return;
        }
        TreeClientTest.fail((String)"Expected to find results.txt");
    }

    public void testGetOutputStream() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.txt");
        TreeClientTest.assertNotNull((Object)file.getOutputStream());
    }

    public void testImportData() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.txt");
        OutputStream stream = file.getOutputStream();
        stream.write(TEST_BYTES);
        stream.close();
    }

    public void testGetInputStream() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.txt");
        TreeClientTest.assertNotNull((Object)file.getInputStream());
    }

    public void testImportExportData() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.txt");
        OutputStream output = file.getOutputStream();
        output.write(TEST_BYTES);
        output.close();
        InputStream input = file.getInputStream();
        byte[] data = new byte[TEST_BYTES.length];
        input.read(data);
        for (int i = 0; i < TEST_BYTES.length; ++i) {
            TreeClientTest.assertEquals((byte)TEST_BYTES[i], (byte)data[i]);
        }
    }

    public void testGetMimeUnknown() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.unknown");
        TreeClientTest.assertNull((Object)file.getMimeType());
    }

    public void testGetMimeXml() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.xml");
        TreeClientTest.assertEquals((String)"text/xml", (String)file.getMimeType());
    }

    public void testGetMimeVot() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.vot");
        TreeClientTest.assertEquals((String)"text/xml +org.astrogrid.mime.votable", (String)file.getMimeType());
    }

    public void testGetMimeVotable() throws Exception {
        this.adapter.login(this.account, this.password);
        Container root = this.adapter.getRoot();
        Container node = root.addContainer(this.getContainerName());
        File file = node.addFile("results.votable");
        TreeClientTest.assertEquals((String)"text/xml +org.astrogrid.mime.votable", (String)file.getMimeType());
    }

    public void testLogout() throws Exception {
        try {
            this.adapter.getRoot();
        }
        catch (TreeClientSecurityException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterSecurityException");
        this.adapter.login(this.account, this.password);
        TreeClientTest.assertNotNull((Object)this.adapter.getRoot());
        this.adapter.logout();
        try {
            this.adapter.getRoot();
        }
        catch (TreeClientSecurityException ouch) {
            return;
        }
        TreeClientTest.fail((String)"Expected AladinAdapterSecurityException");
    }
}

