/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store.ui;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.astrogrid.community.User;
import org.astrogrid.io.Piper;
import org.astrogrid.store.Agsl;
import org.astrogrid.store.delegate.StoreClient;
import org.astrogrid.store.delegate.StoreDelegateFactory;
import org.astrogrid.store.delegate.StoreFile;
import org.astrogrid.store.delegate.myspace.MySpaceFile;

public class StoreCommander {
    public static void printHelp() {
        System.out.println("MySpaceCommander: Command-line access to MySpace");
        System.out.println();
        System.out.println("    org.astrogrid.ui.myspace.MySpaceCommander  <command> <VospaceRL> [<file>]");
        System.out.println();
        System.out.println("Commands:    delete - removes the specified VospaceRL");
        System.out.println("Commands:    list   - lists the files at the given VospaceRL");
        System.out.println("Commands:    get    - downloads from the given VospaceRL to the given file");
        System.out.println();
        System.out.println("AGSL is of the form: astrogrid:store:[<Msrl>|<URL>][#path]");
        System.out.println("eg    astrogrid:store:myspace:http://grendel12.roe.ac.uk:8080/astrogrid-mySpace#avodemo@test.astrogrid.org/serv1/votable/6dfResults");
    }

    public static StoreClient contactServer(Agsl vorl) throws IOException {
        System.out.println("Connecting to myspace...");
        return StoreDelegateFactory.createDelegate(User.ANONYMOUS, vorl);
    }

    public static void delete(Agsl vorl) throws IOException {
        StoreClient delegate = StoreCommander.contactServer(vorl);
        System.out.println("...deleting...");
        delegate.delete(vorl.getPath());
        System.out.println("...done");
    }

    public static void list(Agsl server, String filter) throws IOException {
        StoreClient delegate = StoreCommander.contactServer(server);
        System.out.println("Getting List (filter='" + filter + "')...");
        StoreFile root = delegate.getFiles(filter);
        System.out.println("Path, Type, Owner, Created Date, Expiry Date, Size, Permissions:");
        StoreCommander.printListEntry(0, root);
    }

    private static void printListEntry(int indent, StoreFile entry) {
        System.out.print(entry.getPath());
        String line = "";
        while (line.length() < indent * 2) {
            line = line + "  ";
        }
        if (entry.isFile()) {
            line = line + entry.getName();
            if (entry instanceof MySpaceFile) {
                MySpaceFile mse = (MySpaceFile)entry;
                System.out.print(",   " + mse.getType() + ",  " + mse.getOwner() + ", " + mse.getCreated() + ", " + mse.getExpires() + ", " + mse.getSize() + ", " + mse.getPermissions());
            }
            System.out.println(line);
        }
        if (entry.isFolder()) {
            System.out.println(line + entry.getName());
            StoreFile[] files = entry.listFiles();
            for (int i = 0; i < files.length; ++i) {
                StoreCommander.printListEntry(indent + 1, files[i]);
            }
        }
    }

    public static void get(Agsl source, File target) throws IOException {
        StoreClient delegate = StoreCommander.contactServer(source);
        System.out.println("Connecting to source...");
        BufferedInputStream in = new BufferedInputStream(delegate.getStream(source.getPath()));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        System.out.println("Copying...");
        Piper.pipe((InputStream)in, (OutputStream)out);
        System.out.println("..done");
        ((OutputStream)out).close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            StoreCommander.printHelp();
            return;
        }
        String command = args[0].toLowerCase().trim();
        if (command.equals("delete")) {
            StoreCommander.delete(new Agsl(args[1]));
        } else if (command.equals("list")) {
            String filter = "*";
            if (args.length > 2) {
                filter = args[2];
            }
            StoreCommander.list(new Agsl(args[1]), filter);
        } else if (command.equals("get")) {
            if (args.length < 3) {
                System.out.println("Not enough arguments");
                StoreCommander.printHelp();
            } else {
                StoreCommander.get(new Agsl(args[1]), new File(args[2]));
            }
        } else {
            System.out.println("Unknown command: " + command);
            StoreCommander.printHelp();
        }
    }
}

