/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class BarRenderer
extends AbstractCategoryItemRenderer {
    protected static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    protected double categorySpan;
    protected double categoryGapSpan;
    protected double itemSpan;
    protected double itemGapSpan;
    protected double itemWidth;
    protected double zeroInJava2D;
    protected double upperClip;
    protected double lowerClip;

    protected BarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        super(categoryToolTipGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
        this.lowerClip = valueAxis.getRange().getLowerBound();
        this.upperClip = valueAxis.getRange().getUpperBound();
    }

    public abstract int barWidthsPerCategory(CategoryDataset var1);

    public abstract boolean hasItemGaps();

    public boolean isStacked() {
        return false;
    }

    protected void calculateCategoryAndItemSpans(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryDataset categoryDataset, double d) {
        int n = categoryDataset.getSeriesCount();
        int n2 = categoryDataset.getCategoryCount();
        this.categorySpan = 0.0;
        this.categoryGapSpan = 0.0;
        if (n2 > 1) {
            double d2 = 1.0 - categoryPlot.getIntroGapPercent() - categoryPlot.getTrailGapPercent() - categoryPlot.getCategoryGapsPercent();
            this.categorySpan = d * d2;
            this.categoryGapSpan = d * categoryPlot.getCategoryGapsPercent();
        } else {
            double d3 = 1.0 - categoryPlot.getIntroGapPercent() - categoryPlot.getTrailGapPercent();
            this.categorySpan = d * d3;
        }
        this.itemSpan = this.categorySpan;
        this.itemGapSpan = 0.0;
        if (n > 1 && this.hasItemGaps()) {
            this.itemGapSpan = d * categoryPlot.getItemGapsPercent();
            this.itemSpan -= this.itemGapSpan;
        }
        this.itemWidth = this.itemSpan / (double)(n2 * this.barWidthsPerCategory(categoryDataset));
        this.zeroInJava2D = categoryPlot.getRangeAxis().translateValueToJava2D(0.0, rectangle2D);
    }
}

