/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.StandardEntityCollection;
import java.awt.geom.Rectangle2D;

public class ChartRenderingInfo {
    protected Rectangle2D chartArea = new Rectangle2D.Double();
    protected Rectangle2D plotArea = new Rectangle2D.Double();
    protected Rectangle2D dataArea = new Rectangle2D.Double();
    protected EntityCollection entities;
    protected boolean generateToolTips;

    public ChartRenderingInfo() {
        this(null);
    }

    public ChartRenderingInfo(EntityCollection entityCollection) {
        this.entities = entityCollection;
        this.generateToolTips = true;
    }

    public Rectangle2D getChartArea() {
        return this.chartArea;
    }

    public void setChartArea(Rectangle2D rectangle2D) {
        this.chartArea.setRect(rectangle2D);
    }

    public Rectangle2D getPlotArea() {
        return this.plotArea;
    }

    public void setPlotArea(Rectangle2D rectangle2D) {
        this.plotArea.setRect(rectangle2D);
    }

    public Rectangle2D getDataArea() {
        return this.dataArea;
    }

    public void setDataArea(Rectangle2D rectangle2D) {
        this.dataArea.setRect(rectangle2D);
    }

    public EntityCollection getEntityCollection() {
        return this.entities;
    }

    public void setEntityCollection(EntityCollection entityCollection) {
        this.entities = entityCollection;
    }

    public boolean isGenerateToolTips() {
        return this.generateToolTips;
    }

    public void setGenerateToolTips(boolean bl) {
        this.generateToolTips = bl;
        this.entities = bl ? new StandardEntityCollection() : null;
    }

    public void clear() {
        this.chartArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.plotArea.setRect(0.0, 0.0, 0.0, 0.0);
        this.dataArea.setRect(0.0, 0.0, 0.0, 0.0);
        if (this.entities != null) {
            this.entities.clear();
        }
    }
}

