/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedXYPlot
extends XYPlot {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int type;
    protected List subplots;
    protected int seriesCount = 0;
    protected int totalWeight = 0;
    protected double gap = 5.0;

    public CombinedXYPlot(ValueAxis valueAxis, int n) {
        super(null, n == 1 ? valueAxis : null, n == 0 ? valueAxis : null);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid type (" + n + ")");
        }
        this.type = n;
        this.subplots = new ArrayList();
    }

    public void setGap(double d) {
        this.gap = d;
    }

    public double getGap() {
        return this.gap;
    }

    public void add(XYPlot xYPlot, int n) throws AxisNotCompatibleException, IllegalArgumentException {
        if (!this.isValidSubHorizontalAxis((Axis)((Object)xYPlot.getHorizontalAxis()))) {
            throw new AxisNotCompatibleException("MultiXYPlot.add(...): invalid horizontal axis.");
        }
        if (!this.isValidSubVerticalAxis((Axis)((Object)xYPlot.getVerticalAxis()))) {
            throw new AxisNotCompatibleException("MultiXYPlot.add(...): invalid vertical axis.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("MultiXYPlot.add(...): weight must be positive.");
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n);
        xYPlot.setInsets(new Insets(0, 0, 0, 0));
        xYPlot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += xYPlot.getSeriesCount();
        if (this.type == 1) {
            xYPlot.setDomainAxis(null);
        }
        if (this.type == 0) {
            xYPlot.setRangeAxis(null);
        }
        this.subplots.add(xYPlot);
        this.totalWeight += n;
        if (this.type == 0) {
            this.getRangeAxis().configure();
        }
        if (this.type == 1) {
            this.getDomainAxis().configure();
        }
    }

    public boolean isValidSubHorizontalAxis(Axis axis) {
        boolean bl = true;
        if (this.type == 1) {
            bl = axis == null;
        }
        return bl;
    }

    public boolean isValidSubVerticalAxis(Axis axis) {
        boolean bl = true;
        if (this.type == 0) {
            bl = axis == null;
        }
        return bl;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        double d = 0.0;
        if (this.type == 1) {
            object = this.getHorizontalAxis();
            if (object != null) {
                d = object.reserveHeight(graphics2D, this, rectangle2D);
            }
        } else {
            object = this.getVerticalAxis();
            if (object != null) {
                d = object.reserveWidth(graphics2D, this, rectangle2D);
            }
        }
        object = this.type == 0 ? new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight()) : new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
        int n = this.subplots.size();
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n];
        double d2 = ((RectangularShape)object).getX();
        double d3 = ((RectangularShape)object).getY();
        double d4 = ((RectangularShape)object).getWidth();
        if (this.type == 0) {
            d4 -= this.gap * (double)(n - 1);
        }
        double d5 = ((RectangularShape)object).getHeight();
        if (this.type == 1) {
            d5 -= this.gap * (double)(n - 1);
        }
        double d6 = Double.MIN_VALUE;
        double d7 = Double.MIN_VALUE;
        int n2 = 0;
        while (n2 < n) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(n2);
            double d8 = d5;
            if (this.type == 1) {
                d8 *= (double)xYPlot.getWeight() / (double)this.totalWeight;
            }
            double d9 = d4;
            if (this.type == 0) {
                d9 *= (double)xYPlot.getWeight() / (double)this.totalWeight;
            }
            rectangle2DArray[n2] = new Rectangle2D.Double(d2, d3, d9, d8);
            if (this.type == 1) {
                d6 = Math.max(d6, xYPlot.getVerticalAxis().reserveWidth(graphics2D, xYPlot, rectangle2DArray[n2]));
            } else if (this.type == 0) {
                d7 = Math.max(d7, xYPlot.getHorizontalAxis().reserveHeight(graphics2D, xYPlot, rectangle2DArray[n2]));
            }
            if (this.type == 1) {
                d3 += d8 + this.gap;
            } else if (this.type == 0) {
                d2 += d9 + this.gap;
            }
            ++n2;
        }
        if (this.type == 1) {
            this.setVerticalAxisWidth(d6);
            ((Rectangle2D)object).setRect(((RectangularShape)object).getX() + d6, ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth() - d6, ((RectangularShape)object).getHeight());
            this.domainAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        } else if (this.type == 0) {
            this.setHorizontalAxisHeight(d7);
            ((Rectangle2D)object).setRect(((RectangularShape)object).getX(), ((RectangularShape)object).getY(), ((RectangularShape)object).getWidth(), ((RectangularShape)object).getHeight() - d7);
            this.rangeAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object);
        }
        int n3 = 0;
        while (n3 < n) {
            XYPlot xYPlot = (XYPlot)this.subplots.get(n3);
            xYPlot.draw(graphics2D, rectangle2DArray[n3], chartRenderingInfo);
            ++n3;
        }
    }

    protected void setHorizontalAxisHeight(double d) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            valueAxis.setFixedDimension(d);
        }
    }

    protected void setVerticalAxisWidth(double d) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            valueAxis.setFixedDimension(d);
        }
    }

    public void zoom(double d) {
    }

    public List getLegendItemLabels() {
        ArrayList arrayList = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                List list = xYPlot.getLegendItemLabels();
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public String getPlotType() {
        switch (this.type) {
            case 0: {
                return "Horizontal MultiXYPlot";
            }
            case 1: {
                return "Vertical MultiXYPlot";
            }
        }
        return "Unknown";
    }

    public Range getHorizontalDataRange() {
        Range range = null;
        if (this.type == 1 && this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, (Range)xYPlot.getHorizontalDataRange());
            }
        }
        return range;
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.type == 0 && this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, (Range)xYPlot.getVerticalDataRange());
            }
        }
        return range;
    }
}

