/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.DateAxis;
import com.jrefinery.chart.DateUnit;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.DateRange;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;

public class HorizontalDateAxis
extends DateAxis
implements HorizontalAxis {
    protected boolean verticalTickLabels;

    public HorizontalDateAxis() {
        this(null, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_STROKE, true, (Range)new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, false, true, AxisConstants.DEFAULT_TICK_STROKE, true, (Range)new DateRange(), true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String string, Font font, Range range) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_STROKE, true, range, true, new DateUnit(5, 1), new SimpleDateFormat(), true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, DateAxis.DEFAULT_CROSSHAIR_DATE, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public HorizontalDateAxis(String string, Font font, Paint paint, Insets insets, boolean bl, Font font2, Paint paint2, Insets insets2, boolean bl2, boolean bl3, Stroke stroke, boolean bl4, Range range, boolean bl5, DateUnit dateUnit, SimpleDateFormat simpleDateFormat, boolean bl6, Stroke stroke2, Paint paint3, boolean bl7, Date date, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl, font2, paint2, insets2, bl3, stroke, bl4, range, bl5, dateUnit, simpleDateFormat, bl6, stroke2, paint3, bl7, date, stroke3, paint4);
        this.verticalTickLabels = bl2;
    }

    public boolean getVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        this.verticalTickLabels = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateDateToJava2D(Date date, Rectangle2D rectangle2D) {
        double d = date.getTime();
        double d2 = this.range.getLowerBound();
        double d3 = this.range.getUpperBound();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.range.getLowerBound();
        double d3 = this.range.getUpperBound();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        double d = this.range.getLowerBound();
        double d2 = this.range.getUpperBound();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getMaxX();
        double d5 = d + ((double)f - d3) / (d4 - d3) * (d2 - d);
        return d5;
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof HorizontalValuePlot) {
            long l;
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)this.plot);
            Range range = horizontalValuePlot.getHorizontalDataRange();
            if (range == null) {
                range = new DateRange();
            }
            long l2 = (long)range.getUpperBound();
            if (this.fixedAutoRange > 0.0) {
                l = l2 - (long)this.fixedAutoRange;
            } else {
                l = (long)range.getLowerBound();
                long l3 = l2 - l;
                l2 += l3 / 20L;
                l -= l3 / 20L;
            }
            this.range = new DateRange(new Date(l), new Date(l2));
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        graphics2D.setFont(this.tickLabelFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.autoTickUnitSelection) {
            this.calculateAutoTickUnits(graphics2D, rectangle2D, rectangle2D2);
        }
        Rectangle2D rectangle2D3 = null;
        Date date = this.calculateLowestVisibleTickValue(this.tickUnit);
        Date date2 = this.getMaximumDate();
        while (date.before(date2)) {
            double d = this.translateDateToJava2D(date, rectangle2D2);
            String string = this.tickLabelFormatter.format(date);
            rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
            LineMetrics lineMetrics = this.tickLabelFont.getLineMetrics(string, fontRenderContext);
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.verticalTickLabels) {
                f = (float)(d + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getWidth());
            } else {
                f = (float)(d - rectangle2D3.getWidth() / 2.0);
                f2 = (float)(rectangle2D2.getMaxY() + (double)this.tickLabelInsets.top + rectangle2D3.getHeight());
            }
            Tick tick = new Tick(date, string, f, f2);
            this.ticks.add(tick);
            date = this.tickUnit.addToDate(date);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        float f;
        Object object;
        Object object2;
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object2 = this.labelFont.getStringBounds(this.label, fontRenderContext);
            object = this.labelFont.getLineMetrics(this.label, fontRenderContext);
            f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - ((RectangularShape)object2).getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMaxY() - (double)this.labelInsets.bottom - (double)((LineMetrics)object).getDescent() - (double)((LineMetrics)object).getLeading());
            graphics2D.drawString(this.label, f, f2);
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        float f3 = (float)rectangle2D2.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        object2 = this.ticks.iterator();
        while (object2.hasNext()) {
            object = (Tick)object2.next();
            f = (float)this.translateValueToJava2D(((Tick)object).getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString((String)((Tick)object).getText(), (Graphics2D)graphics2D, (float)((Tick)object).getX(), (float)((Tick)object).getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(((Tick)object).getText(), ((Tick)object).getX(), ((Tick)object).getY());
                }
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                Line2D.Float float_ = new Line2D.Float(f, f3 - 2.0f, f, f3 + 2.0f);
                graphics2D.draw(float_);
            }
            if (!this.gridLinesVisible) continue;
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            Line2D.Float float_ = new Line2D.Float(f, (float)rectangle2D2.getMaxY(), f, (float)rectangle2D2.getMinY());
            graphics2D.draw(float_);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        double d = 0.0;
        if (this.label != null) {
            LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
            d = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        }
        double d2 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (!this.visible) {
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth() - d, 0.0);
        }
        LineMetrics lineMetrics = this.labelFont.getLineMetrics(this.label, graphics2D.getFontRenderContext());
        double d2 = (float)this.labelInsets.top + lineMetrics.getHeight() + (float)this.labelInsets.bottom;
        double d3 = this.tickLabelInsets.top + this.tickLabelInsets.bottom;
        if (this.tickLabelsVisible) {
            graphics2D.setFont(this.tickLabelFont);
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getMaxY(), rectangle2D.getWidth() - d, d2 + d3);
    }

    private void calculateAutoTickUnits(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        int n = this.findAxisMagnitudeIndex();
        boolean bl = true;
        while (bl && n > 0) {
            bl = this.tickLabelsFit(--n, graphics2D, rectangle2D, rectangle2D2);
        }
        this.autoTickIndex = bl ? n : Math.min(n + 1, DateAxis.standardTickUnitMagnitudes.length);
        this.tickLabelFormatter.applyPattern(DateAxis.standardTickFormats[this.autoTickIndex]);
        this.tickUnit = new DateUnit(DateAxis.standardTickUnits[this.autoTickIndex][0], DateAxis.standardTickUnits[this.autoTickIndex][1]);
    }

    private boolean tickLabelsFit(int n, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateAxis.standardTickFormats[n]);
        DateUnit dateUnit = new DateUnit(DateAxis.standardTickUnits[n][0], DateAxis.standardTickUnits[n][1]);
        double d = Double.NEGATIVE_INFINITY;
        boolean bl = true;
        Date date = this.calculateLowestVisibleTickValue(dateUnit);
        Date date2 = this.getMaximumDate();
        while (date.before(date2) && bl) {
            double d2;
            double d3 = this.translateDateToJava2D(date, rectangle2D2);
            String string = simpleDateFormat.format(date);
            Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
            if (this.verticalTickLabels) {
                d2 = d3 - rectangle2D3.getHeight() / 2.0;
                if (d2 < d) {
                    bl = false;
                }
                d = d3 + rectangle2D3.getHeight() / 2.0;
            } else {
                d2 = d3 - rectangle2D3.getWidth() / 2.0;
                if (d2 < d) {
                    bl = false;
                }
                d = d3 + rectangle2D3.getWidth() / 2.0;
            }
            date = dateUnit.addToDate(date);
        }
        return bl;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.ticks.iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

