/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalCategoryAxis;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalCategoryPlot;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultCategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidVerticalCategoryPlot
extends VerticalCategoryPlot {
    protected List subplots;
    protected int seriesCount = 0;

    public OverlaidVerticalCategoryPlot(String string, String string2, Object[] objectArray) {
        this(new HorizontalCategoryAxis(string), new VerticalNumberAxis(string2), objectArray);
    }

    public OverlaidVerticalCategoryPlot(CategoryAxis categoryAxis, ValueAxis valueAxis, Object[] objectArray) {
        super(null, categoryAxis, valueAxis, null);
        double[][] dArray = new double[1][objectArray.length];
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset(dArray);
        defaultCategoryDataset.setCategories(objectArray);
        this.setDataset((Dataset)defaultCategoryDataset);
        this.subplots = new ArrayList();
    }

    public void add(VerticalCategoryPlot verticalCategoryPlot) {
        ValueAxis valueAxis;
        verticalCategoryPlot.setParent(this);
        verticalCategoryPlot.setDomainAxis(null);
        verticalCategoryPlot.setRangeAxis(null);
        verticalCategoryPlot.setFirstSeriesIndex(this.seriesCount);
        this.seriesCount += verticalCategoryPlot.getSeriesCount();
        this.subplots.add(verticalCategoryPlot);
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public List getLegendItemLabels() {
        ArrayList arrayList = new ArrayList();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                List list = verticalCategoryPlot.getLegendItemLabels();
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, Shape shape) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
            verticalCategoryPlot.render(graphics2D, rectangle2D, chartRenderingInfo, shape);
        }
    }

    public String getPlotType() {
        return "Overlaid Vertical Category Plot";
    }

    public int getSeriesCount() {
        int n = 0;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
            n += verticalCategoryPlot.getSeriesCount();
        }
        return n;
    }

    public void setFirstSeriesIndex(int n) {
        this.firstSeriesIndex = n;
        int n2 = n;
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
            verticalCategoryPlot.setFirstSeriesIndex(n2);
            n2 += verticalCategoryPlot.getSeriesCount();
        }
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                range = Range.combine(range, (Range)verticalCategoryPlot.getVerticalDataRange());
            }
        }
        return range;
    }

    public Number getMinimumVerticalDataValue() {
        Number number = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                Number number2 = verticalCategoryPlot.getMinimumVerticalDataValue();
                if (number == null) {
                    number = number2;
                    continue;
                }
                if (number2 == null) continue;
                number = new Double(Math.min(number.doubleValue(), number2.doubleValue()));
            }
        }
        return number;
    }

    public Number getMaximumVerticalDataValue() {
        Number number = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                Number number2 = verticalCategoryPlot.getMaximumVerticalDataValue();
                if (number == null) {
                    number = number2;
                    continue;
                }
                if (number2 == null) continue;
                number = new Double(Math.max(number.doubleValue(), number2.doubleValue()));
            }
        }
        return number;
    }
}

