/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class VerticalLogarithmicAxis
extends VerticalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    protected final boolean log10TickLabelsFlag;

    public VerticalLogarithmicAxis() {
        this(null);
    }

    public VerticalLogarithmicAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 1.0, 10.0);
    }

    public VerticalLogarithmicAxis(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT, true);
    }

    public VerticalLogarithmicAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, boolean bl4, boolean bl5, Number number, double d, double d2, boolean bl6, boolean bl7, NumberTickUnit numberTickUnit, boolean bl8, Stroke stroke2, Paint paint3, boolean bl9, double d3, Stroke stroke3, Paint paint4, boolean bl10) {
        super(string, font, paint, insets, bl, bl2, font2, paint2, insets2, bl3, stroke, bl4, bl5, false, number, d, d2, bl6, bl7, numberTickUnit, bl8, stroke2, paint3, bl9, d3, stroke3, paint4);
        this.log10TickLabelsFlag = bl10;
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.adjustedLog10(this.range.getLowerBound());
        double d3 = this.adjustedLog10(this.range.getUpperBound());
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        d = this.adjustedLog10(d);
        if (this.inverted) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        double d = this.adjustedLog10(this.range.getLowerBound());
        double d2 = this.adjustedLog10(this.range.getUpperBound());
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.inverted) {
            return d + Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return d2 - Math.pow(10.0, ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double d;
            double d2;
            double d3;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.plot);
            Range range = verticalValuePlot.getVerticalDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            if ((d3 = this.computeLogCeil(range.getUpperBound())) - (d2 = this.computeLogFloor(range.getLowerBound())) < (d = this.autoRangeMinimumSize.doubleValue())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.range = new Range(d2, d3);
        }
    }

    private double computeLogCeil(double d) {
        double d2;
        if (d > 10.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else if (d < -10.0) {
            d2 = Math.log(-d) / LOG10_VALUE;
            d2 = Math.ceil(-d2);
            d2 = -Math.pow(10.0, -d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    private double computeLogFloor(double d) {
        double d2;
        if (d > 10.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else if (d < -10.0) {
            d2 = Math.log(-d) / LOG10_VALUE;
            d2 = Math.floor(-d2);
            d2 = -Math.pow(10.0, -d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        int n = (int)Math.rint(this.adjustedLog10(this.range.getLowerBound()));
        int n2 = (int)Math.rint(this.adjustedLog10(this.range.getUpperBound()));
        boolean bl = false;
        int n3 = n;
        while (n3 <= n2) {
            int n4 = 10;
            if (n3 == n2) {
                n4 = 1;
            }
            int n5 = 0;
            while (n5 < n4) {
                String string;
                double d;
                if (bl) {
                    --n5;
                }
                double d2 = d = n3 >= 0 ? Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5 : -(Math.pow(10.0, -n3) - Math.pow(10.0, -n3 - 1) * (double)n5);
                if (n5 == 0) {
                    if (!bl) {
                        if (n3 > n && n3 < n2 && Math.abs(d - 1.0) < 1.0E-4) {
                            d = 0.0;
                            bl = true;
                            string = "0";
                        } else {
                            string = this.log10TickLabelsFlag ? (n3 < 0 ? "-" : "") + "10^" + Math.abs(n3) : Long.toString((long)Math.rint(d));
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                } else {
                    string = "";
                    bl = false;
                }
                Double d3 = new Double(d);
                double d4 = this.translateValueToJava2D(d, rectangle2D2);
                Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
                float f = (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
                float f2 = (float)(d4 + rectangle2D3.getHeight() / 3.0);
                this.ticks.add(new Tick(d3, string, f, f2));
                ++n5;
            }
            ++n3;
        }
    }

    public double adjustedLog10(double d) {
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }
}

