/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AxisConstants;
import com.jrefinery.chart.NumberAxis;
import com.jrefinery.chart.NumberTickUnit;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.Tick;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class VerticalNumberAxis
extends NumberAxis
implements VerticalAxis {
    protected boolean verticalLabel;

    public VerticalNumberAxis() {
        this(null);
    }

    public VerticalNumberAxis(String string) {
        this(string, AxisConstants.DEFAULT_AXIS_LABEL_FONT, 0.0, 1.0);
        this.autoRange = true;
    }

    public VerticalNumberAxis(String string, Font font, double d, double d2) {
        this(string, font, AxisConstants.DEFAULT_AXIS_LABEL_PAINT, AxisConstants.DEFAULT_AXIS_LABEL_INSETS, true, true, AxisConstants.DEFAULT_TICK_LABEL_FONT, AxisConstants.DEFAULT_TICK_LABEL_PAINT, AxisConstants.DEFAULT_TICK_LABEL_INSETS, true, AxisConstants.DEFAULT_TICK_STROKE, true, true, true, NumberAxis.DEFAULT_MINIMUM_AUTO_RANGE, d, d2, false, true, NumberAxis.DEFAULT_TICK_UNIT, true, ValueAxis.DEFAULT_GRID_LINE_STROKE, ValueAxis.DEFAULT_GRID_LINE_PAINT, false, 0.0, ValueAxis.DEFAULT_CROSSHAIR_STROKE, ValueAxis.DEFAULT_CROSSHAIR_PAINT);
    }

    public VerticalNumberAxis(String string, Font font, Paint paint, Insets insets, boolean bl, boolean bl2, Font font2, Paint paint2, Insets insets2, boolean bl3, Stroke stroke, boolean bl4, boolean bl5, boolean bl6, Number number, double d, double d2, boolean bl7, boolean bl8, NumberTickUnit numberTickUnit, boolean bl9, Stroke stroke2, Paint paint3, boolean bl10, double d3, Stroke stroke3, Paint paint4) {
        super(string, font, paint, insets, bl2, font2, paint2, insets2, bl3, stroke, bl4, bl5, bl6, number, d, d2, bl7, bl8, numberTickUnit, bl9, stroke2, paint3, bl10, d3, stroke3, paint4);
        this.verticalLabel = bl;
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean bl) {
        if (this.verticalLabel != bl) {
            this.verticalLabel = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        double d2 = this.range.getLowerBound();
        double d3 = this.range.getUpperBound();
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        if (this.inverted) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        double d = this.range.getLowerBound();
        double d2 = this.range.getUpperBound();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.inverted) {
            return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    protected void autoAdjustRange() {
        if (this.plot == null) {
            return;
        }
        if (this.plot instanceof VerticalValuePlot) {
            double d;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)this.plot);
            Range range = verticalValuePlot.getVerticalDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            double d4 = d3 - d2;
            if (d4 < (d = this.autoRangeMinimumSize.doubleValue())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            if (this.autoRangeIncludesZero) {
                if (this.autoRangeStickyZero) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += this.upperMargin * (d3 - Math.min(d2, 0.0)));
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= this.lowerMargin * (d3 - d2));
                } else {
                    d4 = Math.max(0.0, d3) - Math.min(0.0, d2);
                    d3 = Math.max(0.0, d3 + this.upperMargin * d4);
                    d2 = Math.min(0.0, d2 - this.lowerMargin * d4);
                }
            } else if (this.autoRangeStickyZero) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + this.upperMargin * d4) : (d3 += this.upperMargin * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.lowerMargin * d4) : (d2 -= this.lowerMargin * d4);
            } else {
                d3 += this.upperMargin * d4;
                d2 -= this.lowerMargin * d4;
            }
            this.range = new Range(d2, d3);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        if (!this.visible) {
            return;
        }
        if (this.label != null) {
            double d;
            double d2;
            graphics2D.setFont(this.labelFont);
            graphics2D.setPaint(this.labelPaint);
            Rectangle2D rectangle2D3 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            if (this.verticalLabel) {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left + rectangle2D3.getHeight();
                d = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)this.label, (Graphics2D)graphics2D, (float)((float)d2), (float)((float)d), (double)-1.5707963267948966);
            } else {
                d2 = rectangle2D.getX() + (double)this.labelInsets.left;
                d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(this.label, (float)d2, (float)d);
            }
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2);
        double d = rectangle2D2.getX();
        graphics2D.setFont(this.tickLabelFont);
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Line2D.Double double_;
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.tickLabelsVisible) {
                graphics2D.setPaint(this.tickLabelPaint);
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (this.tickMarksVisible) {
                graphics2D.setStroke(this.getTickMarkStroke());
                double_ = new Line2D.Double(rectangle2D2.getX() - 2.0, f, rectangle2D2.getX() + 2.0, f);
                graphics2D.draw(double_);
            }
            if (!this.gridLinesVisible) continue;
            graphics2D.setStroke(this.gridStroke);
            graphics2D.setPaint(this.gridPaint);
            double_ = new Line2D.Double(d, f, rectangle2D2.getMaxX(), f);
            graphics2D.draw(double_);
        }
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        if (!this.visible) {
            return 0.0;
        }
        if (this.fixedDimension > 0.0) {
            return this.fixedDimension;
        }
        double d = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d = this.labelInsets.left + this.labelInsets.right;
            d = this.verticalLabel ? (d += rectangle2D2.getHeight()) : (d += rectangle2D2.getWidth());
        }
        double d2 = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D);
            d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d + d2;
    }

    public Rectangle2D reserveAxisArea(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, double d) {
        if (!this.visible) {
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), 0.0, rectangle2D.getHeight() - d);
        }
        if (this.fixedDimension > 0.0) {
            return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), this.fixedDimension, rectangle2D.getHeight() - d);
        }
        double d2 = 0.0;
        if (this.label != null) {
            Rectangle2D rectangle2D2 = this.labelFont.getStringBounds(this.label, graphics2D.getFontRenderContext());
            d2 = this.labelInsets.left + this.labelInsets.right;
            d2 = this.verticalLabel ? (d2 += rectangle2D2.getHeight()) : (d2 += rectangle2D2.getWidth());
        }
        double d3 = this.tickLabelInsets.left + this.tickLabelInsets.right;
        if (this.tickLabelsVisible) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
            this.refreshTicks(graphics2D, rectangle2D, double_);
            d3 += this.getMaxTickLabelWidth(graphics2D, double_);
        }
        return new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), d2 + d3, rectangle2D.getHeight() - d);
    }

    private void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        NumberTickUnit numberTickUnit;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = this.tickLabelFont.getLineMetrics("123", fontRenderContext).getHeight() + (float)this.tickLabelInsets.top + (float)this.tickLabelInsets.bottom;
        double d2 = this.translateValueToJava2D(0.0, rectangle2D2);
        NumberTickUnit numberTickUnit2 = (NumberTickUnit)this.standardTickUnits.getCeilingTickUnit(this.tickUnit);
        double d3 = this.translateValueToJava2D(numberTickUnit2.getSize(), rectangle2D2);
        double d4 = Math.abs(d3 - d2);
        double d5 = d / d4 * numberTickUnit2.getSize();
        NumberTickUnit numberTickUnit3 = new NumberTickUnit(d5, null);
        this.tickUnit = numberTickUnit = (NumberTickUnit)this.standardTickUnits.getCeilingTickUnit(numberTickUnit3);
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.ticks.clear();
        graphics2D.setFont(this.tickLabelFont);
        if (this.autoTickUnitSelection) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        double d = this.tickUnit.getSize();
        int n = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        int n2 = 0;
        while (n2 < n) {
            double d3 = d2 + (double)n2 * d;
            double d4 = this.translateValueToJava2D(d3, rectangle2D2);
            String string = this.tickUnit.valueToString(d3);
            Rectangle2D rectangle2D3 = this.tickLabelFont.getStringBounds(string, graphics2D.getFontRenderContext());
            float f = (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.tickLabelInsets.left - (double)this.tickLabelInsets.right);
            float f2 = (float)(d4 + rectangle2D3.getHeight() / 2.0);
            Tick tick = new Tick(new Double(d3), string, f, f2);
            this.ticks.add(tick);
            ++n2;
        }
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalValuePlot;
    }
}

