/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;

public class IntegerParameter
extends Parameter {
    private boolean even;
    private boolean odd;
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private int intval;

    public IntegerParameter(String name) {
        super(name);
    }

    public void setEven() {
        this.even = true;
    }

    public void setOdd() {
        this.odd = true;
    }

    public void setMinimum(int min) {
        this.min = min;
    }

    public void setMaximum(int max) {
        this.max = max;
    }

    public int intValue() throws ParameterValueException, AbortException {
        this.checkGotValue();
        return this.intval;
    }

    public void setValueFromString(String stringval) throws ParameterValueException {
        try {
            this.intval = Integer.parseInt(stringval);
        }
        catch (NumberFormatException e) {
            throw new ParameterValueException((Parameter)this, e.getMessage());
        }
        if (this.odd && this.intval % 2 == 0) {
            throw new ParameterValueException((Parameter)this, this.intval + " is not odd");
        }
        if (this.even && this.intval % 2 == 1) {
            throw new ParameterValueException((Parameter)this, this.intval + " is not even");
        }
        if (this.intval < this.min) {
            throw new ParameterValueException((Parameter)this, this.intval + " < minimum value " + this.min);
        }
        if (this.intval > this.max) {
            throw new ParameterValueException((Parameter)this, this.intval + " < maximum value " + this.max);
        }
        super.setValueFromString(stringval);
    }
}

