/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ParameterValueException;

public class Parameter {
    private final String name;
    private String prompt;
    private String def;
    private int pos;
    private Environment env;
    private String stringValue;
    private boolean gotValue;

    public Parameter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        this.def = def;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public void setValueFromString(String stringval) throws ParameterValueException {
        this.stringValue = stringval;
        this.setGotValue(true);
    }

    public String stringValue() throws AbortException {
        try {
            this.checkGotValue();
        }
        catch (ParameterValueException e) {
            throw new AssertionError((Object)"How did that happen?");
        }
        return this.stringValue;
    }

    public void clearValue() {
        this.env.clearParameterValue(this);
        this.setGotValue(false);
    }

    private void setGotValue(boolean gotValue) {
        this.gotValue = gotValue;
    }

    protected void checkGotValue() throws AbortException, ParameterValueException {
        if (!this.gotValue) {
            this.env.setParameterValue(this);
            this.setGotValue(true);
        }
    }

    public String toString() {
        return this.name;
    }
}

