/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.task;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TerminalEnvironment;
import uk.ac.starlink.task.UsageException;

public class TerminalInvoker {
    private String toolname;
    private Map taskmap;

    public TerminalInvoker(String toolname, Map taskmap) {
        this.toolname = toolname;
        this.taskmap = taskmap;
    }

    public void invoke(String[] args) throws Exception {
        String usage = "Usage: " + this.toolname + " [-help]" + " [-fulltrace] " + " [-bench ntimes] " + " taskname [args]";
        if (args.length < 1 || args[0].length() == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        String taskname = args[0].toLowerCase();
        boolean fulltrace = false;
        if (taskname.equals("-bench")) {
            int ntimes = Integer.parseInt(args[1]);
            String[] benchargs = new String[args.length - 2];
            System.arraycopy(args, 2, benchargs, 0, args.length - 2);
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < ntimes) {
                this.invoke(benchargs);
                ++i;
            }
            long finish = System.currentTimeMillis();
            System.out.println("\n    Time for " + ntimes + " iterations: " + (finish - start) + " ms\n");
            return;
        }
        if (taskname.equals("-fulltrace")) {
            fulltrace = true;
            String[] targs = new String[args.length - 1];
            System.arraycopy(args, 1, targs, 0, args.length - 1);
            args = targs;
            taskname = args[0].toLowerCase();
        }
        if (taskname.startsWith("-")) {
            System.out.println(usage);
            System.out.println("Known tasks:");
            TreeMap tmap = new TreeMap(this.taskmap);
            Iterator it = tmap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                System.out.println("   " + (String)entry.getKey() + " " + ((Task)entry.getValue()).getUsage());
            }
            System.out.println();
            return;
        }
        if (this.taskmap.containsKey(taskname)) {
            Task task = (Task)this.taskmap.get(taskname);
            String[] taskargs = new String[args.length - 1];
            System.arraycopy(args, 1, taskargs, 0, args.length - 1);
            try {
                Parameter[] params = task.getParameters();
                TerminalEnvironment env = new TerminalEnvironment(taskargs, params);
                int i = 0;
                while (i < params.length) {
                    params[i].setEnvironment(env);
                    ++i;
                }
                task.invoke(env);
            }
            catch (UsageException e) {
                String tusage = e.getUsage();
                if (tusage == null) {
                    tusage = task.getUsage();
                }
                System.err.println("Usage: " + this.toolname + " " + taskname + " " + tusage);
                System.exit(1);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (fulltrace) {
                        cause.printStackTrace(System.err);
                    } else {
                        System.err.println(cause.getMessage());
                    }
                }
                System.err.println(this.toolname + " " + taskname + ": " + e.getMessage());
                System.exit(e.getErrorCode());
            }
            catch (AbortException e) {
                System.err.println(this.toolname + " " + taskname + ": User abort");
                System.exit(1);
            }
            catch (ParameterValueException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    if (fulltrace) {
                        cause.printStackTrace(System.err);
                    } else {
                        System.err.println(cause.getMessage());
                    }
                }
                System.err.println(this.toolname + " " + taskname + ": " + e.getMessage());
            }
        } else {
            System.err.println(this.toolname + ": Unknown task.  Use -h for list");
        }
    }
}

