/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.mirage;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;

public class MirageFormatter {
    protected PrintStream strm;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public MirageFormatter(PrintStream strm) {
        this.strm = strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMirageFormat(StarTable table) throws IOException {
        this.strm.println("#\n# Written by " + this);
        int ncol = table.getColumnCount();
        String[] colNames = new String[ncol];
        boolean[] isUsed = new boolean[ncol];
        boolean[] isText = new boolean[ncol];
        int nText = 0;
        int i = 0;
        while (i < ncol) {
            ColumnInfo cinfo = table.getColumnInfo(i);
            String colName = cinfo.getName();
            if (colName != null) {
                Class clazz;
                colNames[i] = colName = colName.replaceAll("\\s+", "_");
                if ((class$java$lang$Number == null ? MirageFormatter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(clazz = cinfo.getContentClass())) {
                    isUsed[i] = true;
                } else if (clazz.equals(class$java$lang$String == null ? MirageFormatter.class$("java.lang.String") : class$java$lang$String)) {
                    isUsed[i] = true;
                    isText[i] = true;
                    ++nText;
                } else {
                    this.strm.println("# Omitted column " + i + ": " + cinfo);
                }
            }
            ++i;
        }
        this.strm.println("#\n# Column names");
        this.strm.print("format var");
        int i2 = 0;
        while (i2 < ncol) {
            if (isUsed[i2]) {
                this.strm.print(" " + colNames[i2]);
            }
            ++i2;
        }
        this.strm.println();
        if (nText > 0) {
            this.strm.println("#\n# Text columns");
            int i3 = 0;
            while (i3 < ncol) {
                if (isText[i3]) {
                    this.strm.println("format text " + colNames[i3]);
                }
                ++i3;
            }
        }
        this.strm.println("#\n# Table data");
        RowSequence rseq = table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                int i4 = 0;
                while (i4 < ncol) {
                    if (isUsed[i4]) {
                        String cell;
                        Object datum = row[i4];
                        if (datum == null) {
                            cell = "<blank>";
                        } else {
                            cell = row[i4].toString().trim();
                            if (isText[i4]) {
                                cell = cell.length() == 0 ? "<blank>" : cell.replaceAll("\\s+", "_");
                            }
                        }
                        this.strm.print(cell);
                        this.strm.print(' ');
                    }
                    ++i4;
                }
                this.strm.println();
            }
            Object var15_18 = null;
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            rseq.close();
            throw throwable;
        }
        rseq.close();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public static void main(String[] args) throws IOException {
        StarTable tab;
        String usage = "Usage: MirageFormatter table\n";
        if (args.length != 1) {
            System.err.println(usage);
            System.exit(1);
        }
        if ((tab = new StarTableFactory(false).makeStarTable(args[0])) == null) {
            System.err.println("No known table " + args[0]);
            System.exit(1);
        }
        new MirageFormatter(System.out).writeMirageFormat(tab);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

