/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.ConvertArrayImpl;
import uk.ac.starlink.array.Function;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.array.TypeConverter;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndtools.SumDoer;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;

class ConstArithmetic
implements Task {
    private SumDoer iworker;
    private SumDoer vworker;
    private ExistingNdxParameter inpar;
    private NewNdxParameter outpar;
    private DoubleParameter constpar;

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.constpar};
    }

    public String getUsage() {
        return "in out const";
    }

    public ConstArithmetic(SumDoer iworker, SumDoer vworker) {
        this.iworker = iworker;
        this.vworker = vworker;
        this.inpar = new ExistingNdxParameter("in");
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPrompt("Output NDX");
        this.outpar.setPosition(2);
        this.constpar = new DoubleParameter("const");
        this.constpar.setPrompt("Constant value");
        this.constpar.setPosition(3);
    }

    public void invoke(Environment env) throws ParameterValueException, AbortException {
        NDArray im;
        Ndx ndx1 = this.inpar.ndxValue();
        final double c = this.constpar.doubleValue();
        NDArray im1 = ndx1.getImage();
        if (this.iworker == null) {
            im = im1;
        } else {
            Type itype = im1.getType();
            BadHandler ibh = im1.getBadHandler();
            Function ifunc = new Function(){

                public double forward(double x) {
                    return ConstArithmetic.this.iworker.doSum(x, c);
                }

                public double inverse(double y) {
                    throw new AssertionError();
                }
            };
            TypeConverter iconv = new TypeConverter(itype, ibh, itype, ibh, ifunc);
            im = new BridgeNDArray(new ConvertArrayImpl(im1, iconv));
        }
        NDArray var = null;
        if (ndx1.hasVariance()) {
            NDArray var1 = ndx1.getVariance();
            if (this.vworker == null) {
                var = var1;
            } else {
                Type vtype = var1.getType();
                BadHandler vbh = var1.getBadHandler();
                Function vfunc = new Function(){

                    public double forward(double x) {
                        return ConstArithmetic.this.vworker.doSum(x, c);
                    }

                    public double inverse(double y) {
                        throw new AssertionError();
                    }
                };
                TypeConverter vconv = new TypeConverter(vtype, vbh, vtype, vbh, vfunc);
                var = new BridgeNDArray(new ConvertArrayImpl(var1, vconv));
            }
        }
        NDArray qual = null;
        if (ndx1.hasQuality()) {
            qual = ndx1.getQuality();
        }
        DefaultMutableNdx ndx2 = new DefaultMutableNdx(im);
        ndx2.setVariance(var);
        ndx2.setVariance(qual);
        this.outpar.outputNdx(ndx2);
    }
}

