/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndtools.TypeParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;

class SetType
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");
    private NewNdxParameter outpar;
    private TypeParameter typepar;

    public SetType() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPrompt("Output NDX");
        this.outpar.setPosition(2);
        this.typepar = new TypeParameter("type");
        this.typepar.setPrompt("New type");
        this.typepar.setPosition(3);
    }

    public String getUsage() {
        return "in out newtype";
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.typepar};
    }

    public void invoke(Environment env) throws ParameterValueException, AbortException, IOException {
        Ndx ndx1 = this.inpar.ndxValue();
        Type type = this.typepar.typeValue();
        Requirements req = new Requirements(AccessMode.READ).setType(type);
        NDArray image = NDArrays.toRequiredArray(ndx1.getImage(), req);
        NDArray variance = null;
        if (ndx1.hasVariance()) {
            variance = NDArrays.toRequiredArray(ndx1.getVariance(), req);
        }
        NDArray quality = null;
        if (ndx1.hasQuality()) {
            quality = ndx1.getQuality();
        }
        DefaultMutableNdx ndx2 = new DefaultMutableNdx(ndx1);
        ndx2.setImage(image);
        ndx2.setVariance(variance);
        ndx2.setQuality(quality);
        this.outpar.outputNdx(ndx2);
    }
}

