/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.ChunkStepper;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;

class SlowBlock
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");
    private NewNdxParameter outpar;
    private IntegerParameter blockpar;

    SlowBlock() {
        this.inpar.setPosition(1);
        this.inpar.setPrompt("Input NDX");
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPosition(2);
        this.outpar.setPrompt("Output NDX");
        this.blockpar = new IntegerParameter("block");
        this.blockpar.setPosition(3);
        this.blockpar.setPrompt("Size of block in pixels");
        this.blockpar.setOdd();
        this.blockpar.setMinimum(1);
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.blockpar};
    }

    public String getUsage() {
        return "in out block";
    }

    public void invoke(Environment env) throws ParameterValueException, ExecutionException, AbortException, IOException {
        Ndx ndx1 = this.inpar.ndxValue();
        DefaultMutableNdx template = new DefaultMutableNdx(ndx1);
        template.setImage(ndx1.getImage());
        Ndx ndx2 = this.outpar.getOutputNdx(template);
        NDArray im1 = ndx1.getImage();
        Requirements req1 = new Requirements(AccessMode.READ).setRandom(true);
        im1 = NDArrays.toRequiredArray(im1, req1);
        NDArray im2 = ndx2.getImage();
        OrderedNDShape shape = im1.getShape();
        Type type = im1.getType();
        BadHandler bh1 = im1.getBadHandler();
        BadHandler bh2 = im2.getBadHandler();
        Order order2 = im2.getShape().getOrder();
        int ndim = shape.getNumDims();
        long npix = shape.getNumPixels();
        int block = this.blockpar.intValue();
        int gap = (block - 1) / 2;
        long[] boxDims = new long[ndim];
        int boxpix = 1;
        int i = 0;
        while (i < ndim) {
            boxDims[i] = block;
            boxpix *= block;
            ++i;
        }
        long[] samplesOrigin = new long[ndim];
        long[] samplesDims = shape.getDims();
        int i2 = 0;
        while (i2 < ndim) {
            samplesOrigin[i2] = shape.getOrigin()[i2] - (long)gap;
            ++i2;
        }
        OrderedNDShape samplesSequence = new OrderedNDShape(samplesOrigin, samplesDims, order2);
        Iterator samplesIt = samplesSequence.pixelIterator();
        ArrayAccess iacc1 = im1.getAccess();
        ArrayAccess iacc2 = im2.getAccess();
        ChunkStepper chunkIt = new ChunkStepper(npix);
        Object buf2 = type.newArray(chunkIt.getSize());
        Object boxBuf = type.newArray(boxpix);
        Blocker blocker = SlowBlock.makeBlocker(type, boxBuf, buf2, bh1, bh2);
        while (chunkIt.hasNext()) {
            int size = chunkIt.getSize();
            int i3 = 0;
            while (i3 < size) {
                long[] boxOrigin = (long[])samplesIt.next();
                NDShape boxTile = new NDShape(boxOrigin, boxDims);
                iacc1.readTile(boxBuf, boxTile);
                blocker.calculateElement(i3);
                ++i3;
            }
            iacc2.write(buf2, 0, size);
            chunkIt.next();
        }
        iacc1.close();
        iacc2.close();
        im1.close();
        im2.close();
    }

    private static Blocker makeBlocker(Type type, final Object inbuf, final Object outbuf, BadHandler inbh, final BadHandler outbh) throws ExecutionException {
        final int size = Array.getLength(inbuf);
        final BadHandler.ArrayHandler inAh = inbh.arrayHandler(inbuf);
        if (type == Type.BYTE) {
            return new Blocker(){
                byte[] inBuffer;
                byte[] outBuffer;
                byte badval;
                {
                    this.inBuffer = (byte[])inbuf;
                    this.outBuffer = (byte[])outbuf;
                    this.badval = outbh.getBadValue().byteValue();
                }

                public void calculateElement(int outPos) {
                    int ngood = 0;
                    double sum = 0.0;
                    int i = 0;
                    while (i < size) {
                        if (!inAh.isBad(i)) {
                            ++ngood;
                            sum += (double)this.inBuffer[i];
                        }
                        ++i;
                    }
                    this.outBuffer[outPos] = ngood > 0 ? (byte)Math.round(sum / (double)ngood) : this.badval;
                }
            };
        }
        if (type == Type.SHORT) {
            return new Blocker(){
                short[] inBuffer;
                short[] outBuffer;
                short badval;
                {
                    this.inBuffer = (short[])inbuf;
                    this.outBuffer = (short[])outbuf;
                    this.badval = outbh.getBadValue().shortValue();
                }

                public void calculateElement(int outPos) {
                    int ngood = 0;
                    double sum = 0.0;
                    int i = 0;
                    while (i < size) {
                        if (!inAh.isBad(i)) {
                            ++ngood;
                            sum += (double)this.inBuffer[i];
                        }
                        ++i;
                    }
                    this.outBuffer[outPos] = ngood > 0 ? (short)Math.round(sum / (double)ngood) : this.badval;
                }
            };
        }
        if (type == Type.INT) {
            return new Blocker(){
                int[] inBuffer;
                int[] outBuffer;
                int badval;
                {
                    this.inBuffer = (int[])inbuf;
                    this.outBuffer = (int[])outbuf;
                    this.badval = outbh.getBadValue().intValue();
                }

                public void calculateElement(int outPos) {
                    int ngood = 0;
                    double sum = 0.0;
                    int i = 0;
                    while (i < size) {
                        if (!inAh.isBad(i)) {
                            ++ngood;
                            sum += (double)this.inBuffer[i];
                        }
                        ++i;
                    }
                    this.outBuffer[outPos] = ngood > 0 ? (int)Math.round(sum / (double)ngood) : this.badval;
                }
            };
        }
        if (type == Type.FLOAT) {
            return new Blocker(){
                float[] inBuffer;
                float[] outBuffer;
                float badval;
                {
                    this.inBuffer = (float[])inbuf;
                    this.outBuffer = (float[])outbuf;
                    this.badval = outbh.getBadValue().floatValue();
                }

                public void calculateElement(int outPos) {
                    int ngood = 0;
                    double sum = 0.0;
                    int i = 0;
                    while (i < size) {
                        if (!inAh.isBad(i)) {
                            ++ngood;
                            sum += (double)this.inBuffer[i];
                        }
                        ++i;
                    }
                    this.outBuffer[outPos] = ngood > 0 ? (float)(sum / (double)ngood) : this.badval;
                }
            };
        }
        if (type == Type.DOUBLE) {
            return new Blocker(){
                double[] inBuffer;
                double[] outBuffer;
                double badval;
                {
                    this.inBuffer = (double[])inbuf;
                    this.outBuffer = (double[])outbuf;
                    this.badval = outbh.getBadValue().doubleValue();
                }

                public void calculateElement(int outPos) {
                    int ngood = 0;
                    double sum = 0.0;
                    int i = 0;
                    while (i < size) {
                        if (!inAh.isBad(i)) {
                            ++ngood;
                            sum += this.inBuffer[i];
                        }
                        ++i;
                    }
                    this.outBuffer[outPos] = ngood > 0 ? sum / (double)ngood : this.badval;
                }
            };
        }
        throw new ExecutionException("Unknown data type " + type);
    }

    private static interface Blocker {
        public void calculateElement(int var1);
    }
}

