/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import java.io.PrintStream;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.StatsValues;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;

class Stats
implements Task {
    private ExistingNdxParameter inpar = new ExistingNdxParameter("in");

    public Stats() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar};
    }

    public String getUsage() {
        return "in";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(Environment env) throws ParameterValueException, AbortException, IOException {
        StatsValues answers;
        long npix;
        String title;
        block6: {
            NDArray nda = null;
            try {
                Ndx ndx = this.inpar.ndxValue();
                title = ndx.hasTitle() ? ndx.getTitle() : null;
                nda = Ndxs.getMaskedImage(ndx);
                npix = nda.getShape().getNumPixels();
                answers = new StatsValues(nda);
                Object var9_7 = null;
                if (nda == null) break block6;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (nda != null) {
                    nda.close();
                }
                throw throwable;
            }
            nda.close();
        }
        float sum = (float)answers.total;
        float mean = (float)answers.mean;
        float stdev = (float)Math.sqrt(answers.variance);
        Number minval = answers.minValue;
        Number maxval = answers.maxValue;
        String minpos = NDShape.toString(answers.minPosition);
        String maxpos = NDShape.toString(answers.maxPosition);
        long ngood = answers.numGood;
        long nbad = npix - ngood;
        float pcgood = (float)(100.0 * (double)ngood / (double)npix);
        float pcbad = (float)(100.0 * (double)nbad / (double)npix);
        PrintStream pstrm = env.getPrintStream();
        pstrm.println("Title:   " + title);
        if (ngood > 0L) {
            pstrm.println("   Pixel sum              : " + sum);
            pstrm.println("   Pixel mean             : " + mean);
            pstrm.println("   Standard deviation     : " + stdev);
            pstrm.println("   Minimum pixel value    : " + minval);
            pstrm.println("      At pixel            : " + minpos);
            pstrm.println("   Maximum pixel value    : " + maxval);
            pstrm.println("      At pixel            : " + maxpos);
            pstrm.println("   Total number of pixels : " + npix);
            pstrm.println("   Number of pixels used  : " + ngood + " (" + pcgood + "%)");
            if (nbad > 0L) {
                pstrm.println("   No. of pixels excluded : " + nbad + " (" + pcbad + "%)");
            }
        } else {
            pstrm.println("No good pixels");
        }
        pstrm.println();
    }
}

