/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndtools;

import java.io.IOException;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrays;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Requirements;
import uk.ac.starlink.ndtools.ExistingNdxParameter;
import uk.ac.starlink.ndtools.NewNdxParameter;
import uk.ac.starlink.ndtools.ShapeParameter;
import uk.ac.starlink.ndx.DefaultMutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.task.AbortException;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;

class Window
implements Task {
    ExistingNdxParameter inpar = new ExistingNdxParameter("in");
    NewNdxParameter outpar;
    ShapeParameter shapepar;

    public Window() {
        this.inpar.setPrompt("Input NDX");
        this.inpar.setPosition(1);
        this.outpar = new NewNdxParameter("out");
        this.outpar.setPrompt("Output NDX");
        this.outpar.setPosition(2);
        this.shapepar = new ShapeParameter("shape");
        this.shapepar.setPrompt("New shape specification");
        this.shapepar.setPosition(3);
    }

    public Parameter[] getParameters() {
        return new Parameter[]{this.inpar, this.outpar, this.shapepar};
    }

    public String getUsage() {
        return "in out shape";
    }

    public void invoke(Environment env) throws ParameterValueException, AbortException, IOException {
        NDShape shape = this.shapepar.shapeValue();
        Ndx ndx1 = this.inpar.ndxValue();
        Requirements req = new Requirements(AccessMode.READ).setWindow(shape);
        NDArray im = NDArrays.toRequiredArray(ndx1.getImage(), req);
        NDArray var = null;
        if (ndx1.hasVariance()) {
            var = NDArrays.toRequiredArray(ndx1.getVariance(), req);
        }
        NDArray qual = null;
        if (ndx1.hasQuality()) {
            qual = NDArrays.toRequiredArray(ndx1.getQuality(), req);
        }
        DefaultMutableNdx ndx2 = new DefaultMutableNdx(im);
        ndx2.setVariance(var);
        ndx2.setQuality(qual);
        this.outpar.outputNdx(ndx2);
    }
}

