/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.astrogrid.AstroGridException;
import org.astrogrid.Log;
import org.astrogrid.TemplateManager;
import org.astrogrid.i18n.AstroGridMessage;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.handler.InputStreamHandler;
import org.jconfig.handler.URLHandler;
import org.jconfig.handler.XMLFileHandler;

public abstract class Configurator {
    private static final String ASTROGRIDERROR_COULD_NOT_READ_CONFIGFILE = "AG{0}Z00001:{1}: Could not read my configuration file {2}. Missing file or malformed XML.";
    private static final String ASTROGRIDERROR_COMPONENT_NOT_INITIALIZED = "AG{0}Z00002:{1}: Not initialized. Perhaps my configuration file is missing or contains malformed XML.";
    public static final String GENERAL_CATEGORY = "GENERAL";
    public static final String GENERAL_VERSION_NUMBER = "VERSION";
    private static final String TEMPLATE = "TEMPLATE.";
    private static Hashtable loadedConfigurations;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Configurator() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Log.trace("Configurator.init(): entry");
        try {
            if (Configurator.getConfig(this.getSubsystemAcronym(), this.getConfigFileName(), this.getJNDIName()) == null) {
                AstroGridMessage message = new AstroGridMessage(ASTROGRIDERROR_COULD_NOT_READ_CONFIGFILE, this.getSubsystemAcronym(), Configurator.getClassName(Configurator.class), this.getConfigFileName());
                Log.logError(message.toString());
                return;
            }
            try {
                AstroGridMessage.loadMessages(this.getSubsystemAcronym());
            }
            catch (AstroGridException agex) {
                Log.logError(agex.getAstroGridMessage().toString());
            }
        }
        finally {
            Log.trace("Configurator.init(): exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkPropertiesLoaded() throws AstroGridException {
        Log.trace("checkPropertiesLoaded() entry");
        String check = "NOT LOADED";
        Configuration config = Configurator.getConfig(this.getSubsystemAcronym(), this.getConfigFileName(), this.getJNDIName());
        try {
            if (config == null || config.getProperty(GENERAL_VERSION_NUMBER, check, GENERAL_CATEGORY).equals(check)) {
                AstroGridMessage message = new AstroGridMessage(ASTROGRIDERROR_COMPONENT_NOT_INITIALIZED, this.getSubsystemAcronym(), Configurator.getClassName(Configurator.class));
                Log.logError(message.toString());
                throw new AstroGridException(message);
            }
        }
        finally {
            Log.trace("checkPropertiesLoaded() exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String subsystemAcronym, String key, String category) {
        Log.trace("getProperty() entry");
        String targetProperty = null;
        try {
            Configuration config = ConfigurationManager.getConfiguration((String)subsystemAcronym);
            targetProperty = config.getProperty(key, "", category).trim();
            if (key.startsWith(TEMPLATE)) {
                targetProperty = TemplateManager.getInstance().getTemplate(subsystemAcronym, targetProperty);
            }
        }
        finally {
            Log.trace("getProperty() exit");
        }
        return targetProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String subsystemAcronym, String key, String category, String value) {
        Log.trace("setProperty() entry");
        try {
            Configuration config = ConfigurationManager.getConfiguration((String)subsystemAcronym);
            config.setProperty(key, value, category);
            if (key.startsWith(TEMPLATE)) {
                throw new UnsupportedOperationException("This method isn't supported for TEMPLATEs");
            }
        }
        finally {
            Log.trace("setProperty() exit");
        }
    }

    public static void save(String subsystemAcronym, String configFileName) throws AstroGridException {
        Log.trace("save() entry");
        try {
            Configuration config = ConfigurationManager.getConfiguration((String)subsystemAcronym);
            XMLFileHandler handler = new XMLFileHandler(configFileName);
            ConfigurationManager.getInstance().save((ConfigurationHandler)handler, config);
        }
        catch (ConfigurationManagerException e) {
            Log.logError("Error saving configuration file ", e);
            throw new AstroGridException(e);
        }
        finally {
            Log.trace("save() exit");
        }
    }

    public final void save() throws AstroGridException {
        if (!$assertionsDisabled && this.getSubsystemAcronym() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getConfigFileName() == null) {
            throw new AssertionError();
        }
        this.save(this.getConfigFileName());
    }

    public final void save(String fileName) throws AstroGridException {
        if (!$assertionsDisabled && this.getSubsystemAcronym() == null) {
            throw new AssertionError();
        }
        Configurator.save(this.getSubsystemAcronym(), fileName);
    }

    protected abstract String getConfigFileName();

    protected abstract String getSubsystemAcronym();

    protected abstract String getJNDIName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Configuration getConfig(String subsystemAcronym, String configFileName, String jndiName) {
        Log.trace("Configurator.getConfig(): entry");
        if (!$assertionsDisabled && subsystemAcronym == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configFileName == null && jndiName == null) {
            throw new AssertionError((Object)"Either configFileName or jndiName must be nonnull");
        }
        Configuration configuration = null;
        try {
            if (!loadedConfigurations.containsKey(subsystemAcronym)) {
                InputStreamHandler handler = null;
                if (jndiName != null) {
                    try {
                        InitialContext ic = new InitialContext();
                        String url = (String)ic.lookup(jndiName);
                        URLHandler urlHandler = new URLHandler();
                        if (!$assertionsDisabled && url == null) {
                            throw new AssertionError();
                        }
                        urlHandler.setURL(url);
                        handler = urlHandler;
                    }
                    catch (NamingException ne) {
                        Log.logDebug("No InitialContext in Configurator:getConfig - unable to get log file URL from JNDI - switch to loading from classpath", ne);
                    }
                }
                if (handler == null) {
                    handler = new InputStreamHandler(configFileName);
                }
                ConfigurationManager.getInstance().load(handler, subsystemAcronym);
                loadedConfigurations.put(subsystemAcronym, configFileName);
            }
            configuration = ConfigurationManager.getConfiguration((String)subsystemAcronym);
        }
        catch (Exception cme) {
            Log.logError("Could not get config subsystem '" + subsystemAcronym + "', filename '" + configFileName + "'", cme);
        }
        finally {
            Log.trace("Configurator.getConfig(): exit");
        }
        return configuration;
    }

    public static String getClassName(Class cls) {
        String componentName = cls.getName();
        int iLastPoint = componentName.lastIndexOf(46);
        return componentName.substring(iLastPoint + 1);
    }

    static {
        $assertionsDisabled = !Configurator.class.desiredAssertionStatus();
        loadedConfigurations = new Hashtable();
    }
}

