/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.common.creator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.log4j.Category;
import org.astrogrid.common.creator.InstanceCreatorException;

public class InstanceCreator {
    private Category logger = Category.getInstance(this.getClass());
    private static final String DEFAULT_METHOD = "getInstance";

    public Object getInstance(String className) throws InstanceCreatorException {
        return this.getInstance(className, null, null);
    }

    public Object getInstance(String className, Object[] parameters) throws InstanceCreatorException {
        return this.getInstance(className, null, parameters);
    }

    public Object getInstance(String className, String methodName, Object[] parameters) throws InstanceCreatorException {
        Object result;
        block9: {
            result = null;
            if (methodName == null || methodName.length() < 1) {
                methodName = DEFAULT_METHOD;
            }
            try {
                Class<?> clazz = Class.forName(className);
                Class[] classes = this.getParameterClasses(parameters);
                Method method = null;
                try {
                    method = clazz.getMethod(methodName, classes);
                }
                catch (NoSuchMethodException e) {
                    classes = this.convertPrimitives(classes);
                    method = clazz.getMethod(methodName, classes);
                }
                int modifiers = method.getModifiers();
                if (!Modifier.isStatic(modifiers)) break block9;
                try {
                    result = method.invoke(null, parameters);
                }
                catch (IllegalAccessException e) {
                    throw new InstanceCreatorException(e);
                }
                catch (InvocationTargetException e) {
                    throw new InstanceCreatorException(e);
                }
            }
            catch (ClassNotFoundException e) {
                throw new InstanceCreatorException(e);
            }
            catch (NoSuchMethodException e) {
                throw new InstanceCreatorException(e);
            }
        }
        return result;
    }

    private Class[] getParameterClasses(Object[] parameters) {
        Class[] result = null;
        if (parameters != null && parameters.length > 0) {
            result = new Class[parameters.length];
            for (int paramIndex = 0; paramIndex < parameters.length; ++paramIndex) {
                result[paramIndex] = parameters[paramIndex].getClass();
            }
        }
        return result;
    }

    private Class[] convertPrimitives(Class[] classes) {
        Class[] result = null;
        if (classes != null && classes.length > 0) {
            result = new Class[classes.length];
            for (int classIndex = 0; classIndex < classes.length; ++classIndex) {
                result[classIndex] = this.convertPrimitive(classes[classIndex]);
            }
        }
        return result;
    }

    private Class convertPrimitive(Class clazz) {
        Class result = clazz;
        this.logger.debug((Object)("class: " + clazz.getName()));
        try {
            Class<?> fieldClazz;
            Field field = clazz.getField("TYPE");
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && (fieldClazz = field.getType()).isAssignableFrom(Class.class)) {
                result = (Class)field.get(null);
            }
        }
        catch (NoSuchFieldException e) {
            this.logger.debug((Object)("no TYPE for class: " + result.getName()));
        }
        catch (IllegalAccessException e) {
            this.logger.debug((Object)("illegal access: " + result.getName()));
        }
        this.logger.debug((Object)("result: " + result.getName()));
        this.logger.debug((Object)("Integer.TYPE: " + Integer.TYPE.getName()));
        return result;
    }
}

