/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community;

import org.astrogrid.community.User;
import org.astrogrid.community.common.util.CommunityMessage;

public class Account {
    private String individual = null;
    private String community = null;
    private String token = null;
    public static final Account ANONYMOUS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Account() {
        this("Anonymous", "Unknown", null);
    }

    public Account(String anIndividual, String aCommunity, String aToken) {
        if (!($assertionsDisabled || anIndividual != null && anIndividual.length() > 0)) {
            throw new AssertionError((Object)"an Individual must be given");
        }
        if (!($assertionsDisabled || aCommunity != null && aCommunity.length() > 0)) {
            throw new AssertionError((Object)"a Community must be given");
        }
        this.individual = anIndividual;
        this.community = aCommunity;
        this.token = aToken;
    }

    public Account(String snippet) {
        this(CommunityMessage.getAccount(snippet).substring(0, CommunityMessage.getAccount(snippet).indexOf("@")), CommunityMessage.getAccount(snippet).substring(CommunityMessage.getAccount(snippet).indexOf("@") + 1), CommunityMessage.getToken(snippet));
    }

    public String getIndividual() {
        return this.individual;
    }

    public String getAstrogridId() {
        return this.individual + "@" + this.community;
    }

    public String getIvorn() {
        return "ivo://" + this.community + "/" + this.individual;
    }

    public String getCommunity() {
        return this.community;
    }

    public String getToken() {
        return this.token;
    }

    public boolean equals(Account user) {
        return user.getIvorn().equals(this.getIvorn());
    }

    public String toString() {
        return this.getAstrogridId();
    }

    public String toSnippet() {
        return CommunityMessage.getMessage(this.token, this.getAstrogridId(), "(NoGroup)");
    }

    public User toUser() {
        return new User(this.getIndividual(), this.getCommunity(), "(NoGroup)", this.getToken());
    }

    static {
        $assertionsDisabled = !Account.class.desiredAssertionStatus();
        ANONYMOUS = new Account("Anonymous", "Unknown", null);
    }
}

