/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community;

import org.astrogrid.community.common.util.CommunityMessage;

public class User {
    String account = null;
    String group = null;
    String token = null;
    public static final User ANONYMOUS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public User() {
        this("Anon@nowhere", "Anonymous", "None");
    }

    public User(String givenAccount, String givenGroup, String givenToken) {
        this.account = givenAccount;
        if (!$assertionsDisabled && givenAccount == null) {
            throw new AssertionError((Object)"account must be supplied");
        }
        if (!$assertionsDisabled && givenAccount.indexOf(64) == -1) {
            throw new AssertionError((Object)"account must be of the form user@community");
        }
        this.group = givenGroup;
        this.token = givenToken;
    }

    public User(String userId, String community, String group, String token) {
        this.account = userId + "@" + community;
        this.group = group;
        this.token = token;
    }

    public User(String snippet) {
        this(CommunityMessage.getAccount(snippet), CommunityMessage.getGroup(snippet), CommunityMessage.getToken(snippet));
    }

    public String getAccount() {
        return this.account;
    }

    public String getGroup() {
        return this.group;
    }

    public String getToken() {
        return this.token;
    }

    public void setAccount(String string) {
        this.account = string;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public boolean equals(User user) {
        return user.getAccount().equals(this.account) && user.getGroup().equals(this.group);
    }

    public String toString() {
        return this.account;
    }

    public String toSnippet() {
        return CommunityMessage.getMessage(this.token, this.account, this.group);
    }

    public String getCommunity() {
        int i;
        if (this.account != null && (i = this.account.indexOf("@")) != -1) {
            return this.account.substring(i + 1);
        }
        return null;
    }

    public String getUserId() {
        if (this.account != null) {
            int i = this.account.indexOf("@");
            if (i != -1) {
                return this.account.substring(0, i);
            }
            return this.account;
        }
        return null;
    }

    static {
        $assertionsDisabled = !User.class.desiredAssertionStatus();
        ANONYMOUS = new User("Anon@nowhere", "Anonymous", "None");
    }
}

