/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.component;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.component.ComponentManager;
import org.astrogrid.component.descriptor.ComponentDescriptor;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;

public class EmptyComponentManager
implements ComponentManager {
    protected static final Log log = LogFactory.getLog((Class)EmptyComponentManager.class);
    protected final MutablePicoContainer pico = new DefaultPicoContainer();

    public String informationHTML() {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        p.println("<h1>Component Information</h1>");
        Iterator i = this.getContainer().getComponentInstances().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ComponentDescriptor) {
                ComponentDescriptor descr = (ComponentDescriptor)o;
                p.println("<b>" + descr.getName() + "</b> ");
                p.println("<blockquote><pre>" + descr.getDescription() + "</pre></blockquote>");
            } else {
                p.println(o.getClass().getName() + ":" + o.toString());
            }
            p.println("<hr/>");
        }
        return sw.toString();
    }

    public String information() {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter(sw);
        p.println("Component Information");
        p.println("-------------------------------");
        Iterator i = this.getContainer().getComponentInstances().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ComponentDescriptor) {
                ComponentDescriptor descr = (ComponentDescriptor)o;
                p.println(descr.getName());
                p.println(descr.getDescription());
            } else {
                p.println(o.getClass().getName() + ":" + o.toString());
            }
            p.println();
        }
        return sw.toString();
    }

    public Test getSuite() {
        TestSuite result = new TestSuite("Installation Tests");
        Iterator i = this.getContainer().getComponentInstances().iterator();
        while (i.hasNext()) {
            ComponentDescriptor descr;
            Test test;
            Object o = i.next();
            if (!(o instanceof ComponentDescriptor) || (test = (descr = (ComponentDescriptor)o).getInstallationTest()) == null) continue;
            result.addTest(test);
        }
        return result;
    }

    public MutablePicoContainer getContainer() {
        return this.pico;
    }

    public void start() {
        log.info((Object)"Starting component manager");
        this.pico.start();
    }

    public void stop() {
        log.info((Object)"Stopping component manager");
        this.pico.stop();
    }
}

