/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.ConfigException;
import org.astrogrid.config.PropertyNotFoundException;
import org.astrogrid.util.DomHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class Config {
    protected Log log = LogFactory.getLog((Class)Config.class);
    private String loadedFrom = null;

    public abstract Object getProperty(String var1) throws PropertyNotFoundException;

    public abstract void setProperty(String var1, Object var2);

    public abstract Object[] getProperties(String var1) throws PropertyNotFoundException;

    public abstract void setProperties(String var1, Object[] var2);

    public abstract void loadFromUrl(URL var1) throws IOException;

    public abstract void dumpConfig(Writer var1);

    public abstract Set keySet();

    protected void addLoadedFrom(String s) {
        this.loadedFrom = this.loadedFrom == null ? s : this.loadedFrom + ", " + s;
    }

    public String loadedFrom() {
        if (this.loadedFrom == null) {
            return "(config not loaded yet)";
        }
        return this.loadedFrom;
    }

    public Object getProperty(String key, Object defaultValue) {
        try {
            return this.getProperty(key);
        }
        catch (PropertyNotFoundException nnfe) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.getProperty(key).toString();
    }

    public String getString(String key, String defaultValue) {
        Object o = this.getProperty(key, defaultValue);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public URL getUrl(String key) {
        try {
            return new URL(this.getProperty(key).toString());
        }
        catch (MalformedURLException mue) {
            throw new ConfigException("Key '" + key + "' returns invalid URL '" + this.getProperty(key) + "'", mue);
        }
    }

    public URL getUrl(String key, URL defaultValue) {
        try {
            return this.getUrl(key);
        }
        catch (PropertyNotFoundException nfe) {
            return defaultValue;
        }
    }

    public int getInt(String key) {
        try {
            return Integer.parseInt(this.getProperty(key).toString().trim());
        }
        catch (NumberFormatException nfe) {
            throw new ConfigException("Key '" + key + "' returns invalid integer '" + this.getProperty(key) + "'", nfe);
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (PropertyNotFoundException nfe) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (PropertyNotFoundException nfe) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.getProperty(key).toString());
    }

    public Document getDom(String key) {
        return this.readDom(key, this.getUrl(key));
    }

    public Document getDom(String key, Document defaultDom) {
        try {
            return this.getDom(key);
        }
        catch (PropertyNotFoundException nfe) {
            return defaultDom;
        }
    }

    public Document getDom(String key, URL defaultUrl) {
        try {
            return this.getDom(key);
        }
        catch (PropertyNotFoundException nfe) {
            return this.readDom("(default, key '" + key + "' not found)", defaultUrl);
        }
    }

    private Document readDom(String key, URL source) {
        try {
            return DomHelper.newDocument(source.openStream());
        }
        catch (IOException ioe) {
            throw new ConfigException("Could not read from '" + source + "' given by Config Key '" + key + "'", ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigException("Application not configured correctly: ", pce);
        }
        catch (SAXException se) {
            throw new ConfigException("Invalid XML in '" + source + "' from Config Key '" + key + "'");
        }
    }

    public static URL resolveFilename(String givenFilename) throws IOException {
        File f;
        String filename = givenFilename;
        filename = Config.resolveEnvironmentVariables(filename);
        String msg = givenFilename;
        if (!givenFilename.equals(filename)) {
            msg = msg + " (resolves to " + filename + ")";
        }
        if ((f = new File(filename)).isAbsolute()) {
            if (f.exists() && f.isFile()) {
                return f.toURL();
            }
            throw new FileNotFoundException(msg);
        }
        URL url = Config.class.getClassLoader().getResource(filename);
        if (url != null) {
            return url;
        }
        if (f.exists() && f.isFile()) {
            return f.toURL();
        }
        throw new FileNotFoundException(msg + " not found in classpath or working directory");
    }

    public static String resolveEnvironmentVariables(String givenSource) {
        String source = givenSource;
        while (source.indexOf("${") > -1) {
            int s = source.indexOf("${");
            int e = source.indexOf("}");
            if (e == -1) {
                throw new IllegalArgumentException("String " + givenSource + " has mismatched brackets");
            }
            String sysEnvKey = source.substring(s + 2, e);
            String sysEnvValue = System.getProperty(sysEnvKey);
            if (sysEnvValue == null && sysEnvKey.equals("host.path")) {
                sysEnvValue = Config.getDeploymentId();
            }
            if (sysEnvValue == null) {
                throw new ConfigException("Sys Env '" + sysEnvKey + "' not found for filename " + givenSource);
            }
            source = source.substring(0, s) + sysEnvValue + source.substring(e + 1);
        }
        return source;
    }

    public static String getDeploymentId() {
        return null;
    }
}

