/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.ServiceUnavailableException;
import org.astrogrid.config.Config;
import org.astrogrid.config.ConfigException;
import org.astrogrid.config.PropertyNotFoundException;

public class FailbackConfig
extends Config {
    private Hashtable cache = new Hashtable();
    private boolean jndiInitialised = false;
    private boolean fileInitialised = false;
    private InitialContext jndiContext = null;
    private Properties properties = null;
    private static String propertyUrlKey;
    private static String propertyKey;
    private static String jndiPrefix;
    private static String configFilename;
    private static String defaultFilename;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected FailbackConfig(Object context) {
    }

    public void setConfigFilename(String newName) {
        if (this.fileInitialised) {
            throw new ConfigException("Configuration already initialised - too late to set config filename", null);
        }
        configFilename = newName;
    }

    private synchronized void initialiseJndi() {
        if (!this.jndiInitialised) {
            this.jndiInitialised = true;
            try {
                this.jndiContext = new InitialContext();
                try {
                    this.jndiContext.lookup("java:comp/env");
                    this.addLoadedFrom("JNDI");
                }
                catch (NameNotFoundException nnfe) {
                    // empty catch block
                }
                this.log.info((Object)("Config access to JNDI initialised (" + this.jndiContext + ")"));
            }
            catch (ServiceUnavailableException sue) {
                this.log.debug((Object)("No JNDI service found (" + sue + ") so will not use JNDI for config..."));
                this.jndiContext = null;
            }
            catch (NoInitialContextException nice) {
                this.log.debug((Object)("No JNDI service found (" + nice + ") so will not use JNDI for config..."));
                this.jndiContext = null;
            }
            catch (NamingException ne) {
                throw new ConfigException("Initialising Jndi Access", ne);
            }
        }
    }

    private synchronized void initialiseFile() {
        if (!this.fileInitialised) {
            this.fileInitialised = true;
            URL fileUrl = null;
            String urlValue = null;
            String filenameValue = null;
            if (this.jndiContext != null) {
                String jndiUrlKey = jndiPrefix + propertyUrlKey;
                String jndiFileKey = jndiPrefix + propertyKey;
                String keyUsed = jndiUrlKey;
                try {
                    try {
                        urlValue = this.jndiContext.lookup(jndiUrlKey).toString().trim();
                        fileUrl = new URL(urlValue);
                    }
                    catch (NameNotFoundException nnfe) {
                        // empty catch block
                    }
                    this.log.debug((Object)("Config: JNDI key " + jndiUrlKey + " => " + fileUrl));
                    try {
                        filenameValue = this.jndiContext.lookup(jndiFileKey).toString().trim();
                    }
                    catch (NameNotFoundException nnfe) {
                        // empty catch block
                    }
                    this.log.debug((Object)("Config: JNDI key " + jndiFileKey + " => " + filenameValue));
                    if (fileUrl != null && filenameValue != null) {
                        throw new ConfigException("Both " + jndiUrlKey + " and " + jndiFileKey + " defined in JNDI; specify only one");
                    }
                    if (filenameValue != null) {
                        File propertyFile = new File(filenameValue);
                        if (!propertyFile.isAbsolute()) {
                            if (this.lookForConfigFile(filenameValue)) {
                                return;
                            }
                            throw new FileNotFoundException(filenameValue);
                        }
                        fileUrl = propertyFile.toURL();
                        keyUsed = jndiFileKey;
                    }
                    if (fileUrl != null) {
                        this.loadFromUrl(fileUrl);
                        this.log.info((Object)("Configuration file loaded from '" + fileUrl.toString() + "' (from JNDI Key=" + keyUsed + ")"));
                        return;
                    }
                }
                catch (MalformedURLException mue) {
                    throw new ConfigException("Configuration file url (" + urlValue + ") given in JNDI (key=" + jndiUrlKey + ") is malformed", mue);
                }
                catch (FileNotFoundException fnfe) {
                    throw new ConfigException("Configuration file (" + filenameValue + ") given in JNDI (key=" + jndiFileKey + ") cannot be found", fnfe);
                }
                catch (NamingException ne) {
                    throw new ConfigException("Using key '" + jndiUrlKey + "' or '" + jndiFileKey + "' in JNDI gave: ", ne);
                }
                catch (IOException ioe) {
                    throw new ConfigException(ioe + " loading property file at '" + fileUrl + "' (returned by JNDI key " + keyUsed + ")", ioe);
                }
            }
            if (filenameValue == null && urlValue == null) {
                String sysEnvKey = propertyUrlKey;
                String sysEnvUrl = System.getProperty(sysEnvKey);
                this.log.debug((Object)("Config: Sys Env key " + sysEnvKey + " => " + sysEnvUrl));
                if (sysEnvUrl != null) {
                    try {
                        fileUrl = new URL(sysEnvUrl);
                        this.loadFromUrl(fileUrl);
                        this.log.debug((Object)("Configuration file loaded from '" + fileUrl.toString() + "' (from SYS ENV=" + sysEnvKey + ")"));
                        return;
                    }
                    catch (MalformedURLException mue) {
                        throw new ConfigException("Configuration file url given in system environment variable '" + sysEnvKey + "' is malformed", mue);
                    }
                    catch (IOException ioe) {
                        throw new ConfigException(ioe + " loading property file at '" + fileUrl + "' (returned by system environment variable '" + sysEnvKey + "')", ioe);
                    }
                }
            }
            this.log.info((Object)("Config: No key to config file found in JNDI/SysEnv, so falling back to " + configFilename));
            try {
                if (this.lookForConfigFile(configFilename)) {
                    return;
                }
            }
            catch (AccessControlException ace) {
                this.log.error((Object)("No Permission to access " + configFilename), (Throwable)ace);
            }
            try {
                if (this.lookForConfigFile(defaultFilename)) {
                    return;
                }
            }
            catch (AccessControlException ace) {
                this.log.error((Object)("No Permission to access " + defaultFilename), (Throwable)ace);
            }
            this.log.warn((Object)("No configuration file found; if you need one, make sure " + configFilename + " or " + defaultFilename + " is in your classpath, " + "or set the JNDI key " + propertyUrlKey + " to its URL, " + "or set the JNDI key " + propertyKey + " to its file location"));
        }
    }

    private boolean lookForConfigFile(String givenFilename) {
        String filename = FailbackConfig.resolveEnvironmentVariables(givenFilename);
        if (!filename.equals(givenFilename)) {
            givenFilename = givenFilename + " => " + filename;
        }
        this.log.debug((Object)("Looking for " + givenFilename));
        File f = new File(filename);
        if (f.isAbsolute()) {
            if (f.exists()) {
                this.loadFromFile(f);
                return true;
            }
            return false;
        }
        this.log.debug((Object)("Looking for " + givenFilename + " on classpath"));
        URL configUrl = this.getClass().getClassLoader().getResource(filename);
        if (configUrl != null) {
            try {
                this.loadFromUrl(configUrl);
                this.log.info((Object)("Configuration file loaded from '" + configUrl + "' (found in classpath)"));
                return true;
            }
            catch (IOException ioe) {
                throw new ConfigException(ioe + " loading property file at '" + configUrl + "' (from classpath)", ioe);
            }
        }
        this.log.debug((Object)("Looking for " + givenFilename + " in working directory"));
        if (f.exists()) {
            this.loadFromFile(f);
            return true;
        }
        return false;
    }

    private void loadFromFile(File f) {
        try {
            this.loadFromUrl(f.toURL());
            this.log.info((Object)("Configuration file loaded from '" + f.getAbsoluteFile() + "'"));
            return;
        }
        catch (IOException ioe) {
            throw new ConfigException(ioe + " loading property file at '" + f.getAbsoluteFile(), ioe);
        }
    }

    public synchronized void loadFromUrl(URL url) throws IOException {
        boolean found;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        Properties localProperties = new Properties();
        localProperties.load(url.openStream());
        this.addLoadedFrom(url.toString());
        String includeFile = localProperties.getProperty("include.config.filename");
        if (includeFile != null && !(found = this.lookForConfigFile(includeFile))) {
            throw new ConfigException("include config file '" + includeFile + "' not found");
        }
        this.properties.putAll((Map<?, ?>)localProperties);
    }

    public static void assertKeyValid(String key) {
        if (!$assertionsDisabled && key.indexOf(":") != -1) {
            throw new AssertionError((Object)("Key '" + key + "' contains an illegal character - a colon"));
        }
        if (!$assertionsDisabled && key.indexOf(" ") != -1) {
            throw new AssertionError((Object)("Key '" + key + "' contains an illegal character - a space"));
        }
        if (!$assertionsDisabled && key.indexOf("=") != -1) {
            throw new AssertionError((Object)("Key '" + key + "' contains an illegal character - an equals sign"));
        }
    }

    public Object getProperty(String key) {
        String value;
        FailbackConfig.assertKeyValid(key);
        String lookedIn = "Cache";
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        try {
            if (!this.jndiInitialised) {
                this.initialiseJndi();
            }
            if (this.jndiContext != null) {
                lookedIn = lookedIn + ", JNDI";
                return this.jndiContext.lookup(jndiPrefix + key);
            }
            lookedIn = lookedIn + ", (No JNDI)";
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new ConfigException(ne + " locating key=" + key + " in JNDI", ne);
        }
        if (!this.fileInitialised) {
            this.initialiseFile();
        }
        if (this.properties == null) {
            lookedIn = lookedIn + ", (no config file)";
        } else {
            value = this.properties.getProperty(key);
            lookedIn = lookedIn + ", config file(s) (" + this.loadedFrom() + ")";
            if (value != null) {
                return value;
            }
        }
        lookedIn = lookedIn + ", sysenv";
        value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        throw new PropertyNotFoundException("Could not find '" + key + "' in: " + lookedIn);
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            if (this.cache.containsKey(key)) {
                this.cache.remove(key);
            }
        } else {
            this.cache.put(key, value);
        }
    }

    public Object[] getProperties(String key) {
        String value;
        FailbackConfig.assertKeyValid(key);
        String lookedIn = "Cache";
        if (this.cache.containsKey(key)) {
            Object o = this.cache.get(key);
            if (o instanceof Object[]) {
                return (Object[])o;
            }
            return new Object[]{o};
        }
        try {
            if (!this.jndiInitialised) {
                this.initialiseJndi();
            }
            if (this.jndiContext != null) {
                lookedIn = lookedIn + ", JNDI";
                Context javacontext = (Context)this.jndiContext.lookup(jndiPrefix);
                NamingEnumeration<NameClassPair> en = this.jndiContext.list(jndiPrefix + key);
                Vector<String> values = new Vector<String>();
                while (en.hasMoreElements()) {
                    NameClassPair pair = en.next();
                    String value2 = null;
                    try {
                        value2 = javacontext.lookup(pair.getName()).toString();
                    }
                    catch (NamingException ne) {
                        value2 = "??Failed lookup: " + ne;
                    }
                    values.add(value2);
                }
                return values.toArray();
            }
            lookedIn = lookedIn + ", (No JNDI)";
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException ne) {
            throw new ConfigException(ne + " locating key=" + key + " in JNDI", ne);
        }
        if (!this.fileInitialised) {
            this.initialiseFile();
        }
        if (this.properties == null) {
            lookedIn = lookedIn + ", (no config file)";
        } else {
            lookedIn = lookedIn + ", config file(s) (" + this.loadedFrom() + ")";
            value = this.properties.getProperty(key);
            String value1 = this.properties.getProperty(key + ".1");
            if (value != null && value1 != null) {
                throw new ConfigException("Both single value and sets of values defined for key " + key + " in property file");
            }
            if (value != null) {
                return new Object[]{value};
            }
            if (value1 != null) {
                Vector<String> values = new Vector<String>();
                int v = 2;
                while (value1 != null) {
                    values.add(value1);
                    value1 = this.properties.getProperty(key + "." + v);
                    ++v;
                }
                return values.toArray();
            }
        }
        lookedIn = lookedIn + ", sysenv";
        value = System.getProperty(key);
        if (value != null) {
            return new Object[]{value};
        }
        throw new PropertyNotFoundException("Could not find '" + key + "' in: " + lookedIn);
    }

    public void setProperties(String key, Object[] values) {
        if (values == null) {
            if (this.cache.containsKey(key)) {
                this.cache.remove(key);
            }
        } else {
            this.cache.put(key, values);
        }
    }

    public Set keySet() {
        if (!this.jndiInitialised) {
            this.initialiseJndi();
        }
        if (!this.fileInitialised) {
            this.initialiseFile();
        }
        HashSet<Object> allKeys = new HashSet<Object>();
        allKeys.addAll(this.cache.keySet());
        if (this.jndiContext != null) {
            try {
                Hashtable<?, ?> jndi = this.jndiContext.getEnvironment();
                allKeys.addAll(jndi.keySet());
            }
            catch (NamingException ne) {
                throw new ConfigException("Getting Environment from " + this.jndiContext, ne);
            }
        }
        if (this.properties != null) {
            allKeys.addAll(this.properties.keySet());
        }
        allKeys.addAll(System.getProperties().keySet());
        return allKeys;
    }

    public void dumpConfig(Writer writer) {
        Object key;
        PrintWriter out = new PrintWriter(writer);
        out.println("Configuration loaded from: " + this.loadedFrom());
        out.println();
        if (this.cache.isEmpty()) {
            out.println("(Cache is empty)");
        } else {
            out.println("Cache:");
            Enumeration c = this.cache.keys();
            while (c.hasMoreElements()) {
                key = c.nextElement();
                out.println(this.formKeyValue(key, this.cache.get(key)));
            }
        }
        out.println();
        if (this.jndiContext != null) {
            out.println("JNDI:");
            try {
                out.println("JNDI Environment:");
                Hashtable<?, ?> env = this.jndiContext.getEnvironment();
                Enumeration<?> j = env.keys();
                while (j.hasMoreElements()) {
                    Object key2 = j.nextElement();
                    out.println(this.formKeyValue(key2, env.get(key2)));
                }
                out.println("JNDI Names:");
                Context javacontext = (Context)this.jndiContext.lookup(jndiPrefix);
                NamingEnumeration<NameClassPair> n = this.jndiContext.list(jndiPrefix);
                while (n.hasMoreElements()) {
                    NameClassPair key3 = n.next();
                    String value = "??Failed lookup";
                    try {
                        value = javacontext.lookup(key3.getName()).toString();
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                    out.println(this.formKeyValue(key3, value));
                }
            }
            catch (NamingException ne) {
                ne.printStackTrace(out);
            }
        } else {
            out.println("(No JNDI)");
        }
        out.println();
        if (this.properties != null) {
            out.println("Properties from file(s):");
            Enumeration<Object> p = this.properties.keys();
            while (p.hasMoreElements()) {
                key = p.nextElement();
                out.println(this.formKeyValue(key, this.properties.getProperty(key.toString())));
            }
        } else {
            out.println("(No Config File)");
        }
        out.println();
        out.println("System Environment Variables:");
        try {
            Enumeration<Object> s = System.getProperties().keys();
            while (s.hasMoreElements()) {
                key = s.nextElement();
                out.println(this.formKeyValue(key, System.getProperty(key.toString())));
            }
        }
        catch (AccessControlException ace) {
            out.println("No blanket access permitted: " + ace);
        }
        out.flush();
    }

    public String formKeyValue(Object key, Object value) {
        if (key.toString().toLowerCase().indexOf("password") > -1) {
            return "  " + key + " = <hidden>";
        }
        return "  " + key + " = " + value;
    }

    public static void main(String[] args) {
        FailbackConfig config = new FailbackConfig(null);
        config.getProperty("Nuffink", null);
        config.dumpConfig(new PrintWriter(System.out));
    }

    static {
        $assertionsDisabled = !FailbackConfig.class.desiredAssertionStatus();
        propertyUrlKey = "org.astrogrid.config.url";
        propertyKey = "org.astrogrid.config.filename";
        jndiPrefix = "java:comp/env/";
        configFilename = "astrogrid.properties";
        defaultFilename = "default.properties";
    }
}

