/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.devtools;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.astrogrid.util.ClassPathUtils;

public class JarFinder {
    public static String findInClasspath(String className) throws IOException {
        String[] paths = ClassPathUtils.getClassPathList();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (!path.endsWith(".jar") || !JarFinder.isClassInJar(className, path)) continue;
            return path;
        }
        return null;
    }

    public static boolean isClassInJar(String className, String jarPath) throws IOException {
        JarFile jarFile = new JarFile(new File(jarPath));
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entryName.indexOf(className) <= -1) continue;
            System.out.println("Found " + entryName + " in " + jarPath);
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        String classname = args[0];
        String jar = JarFinder.findInClasspath(classname);
        System.out.println(jar);
    }
}

