/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.i18n;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.astrogrid.AstroGridException;
import org.astrogrid.Configurator;
import org.astrogrid.log.Log;

public class AstroGridMessage {
    public static final String MESSAGES_CATEGORY = "MESSAGES";
    public static final String MESSAGES_BASENAME = "INSTALLATION.BASENAME";
    public static final String MESSAGES_LANGUAGECODE = "INSTALLATION.LANGUAGECODE";
    public static final String MESSAGES_COUNTRYCODE = "INSTALLATION.COUNTRYCODE";
    public static final String MESSAGES_VARIANTCODE = "INSTALLATION.VARIANT";
    private static final String SUBSYSTEM_KEY = "SUBSYSTEM";
    private static final String ASTROGRIDERROR_MESSAGEKEY_NULL = "AG{0}Z00003:AstroGridMessage: Message key is null";
    private static final String ASTROGRIDERROR_MESSAGE_PATTERN_OR_INSERTS_INVALID = "AG{0}Z00004:AstroGridMessage: Message pattern or its inserts are invalid for message with key [{1}]";
    private static final String ASTROGRIDERROR_MESSAGE_NOT_FOUND_IN_RESOURCEBUNDLE = "AG{0}Z00005:AstroGridMessage: Message with key [{1}] not found in ResourceBundle [{2}]";
    private static final String ASTROGRIDERROR_MESSAGE_RESOURCEBUNDLE_NOTFOUND = "AG{0}Z00006:{1}: Message ResourceBundle [{2}] not found in classpath";
    private static final String Z_MESSAGE_PREFIX_PATTERN = "AG{0}Z";
    private static final int SYSTEMACRONYM_STARTINDEX = 2;
    private static final int SYSTEMACRONYM_ENDINDEX = 5;
    private static Hashtable resourceBundles = new Hashtable();
    private String key;
    private Object[] inserts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessageResource(String subsystemAcronym, ResourceBundle aResourceBundle) {
        Log.trace("setMessageResource(): entry");
        try {
            resourceBundles.put(subsystemAcronym, aResourceBundle);
        }
        finally {
            Log.trace("setMessageResource(): exit");
        }
    }

    public static boolean isMessageResourceLoaded(String subsystemAcronym) {
        boolean bLoaded = false;
        try {
            bLoaded = resourceBundles.containsKey(subsystemAcronym.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bLoaded;
    }

    public static ResourceBundle loadMessages(String subsystemAcronym) throws AstroGridException {
        String language = Configurator.getProperty(subsystemAcronym, MESSAGES_LANGUAGECODE, MESSAGES_CATEGORY);
        String country = Configurator.getProperty(subsystemAcronym, MESSAGES_COUNTRYCODE, MESSAGES_CATEGORY);
        String variant = Configurator.getProperty(subsystemAcronym, MESSAGES_VARIANTCODE, MESSAGES_CATEGORY);
        Locale locale = new Locale(language, country, variant);
        Log.logDebug("language[" + language + "]\t" + "country[" + country + "]\t" + "variant[" + variant + "]\t" + "locale[" + locale.toString() + "]");
        return AstroGridMessage.loadMessages(subsystemAcronym, locale);
    }

    public static synchronized ResourceBundle loadMessages(String subsystemAcronym, Locale locale) throws AstroGridException {
        Log.trace("loadMessages(): entry");
        ResourceBundle resourceBundle = null;
        try {
            ResourceBundleKey key = new ResourceBundleKey(subsystemAcronym, locale);
            resourceBundle = (ResourceBundle)resourceBundles.get(key);
            if (resourceBundle == null) {
                String messageBundleBaseName = Configurator.getProperty(subsystemAcronym, MESSAGES_BASENAME, MESSAGES_CATEGORY);
                resourceBundle = ResourceBundle.getBundle(messageBundleBaseName, locale);
                resourceBundles.put(key, resourceBundle);
            }
        }
        catch (MissingResourceException mrex) {
            AstroGridMessage message = new AstroGridMessage(ASTROGRIDERROR_MESSAGE_RESOURCEBUNDLE_NOTFOUND, subsystemAcronym, Configurator.getClassName(AstroGridMessage.class), locale.toString());
            throw new AstroGridException(message);
        }
        finally {
            Log.trace("loadMessages(): exit");
        }
        return resourceBundle;
    }

    public AstroGridMessage(String key) {
        this.key = key;
        this.inserts = null;
    }

    public AstroGridMessage(String key, Object insert1) {
        this.key = key;
        this.inserts = new Object[]{insert1};
    }

    public AstroGridMessage(String key, Object insert1, Object insert2) {
        this(key, new Object[]{insert1, insert2});
    }

    public AstroGridMessage(String key, Object insert1, Object insert2, Object insert3) {
        this(key, new Object[]{insert1, insert2, insert3});
    }

    public AstroGridMessage(String key, Object insert1, Object insert2, Object insert3, Object insert4) {
        this(key, new Object[]{insert1, insert2, insert3, insert4});
    }

    public AstroGridMessage(String key, Object[] inserts) {
        this.key = key;
        this.inserts = inserts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(ResourceBundle mssgs) {
        Log.trace("toString(ResourceBundle): entry");
        String retValue = null;
        String messageString = null;
        try {
            messageString = this.key + mssgs.getString(this.key);
            retValue = MessageFormat.format(messageString, this.inserts);
        }
        catch (NullPointerException npex) {
            Object[] oa = new Object[]{};
            retValue = this.generateErrantMessage(mssgs, ASTROGRIDERROR_MESSAGEKEY_NULL, oa);
            Log.logDebug(retValue);
        }
        catch (MissingResourceException mrex) {
            Object[] oa = new Object[]{this.key, mssgs.getLocale().toString()};
            retValue = this.generateErrantMessage(mssgs, ASTROGRIDERROR_MESSAGE_NOT_FOUND_IN_RESOURCEBUNDLE, oa);
            Log.logDebug(retValue);
        }
        catch (IllegalArgumentException iaex) {
            Object[] oa = new Object[]{this.key};
            retValue = this.generateErrantMessage(mssgs, ASTROGRIDERROR_MESSAGE_PATTERN_OR_INSERTS_INVALID, oa);
            Log.logDebug(retValue);
        }
        finally {
            Log.trace("toString(ResourceBundle): exit");
        }
        return retValue;
    }

    public String toString(Locale locale) {
        ResourceBundle resourceBundle = null;
        String retValue = null;
        try {
            resourceBundle = AstroGridMessage.loadMessages(this.extractSubsystemAcronym(), locale);
            retValue = this.toString(resourceBundle);
        }
        catch (AstroGridException agex) {
            retValue = agex.getAstroGridMessage().toString();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String retValue;
        block6: {
            Log.trace("toString(): entry");
            retValue = null;
            try {
                if (this.key != null && this.key.startsWith(Z_MESSAGE_PREFIX_PATTERN)) {
                    retValue = MessageFormat.format(this.key, this.inserts);
                    break block6;
                }
                ResourceBundle messages = null;
                try {
                    messages = AstroGridMessage.loadMessages(this.extractSubsystemAcronym());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                retValue = messages != null ? this.toString(messages) : this.concatinateKeyAndInserts();
            }
            finally {
                Log.trace("toString(): exit");
            }
        }
        return retValue;
    }

    private String concatinateKeyAndInserts() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Message[").append(this.key).append("]  ");
        if (this.inserts != null) {
            for (int i = 0; i < this.inserts.length; ++i) {
                buffer.append("Insert").append(i + 1).append("[").append(this.inserts[i].toString()).append("]  ");
            }
        }
        return buffer.toString();
    }

    private String generateErrantMessage(ResourceBundle mssgs, String message, Object[] inserts) {
        String retValue = null;
        Object[] insertsPlus = new Object[inserts.length + 1];
        System.arraycopy(inserts, 0, insertsPlus, 1, inserts.length);
        String subsystemAcronym = mssgs.getString(SUBSYSTEM_KEY);
        if (subsystemAcronym == null || subsystemAcronym.equals("")) {
            subsystemAcronym = "...";
        }
        insertsPlus[0] = subsystemAcronym;
        retValue = MessageFormat.format(message, insertsPlus);
        return retValue;
    }

    private String extractSubsystemAcronym() {
        return this.key.substring(2, 5);
    }

    private static class ResourceBundleKey {
        private String key;

        ResourceBundleKey(String subsystemAcronym) {
            this.key = subsystemAcronym;
        }

        ResourceBundleKey(String subsystemAcronym, Locale locale) {
            this.key = subsystemAcronym + locale.toString();
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

