/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Piper {
    private static final Log logger = LogFactory.getLog((Class)Piper.class);
    private static final int BLOCK_SIZE = 2048;
    private static final int EXCESSIVE_SIZE_WARNING_LEVEL = 0x1E00000;

    private Piper() {
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        byte[] block = new byte[2048];
        int ibytes = 0;
        int imult = 1;
        int read = in.read(block);
        ibytes += read;
        while (read > -1) {
            out.write(block, 0, read);
            read = in.read(block);
            if ((ibytes += read) <= imult * 0x1E00000) continue;
            logger.warn((Object)("pipe has read " + ibytes));
            ++imult;
        }
    }

    public static void bufferedPipe(InputStream in, OutputStream out) throws IOException {
        out = new BufferedOutputStream(out);
        Piper.pipe(new BufferedInputStream(in), out);
        out.flush();
    }

    public static void pipe(Reader in, Writer out) throws IOException {
        char[] block = new char[2048];
        int ichar = 0;
        int imult = 1;
        int read = in.read(block);
        ichar += read;
        while (read > -1) {
            out.write(block, 0, read);
            read = in.read(block);
            if ((ichar += read) <= imult * 0x1E00000) continue;
            logger.warn((Object)("piper has read " + ichar));
            ++imult;
        }
    }

    public static void bufferedPipe(Reader in, Writer out) throws IOException {
        out = new BufferedWriter(out);
        Piper.pipe(new BufferedReader(in), out);
        out.flush();
    }
}

