/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    public String format(LogRecord record) {
        Date d = new Date(record.getMillis());
        SimpleDateFormat format = new SimpleDateFormat("yy-MM-DD HH:mm:ss");
        String msg = format.format(d) + " " + record.getLevel() + " " + record.getMessage();
        if (record.getThrown() != null) {
            if (record.getLevel().intValue() < Level.SEVERE.intValue()) {
                msg = msg + " (" + record.getThrown() + ")\n";
            } else {
                StringWriter writer = new StringWriter();
                record.getThrown().printStackTrace(new PrintWriter(writer));
                msg = msg + "\n\n" + writer.toString();
            }
        } else {
            msg = msg + "\n";
        }
        return msg;
    }
}

