/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.store;

import java.net.URI;
import java.net.URISyntaxException;

public class Ivorn {
    public static final String SCHEME = "ivo";
    private String key = null;
    private String authority = null;
    private String fragment = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Ivorn(String ivorn) throws URISyntaxException {
        if (!$assertionsDisabled && !ivorn.startsWith("ivo:")) {
            throw new AssertionError((Object)"Scheme should be ivo:");
        }
        URI uri = new URI(ivorn);
        this.authority = uri.getAuthority();
        this.key = uri.getPath();
        this.fragment = uri.getFragment();
    }

    public Ivorn(String anAuthority, String aKey, String aFragment) {
        this.key = "/" + aKey;
        this.authority = anAuthority;
        this.fragment = aFragment;
    }

    public Ivorn(String aPath, String aFragment) {
        int slash = aPath.indexOf(47);
        if (slash == -1) {
            throw new IllegalArgumentException("path should consist of <authority>/<key>");
        }
        this.authority = aPath.substring(0, slash);
        this.key = aPath.substring(slash);
        this.fragment = aFragment;
    }

    public String getScheme() {
        return SCHEME;
    }

    public String getPath() {
        if (this.key == null) {
            return this.authority;
        }
        return this.authority + this.key;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        if (this.fragment == null) {
            return "ivo://" + this.getPath();
        }
        return "ivo://" + this.getPath() + "#" + this.fragment;
    }

    public URI toUri() {
        try {
            return new URI(this.toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Application error: " + e + " for IVORN " + this.toString());
        }
    }

    public String toRegistryString() {
        return "ivo://" + this.getPath();
    }

    public static boolean isIvorn(String aString) {
        return aString.toLowerCase().startsWith("ivo://");
    }

    static {
        $assertionsDisabled = !Ivorn.class.desiredAssertionStatus();
    }
}

