/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.io.Piper;
import org.astrogrid.util.DomHelper;
import org.custommonkey.xmlunit.Validator;
import org.custommonkey.xmlunit.XMLAssert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class AstrogridAssert
extends XMLAssert {
    private static final Log logger = LogFactory.getLog((Class)AstrogridAssert.class);
    public static URL VOTABLE_SYSTEM_ID = AstrogridAssert.class.getResource("VOTable.dtd");
    public static final String VOTABLE_DOCTYPE = "VOTABLE";

    private AstrogridAssert() {
    }

    public static void assertVotable(String s) {
        AstrogridAssert.assertDTDValid(s, VOTABLE_DOCTYPE, VOTABLE_SYSTEM_ID);
    }

    public static void assertVotable(InputStream is) {
        AstrogridAssert.assertDTDValid(is, VOTABLE_DOCTYPE, VOTABLE_SYSTEM_ID);
    }

    public static void assertVotable(Document d) {
        AstrogridAssert.assertDTDValid(d, VOTABLE_DOCTYPE, VOTABLE_SYSTEM_ID);
    }

    public static void assertVotable(Element e) {
        AstrogridAssert.assertDTDValid(e, VOTABLE_DOCTYPE, VOTABLE_SYSTEM_ID);
    }

    public static void assertDTDValid(String xml, String doctype, URL dtdResource) {
        try {
            AstrogridAssert.assertXMLValid((String)xml, (String)dtdResource.toString(), (String)doctype);
        }
        catch (SAXException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parse failure " + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parser configuration failure " + e.getMessage()));
        }
    }

    public static void assertDTDValid(Document d, String doctype, URL dtdResource) {
        try {
            AstrogridAssert.assertXMLValid((Validator)new Validator(d, dtdResource.toString(), doctype));
        }
        catch (SAXException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parse failure " + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parser configuration failure " + e.getMessage()));
        }
    }

    public static void assertDTDValid(InputStream xmlStream, String doctype, URL dtdResource) {
        try {
            AstrogridAssert.assertXMLValid((Validator)new Validator(DomHelper.newDocument(xmlStream), dtdResource.toString(), doctype));
        }
        catch (SAXException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parse failure " + e.getMessage()));
        }
        catch (ParserConfigurationException e) {
            AstrogridAssert.fail((String)("assertDTDValid: parser configuration failure " + e.getMessage()));
        }
        catch (IOException e) {
            AstrogridAssert.fail((String)("assertDTDValid: failed to read from stream " + e.getMessage()));
        }
    }

    public static void assertDTDValid(Element e, String doctype, URL dtdResource) {
        try {
            AstrogridAssert.assertXMLValid((String)DomHelper.ElementToString(e), (String)dtdResource.toString(), (String)doctype);
        }
        catch (SAXException e1) {
            AstrogridAssert.fail((String)("assertDTDValid: parse failure " + e1.getMessage()));
        }
        catch (ParserConfigurationException e1) {
            AstrogridAssert.fail((String)("assertDTDValid: parser configuration failure " + e1.getMessage()));
        }
    }

    public static void assertSchemaValid(String xml, String rootElementName, Map schemaLocations) {
        try {
            AstrogridAssert.assertXpathEvaluatesTo((String)rootElementName, (String)"local-name(/*)", (String)xml);
        }
        catch (Exception e) {
            AstrogridAssert.fail((String)("Failed to extract root element name " + e.getMessage()));
        }
        XMLReader parser = AstrogridAssert.createParser(schemaLocations);
        InputSource source = new InputSource(new StringReader(xml));
        try {
            parser.parse(source);
        }
        catch (Exception e) {
            AstrogridAssert.fail((String)("failed to validate against schema: " + e.getMessage()));
        }
    }

    public static void assertSchemaValid(Document d, String rootElementName, Map schemaLocations) {
        AstrogridAssert.assertSchemaValid(DomHelper.DocumentToString(d), rootElementName, schemaLocations);
    }

    public static void assertSchemaValid(InputStream is, String rootElementName, Map schemaLocations) {
        try {
            AstrogridAssert.assertSchemaValid(AstrogridAssert.getStreamContents(is), rootElementName, schemaLocations);
        }
        catch (IOException e) {
            AstrogridAssert.fail((String)("Failed to read from stream " + e.getMessage()));
        }
    }

    public static void assertSchemaValid(Element e, String rootElementName, Map schemaLocations) {
        AstrogridAssert.assertSchemaValid(DomHelper.ElementToString(e), rootElementName, schemaLocations);
    }

    private static XMLReader createParser(Map schemaLocations) {
        String locationString = AstrogridAssert.mkSchemaLocationString(schemaLocations);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", locationString);
            AstrogridAssertDefaultHandler handler = new AstrogridAssertDefaultHandler();
            reader.setErrorHandler(handler);
            reader.setContentHandler(handler);
            return reader;
        }
        catch (SAXNotRecognizedException e) {
            AstrogridAssert.fail((String)("required features not rcognized by this xml parser " + e.getMessage()));
        }
        catch (SAXNotSupportedException e) {
            AstrogridAssert.fail((String)("required features not supported by this xml parser " + e.getMessage()));
        }
        catch (SAXException e) {
            AstrogridAssert.fail((String)("cannot create xml reader " + e.getMessage()));
        }
        throw new IllegalStateException("Cannot be reached");
    }

    private static String mkSchemaLocationString(Map schemaLocations) {
        StringBuffer result = new StringBuffer();
        Iterator i = schemaLocations.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            result.append(e.getKey().toString());
            result.append(' ');
            result.append(e.getValue().toString());
            result.append(' ');
        }
        return result.toString();
    }

    public static void assertWellFormedXML(String xmlDocument) {
        try {
            AstrogridAssert.assertNotNull((String)"null document returned", (Object)DomHelper.newDocument(xmlDocument));
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)("Problem with parser:" + e.getMessage()));
        }
        catch (SAXException e) {
            Assert.fail((String)("xmlDocument is not well formed:" + e.getMessage()));
        }
        catch (IOException e) {
            Assert.fail((String)("Problem reading document:" + e.getMessage()));
        }
    }

    public static void assertWellFormedXML(InputStream xmlStream) {
        try {
            AstrogridAssert.assertNotNull((String)"null document returned", (Object)DomHelper.newDocument(xmlStream));
        }
        catch (ParserConfigurationException e) {
            Assert.fail((String)("Problem with parser:" + e.getMessage()));
        }
        catch (SAXException e) {
            Assert.fail((String)("xmlDocument is not well formed:" + e.getMessage()));
        }
        catch (IOException e) {
            Assert.fail((String)("Problem reading document:" + e.getMessage()));
        }
    }

    public static String getResourceAsString(Class c, String resource) throws IOException {
        InputStream is = c.getResourceAsStream(resource);
        String script = AstrogridAssert.getStreamContents(is);
        AstrogridAssert.assertNotNull((Object)script);
        return script;
    }

    public static String getStreamContents(InputStream is) throws IOException {
        AstrogridAssert.assertNotNull((Object)is);
        StringWriter sw = new StringWriter();
        Piper.bufferedPipe(new InputStreamReader(is), sw);
        return sw.toString();
    }

    static class AstrogridAssertDefaultHandler
    extends DefaultHandler {
        boolean sawError = false;

        AstrogridAssertDefaultHandler() {
        }

        public void endDocument() throws SAXException {
            if (this.sawError) {
                throw new AssertionFailedError("document failed to schema validate");
            }
        }

        public void error(SAXParseException e) throws SAXException {
            this.sawError = true;
            System.err.println("Error:" + e.getMessage());
        }

        public void fatalError(SAXParseException e) throws SAXException {
            this.sawError = true;
            System.err.println("Fatal: " + e.getMessage());
        }

        public void warning(SAXParseException e) throws SAXException {
            System.err.println("Warn: " + e.getMessage());
        }
    }
}

