/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.test;

import java.util.Iterator;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class OptionalTestCase
extends TestCase {
    public static final String DISABLED_BY_DEFAULT = "optional.test.skip.ALL";

    public OptionalTestCase() {
    }

    public OptionalTestCase(String arg0) {
        super(arg0);
    }

    public void run(TestResult tr) {
        if (this.isDisabled()) {
            tr.startTest((Test)this);
            System.out.println("Optional test " + ((Object)((Object)this)).getClass().getName() + "#" + this.getName() + " is disabled - Skipping..");
            tr.endTest((Test)this);
        } else {
            super.run(tr);
        }
    }

    public final boolean isDisabled() {
        String val = System.getProperty(OptionalTestCase.mkKey(((Object)((Object)this)).getClass().getName()));
        if (val == null) {
            return Boolean.getBoolean(DISABLED_BY_DEFAULT);
        }
        return Boolean.valueOf(val);
    }

    public final void setDisabled(boolean isDisabled) {
        OptionalTestCase.setTestDisabled(((Object)((Object)this)).getClass().getName(), isDisabled);
    }

    public static final void setDisabledByDefault(boolean isDisabled) {
        System.setProperty(DISABLED_BY_DEFAULT, Boolean.toString(isDisabled));
    }

    public static final void setTestDisabled(String classname, boolean isDisabled) {
        System.setProperty(OptionalTestCase.mkKey(classname), Boolean.toString(isDisabled));
    }

    private static final String mkKey(String classname) {
        return "optional.test.skip." + classname;
    }

    public static final void reset() {
        Properties sysProps = System.getProperties();
        Iterator<Object> i = sysProps.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!key.startsWith("optional.test.skip")) continue;
            i.remove();
        }
        System.setProperties(sysProps);
    }
}

