/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.util;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;

public class ClassPathUtils {
    public static String[] getInvalidPaths() {
        String[] paths = ClassPathUtils.getClassPathList();
        Vector<String> invalidPaths = new Vector<String>();
        for (int i = 0; i < paths.length; ++i) {
            String error;
            String path = paths[i];
            if (path.toLowerCase().endsWith(".jar")) {
                error = ClassPathUtils.isJarFileValid(path);
                if (error == null) continue;
                invalidPaths.add(path + " (" + error + ")");
                continue;
            }
            error = ClassPathUtils.isDirValid(path);
            if (error == null) continue;
            invalidPaths.add(path + " (" + error + ")");
        }
        if (invalidPaths.size() == 0) {
            return null;
        }
        return invalidPaths.toArray(new String[0]);
    }

    public static String isJarFileValid(String filename) {
        try {
            JarFile jarFile = new JarFile(new File(filename));
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static String isDirValid(String dirname) {
        File file = new File(dirname);
        if (!file.exists()) {
            return "Does not exist";
        }
        if (!file.isDirectory()) {
            return "Not a directory";
        }
        return null;
    }

    public static String[] getClassPathList() {
        String path = ClassPathUtils.getClassPath();
        StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
        Vector<String> list = new Vector<String>();
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[0]);
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static void main(String[] args) {
        String[] invalidPaths = ClassPathUtils.getInvalidPaths();
        if (invalidPaths == null) {
            System.out.println("all paths are valid");
        } else {
            for (int i = 0; i < invalidPaths.length; ++i) {
                System.out.println(invalidPaths[i]);
            }
        }
    }
}

