/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomHelper {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getValue(Element parent, String child) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError((Object)("Attempted to get value of " + child + " of null parent element"));
        }
        NodeList nodes = parent.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return "";
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element) || !nodes.item(i).getLocalName().equals(child)) continue;
            return DomHelper.getValue((Element)nodes.item(i));
        }
        return "";
    }

    public static String getValue(Element element) {
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError((Object)"Attempted to get value of null element");
        }
        if (element.getNodeValue() != null) {
            return element.getNodeValue();
        }
        if (element.hasChildNodes()) {
            return element.getChildNodes().item(0).getNodeValue();
        }
        return "";
    }

    public static Document newDocument(URL documentLocation) throws ParserConfigurationException, SAXException, IOException {
        return DomHelper.newDocument(new BufferedInputStream(documentLocation.openStream()));
    }

    public static Document newDocument(String xmlDocument) throws ParserConfigurationException, SAXException, IOException {
        return DomHelper.newDocument(new BufferedInputStream(new StringBufferInputStream(xmlDocument)));
    }

    public static Document newDocument(File documentFile) throws ParserConfigurationException, SAXException, IOException {
        return DomHelper.newDocument(new BufferedInputStream(new FileInputStream(documentFile)));
    }

    public static Document newDocument(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.parse(in);
    }

    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.newDocument();
    }

    public static void DocumentToStream(Document doc, OutputStream out) {
        XMLUtils.DocumentToStream((Document)doc, (OutputStream)out);
    }

    public static void DocumentToWriter(Document doc, Writer out) {
        XMLUtils.DocumentToWriter((Document)doc, (Writer)out);
    }

    public static String DocumentToString(Document doc) {
        return XMLUtils.DocumentToString((Document)doc);
    }

    public static void ElementToStream(Element body, OutputStream out) {
        XMLUtils.ElementToStream((Element)body, (OutputStream)out);
    }

    public static String ElementToString(Element body) {
        return XMLUtils.ElementToString((Element)body);
    }

    public static void PrettyElementToStream(Element body, OutputStream out) {
        XMLUtils.PrettyElementToStream((Element)body, (OutputStream)out);
    }

    public static void PrettyDocumentToStream(Document body, OutputStream out) {
        XMLUtils.PrettyDocumentToStream((Document)body, (OutputStream)out);
    }

    public static String getNodeAttrValue(Element elem, String tagName) {
        return DomHelper.getNodeAttrValue(elem, tagName, null);
    }

    public static String getNodeAttrValue(Element elem, String tagName, String namespacePrefix) {
        String val = elem.getAttribute(tagName);
        if (val == null || val.trim().length() <= 0) {
            val = elem.getAttribute("xmlns:" + tagName);
        }
        if ((val == null || val.trim().length() <= 0) && namespacePrefix != null) {
            val = elem.getAttributeNS(namespacePrefix, tagName);
        }
        return val;
    }

    public static String getNodeTextValue(Node nd, String tagName) throws IOException {
        NodeList nl = DomHelper.getNodeListTags(nd, tagName);
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            return nl.item(0).getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getNodeTextValue(Node nd, String tagName, String namespacePrefix) throws IOException {
        NodeList nl = DomHelper.getNodeListTags(nd, tagName, namespacePrefix);
        if (nl.getLength() > 0 && nl.item(0).getFirstChild() != null) {
            return nl.item(0).getFirstChild().getNodeValue();
        }
        return null;
    }

    public static NodeList getNodeListTags(Node nd, String tagName) throws IOException {
        return DomHelper.getNodeListTags(nd, tagName, null);
    }

    public static NodeList getNodeListTags(Node nd, String tagName, String namespacePref) throws IOException {
        if (nd instanceof Document) {
            return DomHelper.getNodeListTags((Document)nd, tagName, namespacePref);
        }
        if (nd instanceof Element) {
            return DomHelper.getNodeListTags((Element)nd, tagName, namespacePref);
        }
        throw new IOException("The Node is not an instance of Document or Element");
    }

    private static NodeList getNodeListTags(Document doc, String tagName, String namespacePref) {
        NodeList nl = doc.getElementsByTagName(tagName);
        if (nl.getLength() == 0 && namespacePref != null) {
            nl = doc.getElementsByTagNameNS(namespacePref, tagName);
        }
        if (nl.getLength() == 0 && namespacePref != null) {
            nl = doc.getElementsByTagName(namespacePref + ":" + tagName);
        }
        return nl;
    }

    private static NodeList getNodeListTags(Element elem, String tagName, String namespacePref) {
        NodeList nl = elem.getElementsByTagName(tagName);
        if (nl.getLength() == 0 && namespacePref != null) {
            nl = elem.getElementsByTagNameNS(namespacePref, tagName);
        }
        if (nl.getLength() == 0 && namespacePref != null) {
            nl = elem.getElementsByTagName(namespacePref + ":" + tagName);
        }
        return nl;
    }

    static {
        $assertionsDisabled = !DomHelper.class.desiredAssertionStatus();
    }
}

