/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class TypeSafeEnumerator
implements Serializable {
    protected static Hashtable classLookup = new Hashtable();
    private String text;

    protected TypeSafeEnumerator(String aString) {
        this.text = aString;
        this.addInstance();
    }

    protected void addInstance() {
        Vector<TypeSafeEnumerator> instanceList = (Vector<TypeSafeEnumerator>)classLookup.get(this.getClass().getName());
        if (instanceList == null) {
            instanceList = new Vector<TypeSafeEnumerator>();
            classLookup.put(this.getClass().getName(), instanceList);
        }
        instanceList.add(this);
    }

    public String toString() {
        return this.text;
    }

    private Object readResolve() throws ObjectStreamException {
        return TypeSafeEnumerator.getFor(this.getClass(), this.text);
    }

    public String getText() {
        return this.text;
    }

    public static Iterator getIterator(Class aClass) {
        Vector instanceList = (Vector)classLookup.get(aClass.getName());
        if (instanceList == null) {
            try {
                aClass.newInstance();
                instanceList = (Vector)classLookup.get(aClass.getName());
            }
            catch (Exception e) {
                throw new NullPointerException("Could not create instances of typesafe enumerator " + aClass);
            }
        }
        return instanceList.iterator();
    }

    public static Object[] getAll(Class aClass) {
        return TypeSafeEnumerator.getList(aClass).toArray();
    }

    public static Vector getList(Class aClass) {
        return (Vector)classLookup.get(aClass.getName());
    }

    public static TypeSafeEnumerator getFor(Class aClass, String aString) {
        Iterator iterator = TypeSafeEnumerator.getIterator(aClass);
        while (iterator.hasNext()) {
            TypeSafeEnumerator instance = (TypeSafeEnumerator)iterator.next();
            if (!instance.getText().equalsIgnoreCase(aString)) continue;
            return instance;
        }
        throw new IllegalArgumentException("No enumeration (instance) of " + aClass + " found for '" + aString + "'");
    }
}

