/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.SimpleConfig;

public class Workspace {
    public static final String WORKSPACE_DIRECTORY_KEY = "WorkspaceDirectory";
    public static boolean PERSIST;
    private File workspaceFile = null;
    public static final String DEFAULT_WORKSPACE_DIRECTORY;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Workspace() throws IOException {
        this(null);
    }

    public Workspace(String workspaceId) throws IOException {
        File workRoot = new File(SimpleConfig.getSingleton().getString(WORKSPACE_DIRECTORY_KEY, DEFAULT_WORKSPACE_DIRECTORY));
        if (!workRoot.exists()) {
            workRoot.mkdirs();
        }
        if (!$assertionsDisabled && !workRoot.exists()) {
            throw new AssertionError((Object)("Working root '" + workRoot.getAbsolutePath() + "' given by configuration key '" + WORKSPACE_DIRECTORY_KEY + "' does not exist, and could not be created"));
        }
        if (!$assertionsDisabled && !workRoot.isDirectory()) {
            throw new AssertionError((Object)("Working root '" + workRoot.getAbsolutePath() + "' given by configuration key '" + WORKSPACE_DIRECTORY_KEY + "' is not a directory"));
        }
        if (workspaceId == null) {
            this.workspaceFile = File.createTempFile("Workspace", "", workRoot);
            this.workspaceFile.delete();
        } else {
            this.workspaceFile = new File(workRoot, workspaceId);
        }
        if (this.workspaceFile.exists()) {
            throw new IllegalArgumentException("Workspace '" + workspaceId + "' already in use");
        }
        boolean createdOK = this.workspaceFile.mkdir();
        if (!createdOK) {
            throw new IOException("Directory " + this.workspaceFile + " did not create OK - can't tell why");
        }
        if (!PERSIST) {
            this.workspaceFile.deleteOnExit();
        }
        LogFactory.getLog((Class)Workspace.class).debug((Object)("Workspace created at " + this.workspaceFile));
    }

    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Trying to close a closed workspace");
        }
        if (!PERSIST) {
            this.empty();
        }
        File tempFile = this.workspaceFile;
        this.workspaceFile = null;
        if (!PERSIST) {
            tempFile.delete();
        }
    }

    public boolean isClosed() {
        return this.workspaceFile == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void empty() throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Trying to empty a closed workspace");
        }
        Workspace.emptyDirectory(this.workspaceFile);
    }

    public File makeWorkFile(String filename) throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Trying to create a new file in a closed workspace");
        }
        File file = new File(this.workspaceFile.getAbsolutePath() + File.separator + filename);
        if (!file.createNewFile()) {
            throw new IOException("File '" + filename + "' already exists");
        }
        return file;
    }

    public File makeTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, this.workspaceFile);
    }

    public File makeTempFile(String prefix) throws IOException {
        return File.createTempFile(prefix, "", this.workspaceFile);
    }

    public File makeTempDir(String prefix) throws IOException {
        File newFile = File.createTempFile(prefix, "", this.workspaceFile);
        newFile.delete();
        newFile.mkdir();
        return newFile;
    }

    public static void emptyDirectory(File dir) throws IOException {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError((Object)"Null File given as directory");
        }
        if (!dir.exists()) {
            throw new IOException("'" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new IOException("'" + dir + "' is not a directory");
        }
        File[] contents = dir.listFiles();
        for (int i = 0; i < contents.length; ++i) {
            Workspace.removeFileOrDir(contents[i]);
        }
    }

    protected static void removeFileOrDir(File fod) throws IOException {
        if (fod.isDirectory()) {
            Workspace.emptyDirectory(fod);
        }
        fod.delete();
        if (fod.exists()) {
            throw new IOException("Couldn't delete '" + fod + "' (don't know why)");
        }
    }

    public static void main(String[] args) throws IOException {
        Workspace ws = new Workspace("TestId");
        ws.makeTempDir("wibble");
        ws.close();
    }

    static {
        $assertionsDisabled = !Workspace.class.desiredAssertionStatus();
        PERSIST = false;
        DEFAULT_WORKSPACE_DIRECTORY = System.getProperty("user.dir") + System.getProperty("file.separator") + "workspaces";
    }
}

