/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hdx;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import uk.ac.starlink.hdx.HdxException;

public class HdxProperties {
    private static Properties hdxPropertySet;
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$hdx$HdxProperties;

    private HdxProperties() {
    }

    public static Properties getProperties() {
        if (hdxPropertySet == null) {
            hdxPropertySet = new Properties(System.getProperties());
            String fn = System.getProperty("Hdx.properties", System.getProperty("user.dir") + "/Hdx.properties");
            try {
                FileInputStream propfile = new FileInputStream(fn);
                hdxPropertySet.load(propfile);
            }
            catch (FileNotFoundException e) {
                logger.fine("No file " + fn + " (no problem!)");
            }
            catch (IOException e) {
                logger.warning("IOException reading file " + fn + ": " + e);
            }
            catch (SecurityException e) {
                logger.warning("Security exception opening " + fn + ":" + e);
            }
        }
        if (!$assertionsDisabled && hdxPropertySet == null) {
            throw new AssertionError();
        }
        return hdxPropertySet;
    }

    public static String getProperty(String key) {
        return HdxProperties.getProperties().getProperty(key);
    }

    public static String getProperty(String key, String def) {
        return HdxProperties.getProperties().getProperty(key, def);
    }

    public static String setProperty(String key, String value) throws HdxException {
        try {
            return (String)HdxProperties.getProperties().setProperty(key, value);
        }
        catch (ClassCastException e) {
            throw new HdxException("Previous value of property " + key + " was not a string!");
        }
        catch (Exception e) {
            throw new HdxException("Failed to set Hdx property: " + e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$hdx$HdxProperties == null ? (class$uk$ac$starlink$hdx$HdxProperties = HdxProperties.class$("uk.ac.starlink.hdx.HdxProperties")) : class$uk$ac$starlink$hdx$HdxProperties).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.hdx");
    }
}

