/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pal;

import java.text.NumberFormat;
import java.util.StringTokenizer;

public class Observatory {
    private int NOBS = 83;
    private String Id;
    private String Name;
    private double Longitude;
    private double Latitude;
    private double Height;
    private char EW;
    private char NS;
    private int longdeg;
    private int longmin;
    private int latdeg;
    private int latmin;
    private double longsec;
    private double latsec;
    private static final double DAS2R = 4.84813681109536E-6;
    private static String[][] Obs = new String[][]{{"AAT", "Anglo-Australian 3.9m Telescope", "E 149 3 57.91", "S 31 16 37.34", "1164.0"}, {"LPO4.2", "William Herschel 4.2m Telescope", "W 17 52 53.9", "N 28 45 38.1", "2332.0"}, {"LPO2.5", "Isaac Newton 2.5m Telescope", "W 17 52 39.5", "N 28 45 43.2", "2336.0"}, {"LPO1", "Jacobus Kapteyn 1m Telescope", "W 17 52 41.2", "N 28 45 39.9", "2364.0"}, {"LICK120", "Lick 120 inch", "W 121 38 13.689", "N 37 20 34.931", "1286.0"}, {"MMT", "MMT 6.5m, Mt Hopkins", "W 110 53 4.4", "N 31 41 19.6", "2608.0"}, {"VICBC", "Victoria B.C. 1.85 metre", "W 123 25 1.18", "N 48 31 11.9", "238.0"}, {"DUPONT", "Du Pont 2.5m Telescope, Las Campanas", "W7 0 42 9.0", "S 29 0 11.", "2280.0"}, {"MTHOP1.5", "Mt Hopkins 1.5 metre", "W 110 52 39.00", "N 31 40 51.4", "2344.0"}, {"STROMLO74", "Mount Stromlo 74 inch", "E 149 0 27.59", "S 35 19 14.3", "767.0"}, {"ANU2.3", "Siding Spring 2.3 metre", "E 149 3 40.3", "S 31 16 24.1", "1149.0"}, {"GBVA140", "Greenbank 140 foot", "W 79 50 9.61", "N 38 26 15.4", "881.0"}, {"TOLOLO4M", "Cerro Tololo 4 metre", "W 70 48 53.6", "S 30 9 57.8", "2235.0"}, {"TOLOLO1.5M", "Cerro Tololo 1.5 metre", "W 70 48 54.5", "S 30 9 56.3", "2225.0"}, {"TIDBINBLA", "Tidbinbilla 64 metre", "E 148 58 48.20", "S 35 24 14.3", "670.0"}, {"BLOEMF", "Bloemfontein 1.52 metre", "E 26 24 18.", "S 29 2 18.", "1387.0"}, {"BOSQALEGRE", "Bosque Alegre 1.54 metre", "W 64 32 48.0", "S 31 35 53.0", "1250.0"}, {"FLAGSTF61", "USNO 61 inch astrograph, Flagstaff", "W 111 44 23.6", "N 35 11 2.5", "2316.0"}, {"LOWELL72", "Perkins 72 inch, Lowell", "W 111 32 9.3", "N 35 5 48.6", "2198.0"}, {"HARVARD", "Harvard College Observatory 1.55m", "W 71 33 29.32", "N 42 30 19.0", "185.0"}, {"OKAYAMA", "Okayama 1.88 metre", "E 133 35 47.29", "N 34 34 26.1", "372.0"}, {"KPNO158", "Kitt Peak 158 inch", "W 111 35 57.61", "N 31 57 50.3", "2120.0"}, {"KPNO90", "Kitt Peak 90 inch", "W 111 35 58.24", "N 31 57 46.9", "2071.0"}, {"KPNO84", "Kitt Peak 84 inch", "W 111 35 51.56", "N 31 57 29.2", "2096.0"}, {"KPNO36FT", "Kitt Peak 36 foot", "W 111 36 51.12", "N 31 57 12.1", "1939.0"}, {"KOTTAMIA", "Kottamia 74 inch", "E 31 49 30.", "N 29 55 54.", "476.0"}, {"ESO3.6", "ESO 3.6 metre", "W 70 43 36.", "S 29 15 36.", "2428.0"}, {"MAUNAK88", "Mauna Kea 88 inch", "W 155 28 9.96", "N 19 49 22.77", "4213.6"}, {"UKIRT", "UK Infra Red Telescope", "W 155 28 13.18", "N 19 49 20.75", "4198.5"}, {"QUEBEC1.6", "Quebec 1.6 metre", "W 71 9 9.7", "N 45 27 20.6", "1114.0"}, {"MTEKAR", "Mt Ekar 1.82 metre", "E 11 34 15.", "N 45 50 48.", "1365.0"}, {"MTLEMMON60", "Mt Lemmon 60 inch", "W 110 42 16.9", "N 32 26 33.9", "2790.0"}, {"MCDONLD2.7", "McDonald 2.7 metre", "W 104 1 17.60", "N 30 40 17.7", "2075.0"}, {"MCDONLD2.1", "McDonald 2.1 metre", "W 104 1 20.10", "N 30 40 17.7", "2075.0"}, {"PALOMAR200", "Palomar 200 inch", "W 116 51 50.", "N 33 21 22.", "1706.0"}, {"PALOMAR60", "Palomar 60 inch", "W 116 51 31.", "N 33 20 56.", "1706.0"}, {"DUNLAP74", "David Dunlap 74 inch", "W 79 25 20.", "N 43 51 46.", "244.0"}, {"HPROV1.93", "Haute Provence 1.93 metre", "E 5 42 46.75", "N 43 55 53.3", "665.0"}, {"HPROV1.52", "Haute Provence 1.52 metre", "E 5 42 43.82", "N 43 56 0.2", "667.0"}, {"SANPM83", "San Pedro Martir 83 inch", "W 115 27 47.", "N 31 2 38.", "2830.0"}, {"SAAO74", "Sutherland 74 inch", "E 20 48 44.3", "S 32 22 43.4", "1771.0"}, {"TAUTNBG", "Tautenburg 2 metre", "E 11 42 45.", "N 50 58 51.", "331.0"}, {"CATALINA61", "Catalina 61 inch", "W 110 43 55.1", "N 32 25 0.7", "2510.0"}, {"STEWARD90", "Steward 90 inch", "W 111 35 58.24", "N 31 57 46.9", "2071.0"}, {"USSR6", "USSR 6 metre", "E 41 26 30.0", "N 43 39 12.", "2100.0"}, {"ARECIBO", "Arecibo 1000 foot", "W 66 45 11.1", "N 18 20 36.6", "496.0"}, {"CAMB5KM", "Cambridge 5km", "E 0 2 37.23", "N 52 10 12.2", "17.0"}, {"CAMB1MILE", "Cambridge 1 mile", "E 0 2 21.64", "N 52 9 47.3", "17.0"}, {"EFFELSBERG", "Effelsberg 100 metre", "E 6 53 1.5", "N 50 31 28.6", "366.0"}, {"GBVA300", "Greenbank 300 foot", "W 79 50 56.36", "N 38 25 46.3", "894.0"}, {"JODRELL1", "Jodrell Bank 250 foot", "W 2 18 25.", "N 53 14 10.5", "78.0"}, {"PARKES", "Parkes 64 metre", "E 148 15 44.3591", "S 32 59 59.8657", "391.79"}, {"VLA", "Very Large Array", "W 107 37 3.82", "N 34 4 43.5", "2124.0"}, {"SUGARGROVE", "Sugar Grove 150 foot", "W 79 16 23.", "N 38 31 14.", "705.0"}, {"USSR600", "USSR 600 foot", "E 41 35 25.5", "N 43 49 32.", "973.0"}, {"NOBEYAMA", "Nobeyama 45 metre", "E 138 29 12.", "N 35 56 19.", "1350.0"}, {"JCMT", "JCMT 15 metre", "W 155 28 37.20", "N 19 49 22.11", "4111.0"}, {"ESONTT", "ESO 3.5 metre NTT", "W 70 43 7.", "S 29 15 30.", "2377.0"}, {"ST.ANDREWS", "St Andrews", "W 2 48 52.5", "N 56 20 12.", "30.0"}, {"APO3.5", "Apache Point 3.5m", "W 105 49 11.56", "N 32 46 48.96", "2809.0"}, {"KECK1", "Keck 10m Telescope #1", "W 155 28 28.99", "N 19 49 33.41", "4160.0"}, {"TAUTSCHM", "Tautenberg 1.34 metre Schmidt", "E 11 42 45.0", "N 50 58 51.0", "331.0"}, {"PALOMAR48", "Palomar 48-inch Schmidt", "W 116 51 32.0", "N 33 21 26.0", "1706.0"}, {"UKST", "UK 1.2 metre Schmidt, Siding Spring", "E 149 4 12.8", "S 31 16 27.8", "1145.0"}, {"KISO", "Kiso 1.05 metre Schmidt, Japan", "E 137 37 42.2", "N 35 47 38.7", "1130.0"}, {"ESOSCHM", "ESO 1 metre Schmidt, La Silla", "W 70 43 46.5", "S 29 15 25.8", "2347.0"}, {"ATCA", "Australia Telescope Compact Array", "E 149 33 0.500", "S 30 18 46.385", "236.9"}, {"MOPRA", "ATNF Mopra Observatory", "E 149 5 58.732", "S 31 16 4.451", "850.0"}, {"SUBARU", "Subaru 8m telescope", "W 155 28 33.67", "N 19 49 31.81", "4163.0"}, {"CFHT", "Canada-France-Hawaii 3.6m Telescope", "W 155 28 7.95", "N 19 49 30.91", "4204.1"}, {"KECK2", "Keck 10m Telescope #2", "W 155 28 27.24", "N 19 49 35.62", "4159.6"}, {"GEMININ", "Gemini North 8-m telescope", "W 155 28 8.57", "N 19 49 25.69", "4213.4"}, {"FCRAO", "Five College Radio Astronomy Obs", "W 72 20 42.0", "N 42 23 30.0", "314.0"}, {"IRTF", "NASA IR Telescope Facility, Mauna Kea", "W 155 28 19.20", "N 19 49 34.39", "4168.1"}, {"CSO", "Caltech Sub-mm Observatory, Mauna Kea", "W 155 28 31.79", "N 19 49 20.78", "4080.0"}, {"VLT1", "ESO VLT, Paranal, Chile: UT1", "W 70 24 11.642", "S 24 37 33.117", "2635.43"}, {"VLT2", "ESO VLT, Paranal, Chile: UT2", "W 70 24 10.855", "S 24 37 31.465", "2635.43"}, {"VLT3", "ESO VLT, Paranal, Chile: UT3", "W 70 24 9.896", "S 24 37 30.300", "2635.43"}, {"VLT4", "ESO VLT Paranal, Chile: UT4", "W 70 24 8.000", "S 24 37 31.000", "2635.43"}, {"GEMINIS", "Gemini South 8-m telescope", "W 70 44 11.5", "S 30 14 26.7", "2738.0"}, {"KOSMA3M", "KOSMA 3m telescope, Gornergrat", "E 7 47 3.48", "N 45 58 59.772", "3141.0"}, {"MAGELLAN1", "Magellan 1, 6.5m, Las Campanas", "W 70 41 31.9", "S 29 0 51.7", "2408.0"}, {"MAGELLAN2", "Magellan 2, 6.5m, Las Campanas", "W 70 41 33.5", "S 29 0 50.3", "2408.0"}, {null, null, null, null, null}};

    Observatory(String id, String name, char ew, double lo, char ns, double lat, double ht) {
        this.Id = id;
        this.Name = name;
        this.EW = ew;
        this.Longitude = lo;
        this.NS = ns;
        this.Latitude = lat;
        this.Height = ht;
    }

    Observatory(int i) {
        if (i > this.NOBS) {
            i = this.NOBS + 1;
        }
        this.Id = Obs[--i][0];
        this.Name = Obs[i][1];
        if (this.Name == null) {
            return;
        }
        this.setLong(Obs[i][2]);
        this.setLat(Obs[i][3]);
        this.Height = new Double(Obs[i][4]);
    }

    Observatory(String id) {
        int i = 0;
        while (!Obs[i][0].equals(null)) {
            if (id.equals(Obs[i][0])) break;
            ++i;
        }
        this.Id = Obs[i][0];
        this.Name = Obs[i][1];
        if (this.Name == null) {
            return;
        }
        this.setLong(Obs[i][2]);
        this.setLat(Obs[i][3]);
        this.Height = new Double(Obs[i][4]);
    }

    private void setLong(String lon) {
        StringTokenizer st = new StringTokenizer(lon);
        String s = st.nextToken();
        this.EW = s.charAt(0);
        this.longdeg = new Integer(st.nextToken());
        this.longmin = new Integer(st.nextToken());
        this.longsec = new Double(st.nextToken());
        this.Longitude = this.EW == 'W' ? 4.84813681109536E-6 * (60.0 * (60.0 * (double)this.longdeg + (double)this.longmin) + this.longsec) : -4.84813681109536E-6 * (60.0 * (60.0 * (double)this.longdeg + (double)this.longmin) + this.longsec);
    }

    private void setLat(String lat) {
        StringTokenizer st = new StringTokenizer(lat);
        String s = st.nextToken();
        this.NS = s.charAt(0);
        this.latdeg = new Integer(st.nextToken());
        this.latmin = new Integer(st.nextToken());
        this.latsec = new Double(st.nextToken());
        this.Latitude = this.NS == 'N' ? 4.84813681109536E-6 * (60.0 * (60.0 * (double)this.latdeg + (double)this.latmin) + this.latsec) : -4.84813681109536E-6 * (60.0 * (60.0 * (double)this.latdeg + (double)this.latmin) + this.latsec);
    }

    public String getId() {
        return this.Id;
    }

    public String getName() {
        return this.Name;
    }

    public double getLong() {
        return this.Longitude;
    }

    public double getLat() {
        return this.Latitude;
    }

    public double getHeight() {
        return this.Height;
    }

    public String printPosition() {
        return this.printPosition(2);
    }

    public String printPosition(int ndp) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(ndp);
        nf.setMinimumFractionDigits(ndp);
        NumberFormat nfi = NumberFormat.getNumberInstance();
        nfi.setMinimumIntegerDigits(2);
        return this.EW + " " + this.longdeg + " " + nfi.format(this.longmin) + " " + nf.format(this.longsec) + "   " + this.NS + " " + this.latdeg + " " + nfi.format(this.latmin) + " " + nf.format(this.latsec) + " (Height: " + nf.format(this.Height) + "m)";
    }

    public String toString() {
        return this.Name + " [" + this.Id + "]";
    }

    public static int getObservatoryCount() {
        return Obs.length - 1;
    }

    public static String getObservatoryName(int i) {
        if (i < Obs.length) {
            return Obs[i][1];
        }
        return null;
    }

    public static String getObservatoryID(int i) {
        if (i < Obs.length) {
            return Obs[i][0];
        }
        return null;
    }
}

