/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits;

import edu.jhu.pha.sdss.fits.FITSImage;
import edu.jhu.pha.sdss.fits.imageio.FITSReaderSpi;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.imageio.spi.IIORegistry;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FITSTest {
    public static void main(String[] args) throws Exception {
        IIORegistry.getDefaultInstance().registerServiceProvider(new FITSReaderSpi());
        BufferedImage image = ImageIO.read(new FileInputStream(args[0]));
        JFrame frame = new JFrame("FITS Test");
        frame.getContentPane().add(FITSTest.createImagePanel(image));
        frame.setSize(300, 300);
        frame.show();
        if (image instanceof FITSImage) {
            FITSImage fimage = (FITSImage)image;
            try {
                Thread.sleep(1000L);
                fimage.setScaleMethod(1);
                frame.repaint();
                Thread.sleep(1000L);
                fimage.setScaleMethod(2);
                frame.repaint();
                Thread.sleep(1000L);
                fimage.setScaleMethod(3);
                frame.repaint();
                Thread.sleep(1000L);
                fimage.setScaleMethod(5);
                frame.repaint();
            }
            catch (RuntimeException e) {
                e.getCause().printStackTrace();
            }
            System.out.println("Finding max value");
            System.out.println("The easy way... max = " + fimage.getHistogram().getMax());
            System.out.println("The unreliable way... max = " + fimage.getImageHDU().getMaximumValue());
            double bScale = fimage.getImageHDU().getBScale();
            double bZero = fimage.getImageHDU().getBZero();
            double max = Double.MIN_VALUE;
            double val = Double.NaN;
            Object data = fimage.getImageHDU().getData().getData();
            int[] axes = fimage.getImageHDU().getAxes();
            switch (fimage.getImageHDU().getBitPix()) {
                case 8: {
                    int shifted = 0;
                    for (int x = 0; x < axes[1]; ++x) {
                        for (int y = 0; y < axes[0]; ++y) {
                            shifted = ((byte[][])data)[y][x];
                            shifted = shifted < 0 ? shifted + 256 : shifted;
                            val = bScale * (double)shifted + bZero;
                            max = val > max ? val : max;
                        }
                    }
                    break;
                }
                case 16: {
                    for (int x = 0; x < axes[1]; ++x) {
                        for (int y = 0; y < axes[0]; ++y) {
                            val = bScale * (double)((short[][])data)[y][x] + bZero;
                            max = val > max ? val : max;
                        }
                    }
                    break;
                }
                case 32: {
                    for (int x = 0; x < axes[1]; ++x) {
                        for (int y = 0; y < axes[0]; ++y) {
                            val = bScale * (double)((int[][])data)[y][x] + bZero;
                            max = val > max ? val : max;
                        }
                    }
                    break;
                }
                case -32: {
                    for (int x = 0; x < axes[1]; ++x) {
                        for (int y = 0; y < axes[0]; ++y) {
                            val = bScale * (double)((float[][])data)[y][x] + bZero;
                            max = val > max ? val : max;
                        }
                    }
                    break;
                }
                case -64: {
                    for (int x = 0; x < axes[1]; ++x) {
                        for (int y = 0; y < axes[0]; ++y) {
                            val = bScale * ((double[][])data)[y][x] + bZero;
                            max = val > max ? val : max;
                        }
                    }
                    break;
                }
            }
            System.out.println("The hard way... max = " + max);
        }
    }

    protected static JComponent createImagePanel(final RenderedImage image) {
        JComponent panel = new JComponent(){

            public void paint(Graphics g) {
                this.revalidate();
                if (image != null) {
                    ((Graphics2D)g).drawRenderedImage(image, new AffineTransform());
                }
            }
        };
        return panel;
    }
}

