/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits;

public class Histogram {
    protected double _min;
    protected double _max;
    protected double _range;
    protected int[] _counts;
    protected double[] _cdf;
    protected int _totalCount;

    public Histogram(double min, double max, int totalCount, int[] counts) {
        if (max < min) {
            throw new IllegalArgumentException("max is less than min: max = " + max + " min = " + min);
        }
        this.setMin(min);
        this.setMax(max);
        this.setRange(max - min);
        this.setTotalCount(totalCount);
        this.setCounts(counts);
        this._cdf = Histogram.calculateCdf(counts, totalCount);
    }

    public double getMin() {
        return this._min;
    }

    public double getMax() {
        return this._max;
    }

    public double getRange() {
        return this._range;
    }

    public int getTotalCount() {
        return this._totalCount;
    }

    public int[] getCounts() {
        return this._counts;
    }

    public int getEqualizedValue(int val) {
        double v = this._cdf[val];
        double vMin = this._cdf[0];
        return (int)((v - vMin) / (1.0 - vMin) * (double)(this._counts.length - 1) + 0.5);
    }

    public double estimateSigma() {
        double modeIndex = Histogram.findModeIndex(this._counts);
        double linearScaleFactor = (Math.pow(2.0, 16.0) - 1.0) / (this._max - this._min);
        return (modeIndex + 1.0) / linearScaleFactor;
    }

    protected static int findModeIndex(int[] counts) {
        int index = 0;
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] <= counts[index]) continue;
            index = i;
        }
        return index;
    }

    public Bounds calculateBounds(double percentKept) throws IllegalArgumentException {
        if (percentKept < 0.0 || percentKept > 1.0) {
            throw new IllegalArgumentException("percentKept must be in [0 ... 1]");
        }
        double halfPercentDiscarded = (1.0 - percentKept) / 2.0;
        int lowIndex = 0;
        double lowCount = 0.0;
        double totalCount = this.getTotalCount();
        boolean done = false;
        while (!done && lowIndex < this._counts.length && lowCount / totalCount < halfPercentDiscarded) {
            if ((lowCount += (double)this._counts[lowIndex]) / totalCount < halfPercentDiscarded) {
                ++lowIndex;
                continue;
            }
            done = true;
        }
        int highIndex = this.getCounts().length - 1;
        double highCount = 0.0;
        done = false;
        while (!done && highIndex >= 0 && highCount / totalCount < halfPercentDiscarded) {
            if ((highCount += (double)this._counts[highIndex]) / totalCount < halfPercentDiscarded) {
                --highIndex;
                continue;
            }
            done = true;
        }
        return new Bounds(lowIndex, highIndex);
    }

    public static String revision() {
        return "$Revision: 1.12 $";
    }

    protected static double[] calculateCdf(int[] counts, int totalCount) {
        double[] result = new double[counts.length];
        int cumulativeCount = 0;
        for (int i = 0; i < result.length; ++i) {
            result[i] = (double)(cumulativeCount += counts[i]) / (double)totalCount;
        }
        return result;
    }

    protected void setMin(double min) {
        this._min = min;
    }

    protected void setMax(double max) {
        this._max = max;
    }

    protected void setRange(double range) {
        this._range = range;
    }

    protected void setTotalCount(int totalCount) {
        this._totalCount = totalCount;
    }

    protected void setCounts(int[] counts) {
        this._counts = counts;
    }

    public static class Bounds {
        public double low;
        public double high;

        public Bounds(double low, double high) {
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return this.getClass().getName() + " low = " + this.low + " high = " + this.high;
        }
    }
}

