/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.pha.sdss.fits;

import edu.jhu.pha.sdss.fits.Histogram;
import java.util.Arrays;

public class ScaleUtils {
    public static final String[] SCALE_NAMES = new String[]{"Linear", "Log", "Square Root", "Square", "Hist EQ", "Arcsinh"};
    public static final int LINEAR = 0;
    public static final int LOG = 1;
    public static final int SQUARE_ROOT = 2;
    public static final int SQUARE = 3;
    public static final int HIST_EQ = 4;
    public static final int ASINH = 5;
    protected static final double[] BYTE_SQRT_MAP = ScaleUtils.createSqrtMap((int)Math.pow(2.0, 8.0));
    protected static final double[] BYTE_LOG_MAP = ScaleUtils.createLogMap((int)Math.pow(2.0, 8.0));
    protected static final double[] SHORT_SQRT_MAP = ScaleUtils.createSqrtMap((int)Math.pow(2.0, 16.0));
    protected static final double[] SHORT_LOG_MAP = ScaleUtils.createLogMap((int)Math.pow(2.0, 16.0));

    public static String[] getScaleNames() {
        return SCALE_NAMES;
    }

    public static double arcsinh(double val) {
        return Math.log(val + Math.sqrt(1.0 + val * val));
    }

    public static short[][] scaleToUShort(byte[][] data, Histogram hist, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
        int arraySize = width * height * 3;
        short[] linearResult = new short[arraySize];
        short[] logResult = new short[arraySize];
        short[] sqrtResult = new short[arraySize];
        short[] squareResult = new short[arraySize];
        short[] histEqResult = new short[arraySize];
        short[] asinhResult = new short[arraySize];
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        double offset = bZero - min;
        double log10 = Math.log(10.0);
        double linearScaleFactor = nBins / (max - min);
        double sqrtScaleFactor = nBins / Math.sqrt(max - min);
        double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
        double logScaleFactor = nBins / (Math.log(nBins) / log10);
        double logLinearScaleFactor = Math.log(linearScaleFactor);
        double asinhScaleFactor = nBins / ScaleUtils.arcsinh((max - min) / sigma);
        int minIndex = (int)Math.rint((min - bZero) / bScale);
        int maxIndex = (int)Math.rint((max - bZero) / bScale);
        double rootBscale = Math.sqrt(bScale);
        double logBscale = Math.log(bScale);
        double rootMax = Math.sqrt(max - min);
        double logMax = Math.log(max - min);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bandedIndex = (y * width + x) * 3;
                int shifted = data[y][x];
                if (shifted < 0) {
                    shifted += 256;
                }
                double val = Math.max(0.0, Math.min(offset + bScale * (double)shifted, max - min));
                int mapIndex = Math.max(minIndex, Math.min(maxIndex, shifted)) - minIndex;
                double sqrtVal = Math.max(0.0, Math.min(rootMax, rootBscale * BYTE_SQRT_MAP[mapIndex]));
                double logVal = Math.max(0.0, Math.min(logMax, logBscale + BYTE_LOG_MAP[mapIndex]));
                short s = (short)(val * linearScaleFactor);
                linearResult[bandedIndex + 2] = s;
                linearResult[bandedIndex + 1] = s;
                linearResult[bandedIndex] = s;
                short s2 = (short)(val * val * squareScaleFactor);
                squareResult[bandedIndex + 2] = s2;
                squareResult[bandedIndex + 1] = s2;
                squareResult[bandedIndex] = s2;
                short s3 = (short)(sqrtVal * sqrtScaleFactor);
                sqrtResult[bandedIndex + 2] = s3;
                sqrtResult[bandedIndex + 1] = s3;
                sqrtResult[bandedIndex] = s3;
                short s4 = val <= 0.0 ? (short)0 : (short)((logVal + logLinearScaleFactor) / log10 * logScaleFactor);
                logResult[bandedIndex + 2] = s4;
                logResult[bandedIndex + 1] = s4;
                logResult[bandedIndex] = s4;
                short s5 = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                histEqResult[bandedIndex + 2] = s5;
                histEqResult[bandedIndex + 1] = s5;
                histEqResult[bandedIndex] = s5;
                short s6 = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                asinhResult[bandedIndex + 2] = s6;
                asinhResult[bandedIndex + 1] = s6;
                asinhResult[bandedIndex] = s6;
            }
        }
        return new short[][]{linearResult, logResult, sqrtResult, squareResult, histEqResult, asinhResult};
    }

    public static short[][] scaleToUShort(short[][] data, Histogram hist, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
        int arraySize = width * height * 3;
        short[] linearResult = new short[arraySize];
        short[] logResult = new short[arraySize];
        short[] sqrtResult = new short[arraySize];
        short[] squareResult = new short[arraySize];
        short[] histEqResult = new short[arraySize];
        short[] asinhResult = new short[arraySize];
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        double offset = bZero - min;
        double log10 = Math.log(10.0);
        double linearScaleFactor = nBins / (max - min);
        double sqrtScaleFactor = nBins / Math.sqrt(max - min);
        double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
        double logScaleFactor = nBins / (Math.log(nBins) / log10);
        double logLinearScaleFactor = Math.log(linearScaleFactor);
        double asinhScaleFactor = nBins / ScaleUtils.arcsinh((max - min) / sigma);
        int minIndex = (int)Math.rint((min - bZero) / bScale);
        int maxIndex = (int)Math.rint((max - bZero) / bScale);
        double rootBscale = Math.sqrt(bScale);
        double logBscale = Math.log(bScale);
        double rootMax = Math.sqrt(max - min);
        double logMax = Math.log(max - min);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bandedIndex = (y * width + x) * 3;
                double val = Math.max(0.0, Math.min(offset + bScale * (double)data[y][x], max - min));
                int mapIndex = Math.max(minIndex, Math.min(maxIndex, data[y][x])) - minIndex;
                double sqrtVal = Math.max(0.0, Math.min(rootMax, rootBscale * SHORT_SQRT_MAP[mapIndex]));
                double logVal = Math.max(0.0, Math.min(logMax, logBscale + SHORT_LOG_MAP[mapIndex]));
                short s = (short)(val * linearScaleFactor);
                linearResult[bandedIndex + 2] = s;
                linearResult[bandedIndex + 1] = s;
                linearResult[bandedIndex] = s;
                short s2 = (short)(val * val * squareScaleFactor);
                squareResult[bandedIndex + 2] = s2;
                squareResult[bandedIndex + 1] = s2;
                squareResult[bandedIndex] = s2;
                short s3 = (short)(sqrtVal * sqrtScaleFactor);
                sqrtResult[bandedIndex + 2] = s3;
                sqrtResult[bandedIndex + 1] = s3;
                sqrtResult[bandedIndex] = s3;
                short s4 = val <= 0.0 ? (short)0 : (short)((logVal + logLinearScaleFactor) / log10 * logScaleFactor);
                logResult[bandedIndex + 2] = s4;
                logResult[bandedIndex + 1] = s4;
                logResult[bandedIndex] = s4;
                short s5 = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                histEqResult[bandedIndex + 2] = s5;
                histEqResult[bandedIndex + 1] = s5;
                histEqResult[bandedIndex] = s5;
                short s6 = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                asinhResult[bandedIndex + 2] = s6;
                asinhResult[bandedIndex + 1] = s6;
                asinhResult[bandedIndex] = s6;
            }
        }
        return new short[][]{linearResult, logResult, sqrtResult, squareResult, histEqResult, asinhResult};
    }

    public static short[][] scaleToUShort(int[][] data, Histogram hist, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
        int arraySize = width * height * 3;
        short[] linearResult = new short[arraySize];
        short[] logResult = new short[arraySize];
        short[] sqrtResult = new short[arraySize];
        short[] squareResult = new short[arraySize];
        short[] histEqResult = new short[arraySize];
        short[] asinhResult = new short[arraySize];
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        double offset = bZero - min;
        double log10 = Math.log(10.0);
        double linearScaleFactor = nBins / (max - min);
        double sqrtScaleFactor = nBins / Math.sqrt(max - min);
        double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
        double logScaleFactor = nBins / (Math.log(nBins) / log10);
        double asinhScaleFactor = nBins / ScaleUtils.arcsinh((max - min) / sigma);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bandedIndex = (y * width + x) * 3;
                double val = offset + bScale * (double)data[y][x];
                val = Math.max(0.0, Math.min(val, max - min));
                short s = (short)(val * linearScaleFactor);
                linearResult[bandedIndex + 2] = s;
                linearResult[bandedIndex + 1] = s;
                linearResult[bandedIndex] = s;
                short s2 = (short)(val * val * squareScaleFactor);
                squareResult[bandedIndex + 2] = s2;
                squareResult[bandedIndex + 1] = s2;
                squareResult[bandedIndex] = s2;
                short s3 = (short)(Math.sqrt(val) * sqrtScaleFactor);
                sqrtResult[bandedIndex + 2] = s3;
                sqrtResult[bandedIndex + 1] = s3;
                sqrtResult[bandedIndex] = s3;
                short s4 = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                logResult[bandedIndex + 2] = s4;
                logResult[bandedIndex + 1] = s4;
                logResult[bandedIndex] = s4;
                short s5 = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                histEqResult[bandedIndex + 2] = s5;
                histEqResult[bandedIndex + 1] = s5;
                histEqResult[bandedIndex] = s5;
                short s6 = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                asinhResult[bandedIndex + 2] = s6;
                asinhResult[bandedIndex + 1] = s6;
                asinhResult[bandedIndex] = s6;
            }
        }
        return new short[][]{linearResult, logResult, sqrtResult, squareResult, histEqResult, asinhResult};
    }

    public static short[][] scaleToUShort(float[][] data, Histogram hist, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
        int arraySize = width * height * 3;
        short[] linearResult = new short[arraySize];
        short[] logResult = new short[arraySize];
        short[] sqrtResult = new short[arraySize];
        short[] squareResult = new short[arraySize];
        short[] histEqResult = new short[arraySize];
        short[] asinhResult = new short[arraySize];
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        double offset = bZero - min;
        double log10 = Math.log(10.0);
        double linearScaleFactor = nBins / (max - min);
        double sqrtScaleFactor = nBins / Math.sqrt(max - min);
        double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
        double logScaleFactor = nBins / (Math.log(nBins) / log10);
        double asinhScaleFactor = nBins / ScaleUtils.arcsinh((max - min) / sigma);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bandedIndex = (y * width + x) * 3;
                double val = offset + bScale * (double)data[y][x];
                val = Math.max(0.0, Math.min(val, max - min));
                short s = (short)(val * linearScaleFactor);
                linearResult[bandedIndex + 2] = s;
                linearResult[bandedIndex + 1] = s;
                linearResult[bandedIndex] = s;
                short s2 = (short)(val * val * squareScaleFactor);
                squareResult[bandedIndex + 2] = s2;
                squareResult[bandedIndex + 1] = s2;
                squareResult[bandedIndex] = s2;
                short s3 = (short)(Math.sqrt(val) * sqrtScaleFactor);
                sqrtResult[bandedIndex + 2] = s3;
                sqrtResult[bandedIndex + 1] = s3;
                sqrtResult[bandedIndex] = s3;
                short s4 = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                logResult[bandedIndex + 2] = s4;
                logResult[bandedIndex + 1] = s4;
                logResult[bandedIndex] = s4;
                short s5 = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                histEqResult[bandedIndex + 2] = s5;
                histEqResult[bandedIndex + 1] = s5;
                histEqResult[bandedIndex] = s5;
                short s6 = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                asinhResult[bandedIndex + 2] = s6;
                asinhResult[bandedIndex + 1] = s6;
                asinhResult[bandedIndex] = s6;
            }
        }
        return new short[][]{linearResult, logResult, sqrtResult, squareResult, histEqResult, asinhResult};
    }

    public static short[][] scaleToUShort(double[][] data, Histogram hist, int width, int height, double bZero, double bScale, double min, double max, double sigma) {
        int arraySize = width * height * 3;
        short[] linearResult = new short[arraySize];
        short[] logResult = new short[arraySize];
        short[] sqrtResult = new short[arraySize];
        short[] squareResult = new short[arraySize];
        short[] histEqResult = new short[arraySize];
        short[] asinhResult = new short[arraySize];
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        double offset = bZero - min;
        double log10 = Math.log(10.0);
        double linearScaleFactor = nBins / (max - min);
        double sqrtScaleFactor = nBins / Math.sqrt(max - min);
        double squareScaleFactor = nBins / Math.pow(max - min, 2.0);
        double logScaleFactor = nBins / (Math.log(nBins) / log10);
        double asinhScaleFactor = nBins / ScaleUtils.arcsinh((max - min) / sigma);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int bandedIndex = (y * width + x) * 3;
                double val = offset + bScale * data[y][x];
                val = Math.max(0.0, Math.min(val, max - min));
                short s = (short)(val * linearScaleFactor);
                linearResult[bandedIndex + 2] = s;
                linearResult[bandedIndex + 1] = s;
                linearResult[bandedIndex] = s;
                short s2 = (short)(val * val * squareScaleFactor);
                squareResult[bandedIndex + 2] = s2;
                squareResult[bandedIndex + 1] = s2;
                squareResult[bandedIndex] = s2;
                short s3 = (short)(Math.sqrt(val) * sqrtScaleFactor);
                sqrtResult[bandedIndex + 2] = s3;
                sqrtResult[bandedIndex + 1] = s3;
                sqrtResult[bandedIndex] = s3;
                short s4 = val <= 0.0 ? (short)0 : (short)(Math.log(val * linearScaleFactor) / log10 * logScaleFactor);
                logResult[bandedIndex + 2] = s4;
                logResult[bandedIndex + 1] = s4;
                logResult[bandedIndex] = s4;
                short s5 = (short)hist.getEqualizedValue((int)(val * linearScaleFactor));
                histEqResult[bandedIndex + 2] = s5;
                histEqResult[bandedIndex + 1] = s5;
                histEqResult[bandedIndex] = s5;
                short s6 = (short)(ScaleUtils.arcsinh(val / sigma) * asinhScaleFactor);
                asinhResult[bandedIndex + 2] = s6;
                asinhResult[bandedIndex + 1] = s6;
                asinhResult[bandedIndex] = s6;
            }
        }
        return new short[][]{linearResult, logResult, sqrtResult, squareResult, histEqResult, asinhResult};
    }

    public static Histogram computeHistogram(byte[][] data, double bZero, double bScale) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        int totalCount = 0;
        int[] counts = new int[(int)(nBins + 1.0)];
        Arrays.fill(counts, 0);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val;
                int dataVal = data[i][j];
                if (dataVal < 0) {
                    dataVal += 256;
                }
                if ((val = bZero + bScale * (double)dataVal) > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double offset = bZero - min;
        double linearScaleFactor = nBins / (max - min);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                int dataVal = data[i][j];
                if (dataVal < 0) {
                    dataVal += 256;
                }
                ++totalCount;
                int n = (int)((offset + bScale * (double)dataVal) * linearScaleFactor);
                counts[n] = counts[n] + 1;
            }
        }
        return new Histogram(min, max, totalCount, counts);
    }

    public static Histogram computeHistogram(short[][] data, double bZero, double bScale) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        int totalCount = 0;
        int[] counts = new int[(int)(nBins + 1.0)];
        Arrays.fill(counts, 0);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = bZero + bScale * (double)data[i][j];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double offset = bZero - min;
        double linearScaleFactor = nBins / (max - min);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = offset + bScale * (double)data[i][j];
                val = Math.max(0.0, Math.min(val, max - min));
                ++totalCount;
                int n = (int)(val * linearScaleFactor);
                counts[n] = counts[n] + 1;
            }
        }
        return new Histogram(min, max, totalCount, counts);
    }

    public static Histogram computeHistogram(int[][] data, double bZero, double bScale) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        int totalCount = 0;
        int[] counts = new int[(int)(nBins + 1.0)];
        Arrays.fill(counts, 0);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = bZero + bScale * (double)data[i][j];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double offset = bZero - min;
        double linearScaleFactor = nBins / (max - min);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = offset + bScale * (double)data[i][j];
                val = Math.max(0.0, Math.min(val, max - min));
                ++totalCount;
                int n = (int)(val * linearScaleFactor);
                counts[n] = counts[n] + 1;
            }
        }
        return new Histogram(min, max, totalCount, counts);
    }

    public static Histogram computeHistogram(float[][] data, double bZero, double bScale) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        int totalCount = 0;
        int[] counts = new int[(int)(nBins + 1.0)];
        Arrays.fill(counts, 0);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = bZero + bScale * (double)data[i][j];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double offset = bZero - min;
        double linearScaleFactor = nBins / (max - min);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = offset + bScale * (double)data[i][j];
                val = Math.max(0.0, Math.min(val, max - min));
                ++totalCount;
                int n = (int)(val * linearScaleFactor);
                counts[n] = counts[n] + 1;
            }
        }
        return new Histogram(min, max, totalCount, counts);
    }

    public static Histogram computeHistogram(double[][] data, double bZero, double bScale) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double nBins = Math.pow(2.0, 16.0) - 1.0;
        int totalCount = 0;
        int[] counts = new int[(int)(nBins + 1.0)];
        Arrays.fill(counts, 0);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = bZero + bScale * data[i][j];
                if (val > max) {
                    max = val;
                }
                if (!(val < min)) continue;
                min = val;
            }
        }
        double offset = bZero - min;
        double linearScaleFactor = nBins / (max - min);
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double val = offset + bScale * data[i][j];
                val = Math.max(0.0, Math.min(val, max - min));
                ++totalCount;
                int n = (int)(val * linearScaleFactor);
                counts[n] = counts[n] + 1;
            }
        }
        return new Histogram(min, max, totalCount, counts);
    }

    public static String revision() {
        return "$Revision: 1.14 $";
    }

    protected static double[] createSqrtMap(int size) {
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Math.sqrt(i);
        }
        return result;
    }

    protected static double[] createLogMap(int size) {
        double[] result = new double[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i == 0 ? 0.0 : Math.log(i);
        }
        return result;
    }
}

