/*==============================================================*/
/*                                                              */
/*                UK Astronomy Technology Centre                */
/*                 Royal Observatory, Edinburgh                 */
/*                 Joint Astronomy Centre, Hilo                 */
/*                   Copyright (c) PPARC 2001                   */
/*                                                              */
/*==============================================================*/
// $Id: LineCatalog.java,v 1.1 2003/06/02 09:22:10 pwd Exp $

/*
 * Submillimeter Line Catalog in java format.
 * The lines are taken from the JPL catalog.
 *
 *  Authors :
 *   Merce Crosas (mcrosas@cfa.harvard.edu)
 *  History :
 *   01-Aug-1997: original (mcrosas@cfa.harvard.edu)
 *   15-Feb-2000: added returnLines() (bdk@roe.ac.uk)
 *   23-Feb-2000: added returnSpecies() (bdk@roe.ac.uk)
 *   31-MAY-2003: hacked to run standalone and create SPLAT ids files
 *                (p.w.draper@durham.ac.uk)
 */

//package edfreq;

//import java.util.*;

import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.util.regex.Pattern;

/**
 * @author Dennis Kelly ( bdk@roe.ac.uk )
 * @author Peter W. Draper (p.w.draper@durham.ac.uk)
 */
public class LineCatalog
{
   public static int nspec = 35;
   public static int nlinesMax = 1300;
   public static int[] nlines = new int[nspec];
   public static String[] specCat = new String[nspec];
   public static String[][] transCat = new String[nspec][nlinesMax];
   public static double[][] dfreqCat = new double[nspec][nlinesMax];

   public LineCatalog(){

      dfreqCat[0][0] = 230538.0000;
      transCat[0][0] = "2  - 1 ";
      dfreqCat[0][1] = 345795.9899;
      transCat[0][1] = "3  - 2 ";
      dfreqCat[0][2] = 461040.7682;
      transCat[0][2] = "4  - 3 ";
      dfreqCat[0][3] = 576267.9305;
      transCat[0][3] = "5  - 4 ";
      dfreqCat[0][4] = 691473.0763;
      transCat[0][4] = "6  - 5 ";
      dfreqCat[0][5] = 806651.8060;
      transCat[0][5] = "7  - 6 ";
      dfreqCat[0][6] = 921799.7000;
      transCat[0][6] = "8  - 7 ";
      dfreqCat[0][7] = 1036912.3930;
      transCat[0][7] = "9  - 8 ";
      dfreqCat[0][8] = 1151985.4520;
      transCat[0][8] = "10  - 9 ";
      dfreqCat[0][9] = 1267014.4860;
      transCat[0][9] = "11  - 10 ";
      dfreqCat[0][10] = 1381995.1050;
      transCat[0][10] = "12  - 11 ";
      dfreqCat[0][11] = 1496922.9090;
      transCat[0][11] = "13  - 12 ";
      dfreqCat[0][12] = 1611793.5180;
      transCat[0][12] = "14  - 13 ";
      dfreqCat[0][13] = 1726602.5066;
      transCat[0][13] = "15  - 14 ";
      specCat[0] = "CO";
      nlines[0] = 14;
      dfreqCat[1][0] = 220398.6765;
      transCat[1][0] = "2  - 1 ";
      dfreqCat[1][1] = 330587.9601;
      transCat[1][1] = "3  - 2 ";
      dfreqCat[1][2] = 440765.1668;
      transCat[1][2] = "4  - 3 ";
      dfreqCat[1][3] = 550926.3029;
      transCat[1][3] = "5  - 4 ";
      dfreqCat[1][4] = 661067.2801;
      transCat[1][4] = "6  - 5 ";
      dfreqCat[1][5] = 771184.1376;
      transCat[1][5] = "7  - 6 ";
      dfreqCat[1][6] = 881272.8339;
      transCat[1][6] = "8  - 7 ";
      specCat[1] = "13-CO";
      nlines[1] = 7;
      dfreqCat[2][0] = 219560.3568;
      transCat[2][0] = "2  - 1 ";
      dfreqCat[2][1] = 329330.5453;
      transCat[2][1] = "3  - 2 ";
      dfreqCat[2][2] = 439088.7631;
      transCat[2][2] = "4  - 3 ";
      dfreqCat[2][3] = 548830.9775;
      transCat[2][3] = "5  - 4 ";
      dfreqCat[2][4] = 658553.2728;
      transCat[2][4] = "6  - 5 ";
      dfreqCat[2][5] = 768251.5890;
      transCat[2][5] = "7  - 6 ";
      dfreqCat[2][6] = 877921.9561;
      transCat[2][6] = "8  - 7 ";
      dfreqCat[2][7] = 987560.3837;
      transCat[2][7] = "9  - 8 ";
      specCat[2] = "C-18-O";
      nlines[2] = 8;
      dfreqCat[3][0] = 224714.3850;
      transCat[3][0] = "2  - 1 ";
      dfreqCat[3][1] = 337061.1298;
      transCat[3][1] = "3  - 2 ";
      dfreqCat[3][2] = 449395.3412;
      transCat[3][2] = "4  - 3 ";
      dfreqCat[3][3] = 561712.7845;
      transCat[3][3] = "5  - 4 ";
      dfreqCat[3][4] = 674009.3443;
      transCat[3][4] = "6  - 5 ";
      dfreqCat[3][5] = 786280.8166;
      transCat[3][5] = "7  - 6 ";
      dfreqCat[3][6] = 898523.0217;
      transCat[3][6] = "8  - 7 ";
      specCat[3] = "C-17-O";
      nlines[3] = 7;
      dfreqCat[4][0] = 265886.1800;
      transCat[4][0] = "3  - 2 ";
      dfreqCat[4][1] = 354505.4759;
      transCat[4][1] = "4  - 3 ";
      dfreqCat[4][2] = 443116.1554;
      transCat[4][2] = "5  - 4 ";
      dfreqCat[4][3] = 531716.3875;
      transCat[4][3] = "6  - 5 ";
      dfreqCat[4][4] = 620304.0952;
      transCat[4][4] = "7  - 6 ";
      dfreqCat[4][5] = 708877.2081;
      transCat[4][5] = "8  - 7 ";
      dfreqCat[4][6] = 797433.6638;
      transCat[4][6] = "9  - 8 ";
      dfreqCat[4][7] = 885971.4087;
      transCat[4][7] = "10  - 9 ";
      specCat[4] = "HCN";
      nlines[4] = 8;
      dfreqCat[5][0] = 259011.8211;
      transCat[5][0] = "3  - 2 ";
      dfreqCat[5][1] = 345339.7599;
      transCat[5][1] = "4  - 3 ";
      dfreqCat[5][2] = 431659.6973;
      transCat[5][2] = "5  - 4 ";
      dfreqCat[5][3] = 517969.6330;
      transCat[5][3] = "6  - 5 ";
      dfreqCat[5][4] = 604267.5667;
      transCat[5][4] = "7  - 6 ";
      dfreqCat[5][5] = 690551.4980;
      transCat[5][5] = "8  - 7 ";
      dfreqCat[5][6] = 776819.4265;
      transCat[5][6] = "9  - 8 ";
      dfreqCat[5][7] = 863069.3520;
      transCat[5][7] = "10  - 9 ";
      dfreqCat[5][8] = 949299.2741;
      transCat[5][8] = "11  - 10 ";
      specCat[5] = "H-13-CN";
      nlines[5] = 9;
      dfreqCat[6][0] = 271981.1420;
      transCat[6][0] = "3  - 2 ";
      dfreqCat[6][1] = 362630.3030;
      transCat[6][1] = "4  - 3 ";
      dfreqCat[6][2] = 453269.8531;
      transCat[6][2] = "5  - 4 ";
      dfreqCat[6][3] = 543897.3856;
      transCat[6][3] = "6  - 5 ";
      dfreqCat[6][4] = 634510.4973;
      transCat[6][4] = "7  - 6 ";
      dfreqCat[6][5] = 725106.7847;
      transCat[6][5] = "8  - 7 ";
      dfreqCat[6][6] = 815683.8445;
      transCat[6][6] = "9  - 8 ";
      dfreqCat[6][7] = 906239.2730;
      transCat[6][7] = "10  - 9 ";
      dfreqCat[6][8] = 996770.6669;
      transCat[6][8] = "11  - 10 ";
      specCat[6] = "HNC";
      nlines[6] = 9;
      dfreqCat[7][0] = 267557.6190;
      transCat[7][0] = "3 - 2 ";
      dfreqCat[7][1] = 356734.2880;
      transCat[7][1] = "4 - 3 ";
      dfreqCat[7][2] = 445902.9960;
      transCat[7][2] = "5 - 4 ";
      dfreqCat[7][3] = 535061.7755;
      transCat[7][3] = "6 - 5 ";
      dfreqCat[7][4] = 624208.6733;
      transCat[7][4] = "7 - 6 ";
      dfreqCat[7][5] = 713342.0900;
      transCat[7][5] = "8 - 7 ";
      dfreqCat[7][6] = 802458.3290;
      transCat[7][6] = "9 - 8 ";
      dfreqCat[7][7] = 891557.9242;
      transCat[7][7] = "10 - 9 ";
      dfreqCat[7][8] = 980637.4000;
      transCat[7][8] = "11 - 10 ";
      specCat[7] = "HCO+ v=0";
      nlines[7] = 9;
      dfreqCat[8][0] = 260255.4780;
      transCat[8][0] = "3 - 2 ";
      dfreqCat[8][1] = 346998.5400;
      transCat[8][1] = "4 - 3 ";
      dfreqCat[8][2] = 433734.0900;
      transCat[8][2] = "5 - 4 ";
      dfreqCat[8][3] = 520460.2500;
      transCat[8][3] = "6 - 5 ";
      dfreqCat[8][4] = 607175.1420;
      transCat[8][4] = "7 - 6 ";
      dfreqCat[8][5] = 693876.8880;
      transCat[8][5] = "8 - 7 ";
      dfreqCat[8][6] = 780563.6100;
      transCat[8][6] = "9 - 8 ";
      dfreqCat[8][7] = 867233.4300;
      transCat[8][7] = "10 - 9 ";
      dfreqCat[8][8] = 953884.4700;
      transCat[8][8] = "11 - 10 ";
      specCat[8] = "H-13-CO+ v=0";
      nlines[8] = 9;
      dfreqCat[9][0] = 195954.2260;
      transCat[9][0] = "4  - 3 ";
      dfreqCat[9][1] = 244935.6435;
      transCat[9][1] = "5  - 4 ";
      dfreqCat[9][2] = 293912.2440;
      transCat[9][2] = "6  - 5 ";
      dfreqCat[9][3] = 342883.0000;
      transCat[9][3] = "7  - 6 ";
      dfreqCat[9][4] = 391847.0300;
      transCat[9][4] = "8  - 7 ";
      dfreqCat[9][5] = 440803.3920;
      transCat[9][5] = "9  - 8 ";
      dfreqCat[9][6] = 489751.0400;
      transCat[9][6] = "10  - 9 ";
      dfreqCat[9][7] = 538688.8300;
      transCat[9][7] = "11  - 10 ";
      dfreqCat[9][8] = 587616.2402;
      transCat[9][8] = "12  - 11 ";
      dfreqCat[9][9] = 636531.8412;
      transCat[9][9] = "13  - 12 ";
      dfreqCat[9][10] = 685434.7644;
      transCat[9][10] = "14  - 13 ";
      dfreqCat[9][11] = 734323.9973;
      transCat[9][11] = "15  - 14 ";
      dfreqCat[9][12] = 783198.5190;
      transCat[9][12] = "16  - 15 ";
      dfreqCat[9][13] = 832057.2996;
      transCat[9][13] = "17  - 16 ";
      dfreqCat[9][14] = 880899.2998;
      transCat[9][14] = "18  - 17 ";
      specCat[9] = "CS";
      nlines[9] = 15;
      dfreqCat[10][0] = 231220.9960;
      transCat[10][0] = "5  - 4 ";
      dfreqCat[10][1] = 277455.4810;
      transCat[10][1] = "6  - 5 ";
      dfreqCat[10][2] = 323684.8280;
      transCat[10][2] = "7  - 6 ";
      dfreqCat[10][3] = 369907.8439;
      transCat[10][3] = "8  - 7 ";
      dfreqCat[10][4] = 416123.4864;
      transCat[10][4] = "9  - 8 ";
      dfreqCat[10][5] = 462330.6438;
      transCat[10][5] = "10  - 9 ";
      dfreqCat[10][6] = 508528.1375;
      transCat[10][6] = "11  - 10 ";
      dfreqCat[10][7] = 554714.7143;
      transCat[10][7] = "12  - 11 ";
      dfreqCat[10][8] = 600889.0392;
      transCat[10][8] = "13  - 12 ";
      dfreqCat[10][9] = 647049.6875;
      transCat[10][9] = "14  - 13 ";
      dfreqCat[10][10] = 693195.1382;
      transCat[10][10] = "15  - 14 ";
      dfreqCat[10][11] = 739323.7654;
      transCat[10][11] = "16  - 15 ";
      dfreqCat[10][12] = 785433.8319;
      transCat[10][12] = "17  - 16 ";
      dfreqCat[10][13] = 831523.4813;
      transCat[10][13] = "18  - 17 ";
      specCat[10] = "13-CS";
      nlines[10] = 14;
     dfreqCat[11][0] = 192818.4640;
      transCat[11][0] = "4  - 3 ";
      dfreqCat[11][1] = 241016.1940;
      transCat[11][1] = "5  - 4 ";
      dfreqCat[11][2] = 289209.2300;
      transCat[11][2] = "6  - 5 ";
      dfreqCat[11][3] = 337396.6901;
      transCat[11][3] = "7  - 6 ";
      dfreqCat[11][4] = 385577.5984;
      transCat[11][4] = "8  - 7 ";
      dfreqCat[11][5] = 433750.9839;
      transCat[11][5] = "9  - 8 ";
      dfreqCat[11][6] = 481915.8594;
      transCat[11][6] = "10  - 9 ";
      dfreqCat[11][7] = 530071.2208;
      transCat[11][7] = "11  - 10 ";
      dfreqCat[11][8] = 578216.0459;
      transCat[11][8] = "12  - 11 ";
      dfreqCat[11][9] = 626349.2919;
      transCat[11][9] = "13  - 12 ";
      dfreqCat[11][10] = 674469.8941;
      transCat[11][10] = "14  - 13 ";
      dfreqCat[11][11] = 722576.7639;
      transCat[11][11] = "15  - 14 ";
      dfreqCat[11][12] = 770668.7866;
      transCat[11][12] = "16  - 15 ";
      dfreqCat[11][13] = 818744.8201;
      transCat[11][13] = "17  - 16 ";
      dfreqCat[11][14] = 866803.6928;
      transCat[11][14] = "18  - 17 ";
      specCat[11] = "C-34-S";
      nlines[11] = 15;

      dfreqCat[12][0] = 492160.7000;
      transCat[12][0] = "1 - 0 ";
      dfreqCat[12][1] = 809343.5000;
      transCat[12][1] = "2 - 1 ";
      specCat[12] = "CI";
      nlines[12] = 2;

      dfreqCat[13][0] = 492160.0000;
      transCat[13][0] = "1 1  - 0 1 ";
      dfreqCat[13][1] = 492164.2000;
      transCat[13][1] = "1 2 - 0 1 ";
      dfreqCat[13][2] = 809124.0000;
      transCat[13][2] = "2 2 - 1 2 ";
      dfreqCat[13][3] = 809128.2000;
      transCat[13][3] = "2 2 - 1 1 ";
      dfreqCat[13][4] = 809496.6000;
      transCat[13][4] = "2 3 - 1 2 ";
      specCat[13] = "13-CI";
      nlines[13] = 5;

      dfreqCat[14][0] = 181296.0300;
      transCat[14][0] = "7 1 4  - 6 0 3 ";
      dfreqCat[14][1] = 181771.0500;
      transCat[14][1] = "4 2 4  - 5 1 4 ";
      dfreqCat[14][2] = 183124.9773;
      transCat[14][2] = "9 2 2  - 8 3 2 ";
      dfreqCat[14][3] = 183853.0000;
      transCat[14][3] = "5 2 2  - 6 1 2 ";
      dfreqCat[14][4] = 183879.9600;
      transCat[14][4] = "9 2 1  - 8 3 1 ";
      dfreqCat[14][5] = 186300.9500;
      transCat[14][5] = "6 4 4  - 7 3 4 ";
      dfreqCat[14][6] = 191810.4900;
      transCat[14][6] = "4 1 1  - 3 1 1 ";
      dfreqCat[14][7] = 198403.2200;
      transCat[14][7] = "10 0 1  - 9 1 1 ";
      dfreqCat[14][8] = 201445.4885;
      transCat[14][8] = "5 2 1  - 6 1 1 ";
      dfreqCat[14][9] = 205791.2813;
      transCat[14][9] = "1 1 1  - 2 0 1 ";
      dfreqCat[14][10] = 216945.6143;
      transCat[14][10] = "5 1 3  - 4 2 3 ";
      dfreqCat[14][11] = 218440.0396;
      transCat[14][11] = "4 2 3  - 3 1 3 ";
      dfreqCat[14][12] = 220078.5882;
      transCat[14][12] = "8 0 3  - 7 1 3 ";
      dfreqCat[14][13] = 220400.9786;
      transCat[14][13] = "10 5 4  - 11 4 4 ";
      dfreqCat[14][14] = 229758.6841;
      transCat[14][14] = "8 1 4  - 7 0 3 ";
      dfreqCat[14][15] = 230027.0555;
      transCat[14][15] = "3 2 4  - 4 1 4 ";
      dfreqCat[14][16] = 231286.3622;
      transCat[14][16] = "10 2 2  - 9 3 2 ";
      dfreqCat[14][17] = 234683.2014;
      transCat[14][17] = "4 2 2  - 5 1 2 ";
      dfreqCat[14][18] = 234698.4394;
      transCat[14][18] = "5 4 4  - 6 3 4 ";
      dfreqCat[14][19] = 247228.6930;
      transCat[14][19] = "4 2 1  - 5 1 1 ";
      dfreqCat[14][20] = 249443.4020;
      transCat[14][20] = "7 4 2  - 8 3 2 ";
      dfreqCat[14][21] = 250509.4920;
      transCat[14][21] = "11 0 1  - 10 1 1 ";
      dfreqCat[14][22] = 250635.2070;
      transCat[14][22] = "12 3 2  - 12 2 1 ";
      dfreqCat[14][23] = 250924.4230;
      transCat[14][23] = "11 3 2  - 11 2 1 ";
      dfreqCat[14][24] = 251164.0430;
      transCat[14][24] = "10 3 2  - 10 2 1 ";
      dfreqCat[14][25] = 251359.8240;
      transCat[14][25] = "9 3 2  - 9 2 1 ";
      dfreqCat[14][26] = 251517.2620;
      transCat[14][26] = "8 3 2  - 8 2 1 ";
      dfreqCat[14][27] = 251641.6670;
      transCat[14][27] = "7 3 2  - 7 2 1 ";
      dfreqCat[14][28] = 251738.5200;
      transCat[14][28] = "6 3 2  - 6 2 1 ";
      dfreqCat[14][29] = 251811.8820;
      transCat[14][29] = "5 3 2  - 5 2 1 ";
      dfreqCat[14][30] = 251866.5790;
      transCat[14][30] = "4 3 2  - 4 2 1 ";
      dfreqCat[14][31] = 251890.9010;
      transCat[14][31] = "5 3 1  - 5 2 2 ";
      dfreqCat[14][32] = 251895.7280;
      transCat[14][32] = "6 3 1  - 6 2 2 ";
      dfreqCat[14][33] = 251900.4950;
      transCat[14][33] = "4 3 1  - 4 2 2 ";
      dfreqCat[14][34] = 251905.8120;
      transCat[14][34] = "3 3 2  - 3 2 1 ";
      dfreqCat[14][35] = 251923.6310;
      transCat[14][35] = "7 3 1  - 7 2 2 ";
      dfreqCat[14][36] = 251984.7020;
      transCat[14][36] = "8 3 1  - 8 2 2 ";
      dfreqCat[14][37] = 252090.4000;
      transCat[14][37] = "9 3 1  - 9 2 2 ";
      dfreqCat[14][38] = 252252.8720;
      transCat[14][38] = "10 3 1  - 10 2 2 ";
      dfreqCat[14][39] = 252485.6490;
      transCat[14][39] = "11 3 1  - 11 2 2 ";
      dfreqCat[14][40] = 252803.3770;
      transCat[14][40] = "12 3 1  - 12 2 2 ";
      dfreqCat[14][41] = 254015.2952;
      transCat[14][41] = "2 0 3  - 1 1 4 ";
      dfreqCat[14][42] = 254419.2110;
      transCat[14][42] = "11 5 3  - 12 4 3 ";
      dfreqCat[14][43] = 261805.7071;
      transCat[14][43] = "2 1 3  - 1 0 3 ";
      dfreqCat[14][44] = 265289.6639;
      transCat[14][44] = "6 1 3  - 5 2 3 ";
      dfreqCat[14][45] = 266838.1604;
      transCat[14][45] = "5 2 3  - 4 1 3 ";
      dfreqCat[14][46] = 267403.5350;
      transCat[14][46] = "9 0 3  - 8 1 3 ";
      dfreqCat[14][47] = 278342.2965;
      transCat[14][47] = "2 2 4  - 3 1 4 ";
      dfreqCat[14][48] = 279368.0339;
      transCat[14][48] = "11 2 2  - 10 3 2 ";
      dfreqCat[14][49] = 283094.8248;
      transCat[14][49] = "4 4 4  - 5 3 4 ";
      dfreqCat[14][50] = 285110.9937;
      transCat[14][50] = "3 2 2  - 4 1 2 ";
      dfreqCat[14][51] = 287670.8350;
      transCat[14][51] = "6 1 1  - 5 1 1 ";
      dfreqCat[14][52] = 293464.0654;
      transCat[14][52] = "3 2 1  - 4 1 1 ";
      dfreqCat[14][53] = 297821.2467;
      transCat[14][53] = "6 4 2  - 7 3 2 ";
      dfreqCat[14][54] = 302369.7348;
      transCat[14][54] = "3 0 3  - 2 1 4 ";
      dfreqCat[14][55] = 302830.3693;
      transCat[14][55] = "10 5 3  - 11 4 3 ";
      dfreqCat[14][56] = 303366.9435;
      transCat[14][56] = "1 1 2  - 1 0 1 ";
      dfreqCat[14][57] = 304208.3326;
      transCat[14][57] = "2 1 2  - 2 0 1 ";
      dfreqCat[14][58] = 305473.4515;
      transCat[14][58] = "3 1 2  - 3 0 1 ";
      dfreqCat[14][59] = 307165.8910;
      transCat[14][59] = "4 1 2  - 4 0 1 ";
      dfreqCat[14][60] = 309290.3605;
      transCat[14][60] = "5 1 2  - 5 0 1 ";
      dfreqCat[14][61] = 310053.7513;
      transCat[14][61] = "11 6 3  - 12 5 3 ";
      dfreqCat[14][62] = 310193.0176;
      transCat[14][62] = "3 1 3  - 2 0 3 ";
      dfreqCat[14][63] = 311852.6400;
      transCat[14][63] = "6 1 2  - 6 0 1 ";
      dfreqCat[14][64] = 314351.2598;
      transCat[14][64] = "10 0 3  - 9 1 3 ";
      dfreqCat[14][65] = 314859.5248;
      transCat[14][65] = "7 1 2  - 7 0 1 ";
      dfreqCat[14][66] = 315266.8768;
      transCat[14][66] = "6 2 3  - 5 1 3 ";
      dfreqCat[14][67] = 317101.8522;
      transCat[14][67] = "8 5 4  - 9 4 4 ";
      dfreqCat[14][68] = 322239.3868;
      transCat[14][68] = "9 1 2  - 9 0 1 ";
      dfreqCat[14][69] = 326631.1202;
      transCat[14][69] = "10 1 2  - 10 0 1 ";
      dfreqCat[14][70] = 327358.1818;
      transCat[14][70] = "12 2 2  - 11 3 2 ";
      dfreqCat[14][71] = 335133.5130;
      transCat[14][71] = "2 2 2  - 3 1 2 ";
      dfreqCat[14][72] = 335582.0050;
      transCat[14][72] = "7 1 1  - 6 1 1 ";
      dfreqCat[14][73] = 336874.3522;
      transCat[14][73] = "12 1 2  - 12 0 1 ";
      dfreqCat[14][74] = 337135.9128;
      transCat[14][74] = "3 3 3  - 4 2 3 ";
      dfreqCat[14][75] = 338124.5020;
      transCat[14][75] = "7 0 3  - 6 0 3 ";
      dfreqCat[14][76] = 340141.1577;
      transCat[14][76] = "2 2 1  - 3 1 1 ";
      dfreqCat[14][77] = 341415.5000;
      transCat[14][77] = "7 1 2  - 6 1 2 ";
      dfreqCat[14][78] = 350687.6685;
      transCat[14][78] = "4 0 3  - 3 1 4 ";
      dfreqCat[14][79] = 350905.1190;
      transCat[14][79] = "1 1 1  - 0 0 1 ";
      dfreqCat[14][80] = 351235.9233;
      transCat[14][80] = "9 5 3  - 10 4 3 ";
      dfreqCat[14][81] = 358417.6367;
      transCat[14][81] = "10 6 3  - 11 5 3 ";
      dfreqCat[14][82] = 358605.8466;
      transCat[14][82] = "4 1 3  - 3 0 3 ";
      dfreqCat[14][83] = 360849.7663;
      transCat[14][83] = "11 0 3  - 10 1 3 ";
      dfreqCat[14][84] = 361852.2168;
      transCat[14][84] = "8 1 3  - 7 2 3 ";
      dfreqCat[14][85] = 363739.8284;
      transCat[14][85] = "7 2 3  - 6 1 3 ";
      dfreqCat[14][86] = 375759.4384;
      transCat[14][86] = "11 1 4  - 10 0 3 ";
      dfreqCat[14][87] = 383477.9072;
      transCat[14][87] = "8 1 1  - 7 1 1 ";
      dfreqCat[14][88] = 394587.0625;
      transCat[14][88] = "4 4 1  - 5 3 1 ";
      dfreqCat[14][89] = 397039.0910;
      transCat[14][89] = "3 3 1  - 2 2 1 ";
      dfreqCat[14][90] = 398446.9631;
      transCat[14][90] = "2 1 1  - 1 0 1 ";
      dfreqCat[14][91] = 398946.2630;
      transCat[14][91] = "5 0 3  - 4 1 4 ";
      dfreqCat[14][92] = 399636.9123;
      transCat[14][92] = "8 5 3  - 9 4 3 ";
      dfreqCat[14][93] = 406794.4852;
      transCat[14][93] = "9 6 3  - 10 5 3 ";
      dfreqCat[14][94] = 406827.3633;
      transCat[14][94] = "12 0 3  - 11 1 3 ";
      dfreqCat[14][95] = 407069.5947;
      transCat[14][95] = "5 1 3  - 4 0 3 ";
      dfreqCat[14][96] = 410040.0494;
      transCat[14][96] = "9 1 3  - 8 2 3 ";
      dfreqCat[14][97] = 412271.4994;
      transCat[14][97] = "8 2 3  - 7 1 3 ";
      dfreqCat[14][98] = 423439.6921;
      transCat[14][98] = "2 2 4  - 2 1 4 ";
      dfreqCat[14][99] = 423468.6630;
      transCat[14][99] = "3 2 4  - 3 1 4 ";
      dfreqCat[14][100] = 423538.2580;
      transCat[14][100] = "4 2 4  - 4 1 4 ";
      dfreqCat[14][101] = 423675.1550;
      transCat[14][101] = "5 2 4  - 5 1 4 ";
      dfreqCat[14][102] = 423912.6960;
      transCat[14][102] = "6 2 4  - 6 1 4 ";
      dfreqCat[14][103] = 424290.9628;
      transCat[14][103] = "7 2 4  - 7 1 4 ";
      dfreqCat[14][104] = 424728.7831;
      transCat[14][104] = "12 1 4  - 11 0 3 ";
      dfreqCat[14][105] = 424857.2630;
      transCat[14][105] = "8 2 4  - 8 1 4 ";
      dfreqCat[14][106] = 425666.0858;
      transCat[14][106] = "9 2 4  - 9 1 4 ";
      dfreqCat[14][107] = 426779.9239;
      transCat[14][107] = "10 2 4  - 10 1 4 ";
      dfreqCat[14][108] = 428269.7308;
      transCat[14][108] = "11 2 4  - 11 1 4 ";
      dfreqCat[14][109] = 430215.9948;
      transCat[14][109] = "12 2 4  - 12 1 4 ";
      dfreqCat[14][110] = 431356.3438;
      transCat[14][110] = "9 1 1  - 8 1 1 ";
      dfreqCat[14][111] = 445377.1490;
      transCat[14][111] = "4 3 1  - 3 2 1 ";
      dfreqCat[14][112] = 445571.3543;
      transCat[14][112] = "3 1 1  - 2 0 1 ";
      dfreqCat[14][113] = 447118.4295;
      transCat[14][113] = "6 0 3  - 5 1 4 ";
      dfreqCat[14][114] = 448034.1662;
      transCat[14][114] = "7 5 3  - 8 4 3 ";
      dfreqCat[14][115] = 452669.4182;
      transCat[14][115] = "12 2 1  - 12 1 2 ";
      dfreqCat[14][116] = 455181.1208;
      transCat[14][116] = "8 6 3  - 9 5 3 ";
      dfreqCat[14][117] = 455618.1532;
      transCat[14][117] = "6 1 3  - 5 0 3 ";
      dfreqCat[14][118] = 457000.4317;
      transCat[14][118] = "11 2 1  - 11 1 2 ";
      dfreqCat[14][119] = 458144.9904;
      transCat[14][119] = "10 1 3  - 9 2 3 ";
      dfreqCat[14][120] = 460875.9495;
      transCat[14][120] = "9 2 3  - 8 1 3 ";
      dfreqCat[14][121] = 461063.0209;
      transCat[14][121] = "10 2 1  - 10 1 2 ";
      dfreqCat[14][122] = 462239.8644;
      transCat[14][122] = "5 5 4  - 6 4 4 ";
      dfreqCat[14][123] = 464834.7037;
      transCat[14][123] = "9 2 1  - 9 1 2 ";
      dfreqCat[14][124] = 468293.7710;
      transCat[14][124] = "8 2 1  - 8 1 2 ";
      dfreqCat[14][125] = 471420.4347;
      transCat[14][125] = "7 2 1  - 7 1 2 ";
      dfreqCat[14][126] = 474196.1583;
      transCat[14][126] = "6 2 1  - 6 1 2 ";
      dfreqCat[14][127] = 476604.9903;
      transCat[14][127] = "5 2 1  - 5 1 2 ";
      dfreqCat[14][128] = 478633.1619;
      transCat[14][128] = "4 2 1  - 4 1 2 ";
      dfreqCat[14][129] = 479215.4454;
      transCat[14][129] = "10 1 1  - 9 1 1 ";
      dfreqCat[14][130] = 480269.2503;
      transCat[14][130] = "3 2 1  - 3 1 2 ";
      dfreqCat[14][131] = 481504.1794;
      transCat[14][131] = "2 2 1  - 2 1 2 ";
      dfreqCat[14][132] = 482282.1905;
      transCat[14][132] = "10 0 3  - 9 0 3 ";
      dfreqCat[14][133] = 484004.6210;
      transCat[14][133] = "2 2 2  - 2 1 1 ";
      dfreqCat[14][134] = 484023.4703;
      transCat[14][134] = "10 2 3  - 9 2 3 ";
      dfreqCat[14][135] = 485263.1671;
      transCat[14][135] = "3 2 2  - 3 1 1 ";
      dfreqCat[14][136] = 486940.7501;
      transCat[14][136] = "4 2 2  - 4 1 1 ";
      dfreqCat[14][137] = 487533.0349;
      transCat[14][137] = "10 1 2  - 9 1 2 ";
      dfreqCat[14][138] = 489036.8495;
      transCat[14][138] = "5 2 2  - 5 1 1 ";
      dfreqCat[14][139] = 491550.7343;
      transCat[14][139] = "6 2 2  - 6 1 1 ";
      dfreqCat[14][140] = 492278.6364;
      transCat[14][140] = "4 1 1  - 3 0 1 ";
      dfreqCat[14][141] = 493699.1458;
      transCat[14][141] = "5 3 1  - 4 2 1 ";
      dfreqCat[14][142] = 494481.4993;
      transCat[14][142] = "7 2 2  - 7 1 1 ";
      dfreqCat[14][143] = 496428.2971;
      transCat[14][143] = "6 5 3  - 7 4 3 ";
      dfreqCat[14][144] = 497828.1975;
      transCat[14][144] = "8 2 2  - 8 1 1 ";
      dfreqCat[14][145] = 501590.1202;
      transCat[14][145] = "9 2 2  - 9 1 1 ";
      dfreqCat[14][146] = 503574.5802;
      transCat[14][146] = "7 6 3  - 8 5 3 ";
      dfreqCat[14][147] = 505767.2779;
      transCat[14][147] = "10 2 2  - 10 1 1 ";
      dfreqCat[14][148] = 509564.9541;
      transCat[14][148] = "10 2 3  - 9 1 3 ";
      dfreqCat[14][149] = 510361.1512;
      transCat[14][149] = "11 2 2  - 11 1 1 ";
      dfreqCat[14][150] = 515375.7823;
      transCat[14][150] = "12 2 2  - 12 1 1 ";
      dfreqCat[14][151] = 520179.0001;
      transCat[14][151] = "2 2 4  - 1 1 4 ";
      dfreqCat[14][152] = 524360.2966;
      transCat[14][152] = "12 4 4  - 12 3 4 ";
      dfreqCat[14][153] = 524477.6594;
      transCat[14][153] = "11 4 4  - 11 3 4 ";
      dfreqCat[14][154] = 524578.1913;
      transCat[14][154] = "10 4 4  - 10 3 4 ";
      dfreqCat[14][155] = 524664.9434;
      transCat[14][155] = "9 4 4  - 9 3 4 ";
      dfreqCat[14][156] = 524740.0660;
      transCat[14][156] = "8 4 4  - 8 3 4 ";
      dfreqCat[14][157] = 524805.0346;
      transCat[14][157] = "7 4 4  - 7 3 4 ";
      dfreqCat[14][158] = 524860.8304;
      transCat[14][158] = "6 4 4  - 6 3 4 ";
      dfreqCat[14][159] = 524908.0808;
      transCat[14][159] = "5 4 4  - 5 3 4 ";
      dfreqCat[14][160] = 524947.1670;
      transCat[14][160] = "4 4 4  - 4 3 4 ";
      dfreqCat[14][161] = 527053.4021;
      transCat[14][161] = "11 1 1  - 10 1 1 ";
      dfreqCat[14][162] = 528695.9100;
      transCat[14][162] = "12 3 3  - 12 2 3 ";
      dfreqCat[14][163] = 529146.7596;
      transCat[14][163] = "11 3 3  - 11 2 3 ";
      dfreqCat[14][164] = 529540.9102;
      transCat[14][164] = "10 3 3  - 10 2 3 ";
      dfreqCat[14][165] = 529866.7050;
      transCat[14][165] = "9 3 3  - 9 2 3 ";
      dfreqCat[14][166] = 530123.2940;
      transCat[14][166] = "8 3 3  - 8 2 3 ";
      dfreqCat[14][167] = 530184.9807;
      transCat[14][167] = "11 0 3  - 10 0 3 ";
      dfreqCat[14][168] = 530316.1960;
      transCat[14][168] = "7 3 3  - 7 2 3 ";
      dfreqCat[14][169] = 530454.6950;
      transCat[14][169] = "6 3 3  - 6 2 3 ";
      dfreqCat[14][170] = 530549.2710;
      transCat[14][170] = "5 3 3  - 5 2 3 ";
      dfreqCat[14][171] = 530610.2880;
      transCat[14][171] = "4 3 3  - 4 2 3 ";
      dfreqCat[14][172] = 530647.2770;
      transCat[14][172] = "3 3 3  - 3 2 3 ";
      dfreqCat[14][173] = 531080.3276;
      transCat[14][173] = "11 1 4  - 10 1 4 ";
      dfreqCat[14][174] = 538570.4654;
      transCat[14][174] = "5 1 1  - 4 0 1 ";
      dfreqCat[14][175] = 542000.9474;
      transCat[14][175] = "6 3 1  - 5 2 1 ";
      dfreqCat[14][176] = 543076.2761;
      transCat[14][176] = "8 0 3  - 7 1 4 ";
      dfreqCat[14][177] = 544819.6923;
      transCat[14][177] = "5 5 3  - 6 4 3 ";
      dfreqCat[14][178] = 551972.1043;
      transCat[14][178] = "6 6 3  - 7 5 3 ";
      dfreqCat[14][179] = 554059.1401;
      transCat[14][179] = "12 1 3  - 11 2 3 ";
      dfreqCat[14][180] = 558345.3903;
      transCat[14][180] = "11 2 3  - 10 1 3 ";
      dfreqCat[14][181] = 568566.0450;
      transCat[14][181] = "3 2 4  - 2 1 4 ";
      dfreqCat[14][182] = 574868.5406;
      transCat[14][182] = "12 1 1  - 11 1 1 ";
      dfreqCat[14][183] = 579084.6405;
      transCat[14][183] = "2 2 2  - 1 1 2 ";
      dfreqCat[14][184] = 579154.3254;
      transCat[14][184] = "12 1 4  - 11 1 4 ";
      dfreqCat[14][185] = 579921.2307;
      transCat[14][185] = "2 2 1  - 1 1 1 ";
      dfreqCat[14][186] = 579981.7066;
      transCat[14][186] = "12 5 3  - 11 5 3 ";
      dfreqCat[14][187] = 584449.8622;
      transCat[14][187] = "6 1 1  - 5 0 1 ";
      dfreqCat[14][188] = 584833.4572;
      transCat[14][188] = "12 1 2  - 11 1 2 ";
      dfreqCat[14][189] = 590277.6880;
      transCat[14][189] = "7 3 1  - 6 2 1 ";
      dfreqCat[14][190] = 590791.0532;
      transCat[14][190] = "9 0 3  - 8 1 4 ";
      dfreqCat[14][191] = 607215.6815;
      transCat[14][191] = "12 2 3  - 11 1 3 ";
      dfreqCat[14][192] = 616979.8668;
      transCat[14][192] = "4 2 4  - 3 1 4 ";
      dfreqCat[14][193] = 626626.1888;
      transCat[14][193] = "3 2 2  - 2 1 2 ";
      dfreqCat[14][194] = 629921.2479;
      transCat[14][194] = "7 1 1  - 6 0 1 ";
      dfreqCat[14][195] = 636238.2680;
      transCat[14][195] = "12 4 2  - 12 3 1 ";
      dfreqCat[14][196] = 636259.8546;
      transCat[14][196] = "11 4 2  - 11 3 1 ";
      dfreqCat[14][197] = 636264.0656;
      transCat[14][197] = "10 4 1  - 10 3 2 ";
      dfreqCat[14][198] = 636279.9980;
      transCat[14][198] = "9 4 1  - 9 3 2 ";
      dfreqCat[14][199] = 636287.1936;
      transCat[14][199] = "12 4 1  - 12 3 2 ";
      dfreqCat[14][200] = 636290.7110;
      transCat[14][200] = "9 4 2  - 9 3 1 ";
      dfreqCat[14][201] = 636304.3550;
      transCat[14][201] = "8 4 1  - 8 3 2 ";
      dfreqCat[14][202] = 636333.4700;
      transCat[14][202] = "7 4 1  - 7 3 2 ";
      dfreqCat[14][203] = 636363.8430;
      transCat[14][203] = "6 4 1  - 6 3 2 ";
      dfreqCat[14][204] = 636393.5680;
      transCat[14][204] = "5 4 1  - 5 3 2 ";
      dfreqCat[14][205] = 636420.2310;
      transCat[14][205] = "4 4 1  - 4 3 2 ";
      dfreqCat[14][206] = 638279.8576;
      transCat[14][206] = "10 0 3  - 9 1 4 ";
      dfreqCat[14][207] = 638523.4860;
      transCat[14][207] = "8 3 1  - 7 2 1 ";
      dfreqCat[14][208] = 651617.4049;
      transCat[14][208] = "10 1 3  - 9 0 3 ";
      dfreqCat[14][209] = 665442.4393;
      transCat[14][209] = "5 2 4  - 4 1 4 ";
      dfreqCat[14][210] = 673745.9350;
      transCat[14][210] = "4 2 2  - 3 1 2 ";
      dfreqCat[14][211] = 674990.4705;
      transCat[14][211] = "8 1 1  - 7 0 1 ";
      dfreqCat[14][212] = 675773.4081;
      transCat[14][212] = "3 3 3  - 2 2 3 ";
      dfreqCat[14][213] = 678785.3353;
      transCat[14][213] = "4 2 1  - 3 1 1 ";
      dfreqCat[14][214] = 685505.8699;
      transCat[14][214] = "11 0 3  - 10 1 4 ";
      dfreqCat[14][215] = 686732.5727;
      transCat[14][215] = "9 3 1  - 8 2 1 ";
      dfreqCat[14][216] = 701367.7212;
      transCat[14][216] = "11 1 3  - 10 0 3 ";
      dfreqCat[14][217] = 713982.4700;
      transCat[14][217] = "6 2 4  - 5 1 4 ";
      dfreqCat[14][218] = 718436.2990;
      transCat[14][218] = "4 4 4  - 3 3 4 ";
      dfreqCat[14][219] = 719664.8175;
      transCat[14][219] = "9 1 1  - 8 0 1 ";
      dfreqCat[14][220] = 720441.4238;
      transCat[14][220] = "5 2 2  - 4 1 2 ";
      dfreqCat[14][221] = 724121.6665;
      transCat[14][221] = "4 3 3  - 3 2 3 ";
      dfreqCat[14][222] = 728862.5389;
      transCat[14][222] = "5 2 1  - 4 1 1 ";
      dfreqCat[14][223] = 732435.6460;
      transCat[14][223] = "12 0 3  - 11 1 4 ";
      dfreqCat[14][224] = 734899.0034;
      transCat[14][224] = "10 3 1  - 9 2 1 ";
      dfreqCat[14][225] = 751554.7641;
      transCat[14][225] = "12 1 3  - 11 0 3 ";
      dfreqCat[14][226] = 752114.7032;
      transCat[14][226] = "11 5 4  - 11 4 4 ";
      dfreqCat[14][227] = 752162.7894;
      transCat[14][227] = "10 5 4  - 10 4 4 ";
      dfreqCat[14][228] = 752211.5759;
      transCat[14][228] = "9 5 4  - 9 4 4 ";
      dfreqCat[14][229] = 752260.9507;
      transCat[14][229] = "8 5 4  - 8 4 4 ";
      dfreqCat[14][230] = 752310.0780;
      transCat[14][230] = "7 5 4  - 7 4 4 ";
      dfreqCat[14][231] = 752357.6791;
      transCat[14][231] = "6 5 4  - 6 4 4 ";
      dfreqCat[14][232] = 752402.2554;
      transCat[14][232] = "5 5 4  - 5 4 4 ";
      dfreqCat[14][233] = 762635.5837;
      transCat[14][233] = "7 2 4  - 6 1 4 ";
      dfreqCat[14][234] = 763953.0007;
      transCat[14][234] = "10 1 1  - 9 0 1 ";
      dfreqCat[14][235] = 766710.2361;
      transCat[14][235] = "6 2 2  - 5 1 2 ";
      dfreqCat[14][236] = 766760.4230;
      transCat[14][236] = "5 4 4  - 4 3 4 ";
      dfreqCat[14][237] = 779380.4131;
      transCat[14][237] = "6 2 1  - 5 1 1 ";
      dfreqCat[14][238] = 783017.7848;
      transCat[14][238] = "11 3 1  - 10 2 1 ";
      dfreqCat[14][239] = 811444.4937;
      transCat[14][239] = "8 2 4  - 7 1 4 ";
      dfreqCat[14][240] = 812550.1098;
      transCat[14][240] = "7 2 2  - 6 1 2 ";
      dfreqCat[14][241] = 815070.4718;
      transCat[14][241] = "6 4 4  - 5 3 4 ";
      dfreqCat[14][242] = 829891.2950;
      transCat[14][242] = "4 4 1  - 3 3 1 ";
      dfreqCat[14][243] = 830349.4120;
      transCat[14][243] = "7 2 1  - 6 1 1 ";
      dfreqCat[14][244] = 831085.9501;
      transCat[14][244] = "12 3 1  - 11 2 1 ";
      dfreqCat[14][245] = 834540.6658;
      transCat[14][245] = "11 5 3  - 11 4 3 ";
      dfreqCat[14][246] = 834657.6299;
      transCat[14][246] = "10 5 3  - 10 4 3 ";
      dfreqCat[14][247] = 834755.2769;
      transCat[14][247] = "9 5 3  - 9 4 3 ";
      dfreqCat[14][248] = 834836.4711;
      transCat[14][248] = "8 5 3  - 8 4 3 ";
      dfreqCat[14][249] = 834903.5780;
      transCat[14][249] = "7 5 3  - 7 4 3 ";
      dfreqCat[14][250] = 834958.5465;
      transCat[14][250] = "6 5 3  - 6 4 3 ";
      dfreqCat[14][251] = 835002.9741;
      transCat[14][251] = "5 5 3  - 5 4 3 ";
      dfreqCat[14][252] = 851412.4601;
      transCat[14][252] = "12 1 1  - 11 0 1 ";
      dfreqCat[14][253] = 857959.1432;
      transCat[14][253] = "8 2 2  - 7 1 2 ";
      dfreqCat[14][254] = 860459.4720;
      transCat[14][254] = "9 2 4  - 8 1 4 ";
      dfreqCat[14][255] = 863364.9316;
      transCat[14][255] = "7 4 4  - 6 3 4 ";
      dfreqCat[14][256] = 878226.3706;
      transCat[14][256] = "5 4 1  - 4 3 1 ";
      dfreqCat[14][257] = 881782.1435;
      transCat[14][257] = "8 2 1  - 7 1 1 ";
      dfreqCat[14][258] = 889939.2008;
      transCat[14][258] = "12 6 3  - 12 5 3 ";
      dfreqCat[14][259] = 890036.0000;
      transCat[14][259] = "11 6 3  - 11 5 3 ";
      dfreqCat[14][260] = 890127.0000;
      transCat[14][260] = "10 6 3  - 10 5 3 ";
      dfreqCat[14][261] = 890214.0000;
      transCat[14][261] = "9 6 3  - 9 5 3 ";
      dfreqCat[14][262] = 890299.0000;
      transCat[14][262] = "8 6 3  - 8 5 3 ";
      dfreqCat[14][263] = 890377.0000;
      transCat[14][263] = "7 6 3  - 7 5 3 ";
      dfreqCat[14][264] = 890450.0000;
      transCat[14][264] = "6 6 3  - 6 5 3 ";
      dfreqCat[14][265] = 902936.1066;
      transCat[14][265] = "9 2 2  - 8 1 2 ";
      dfreqCat[14][266] = 909738.8923;
      transCat[14][266] = "10 2 4  - 9 1 4 ";
      dfreqCat[14][267] = 911641.9588;
      transCat[14][267] = "8 4 4  - 7 3 4 ";
      specCat[14] = "CH3OH";
      nlines[14] = 268;

      dfreqCat[15][0] = 185607.1000;
      transCat[15][0] = "16 2 14  - 16 2 15 ";
      dfreqCat[15][1] = 194932.0426;
      transCat[15][1] = "25 3 22  - 25 3 23 ";
      dfreqCat[15][2] = 211211.4690;
      transCat[15][2] = "3 1 3  - 2 1 2 ";
      dfreqCat[15][3] = 216568.7100;
      transCat[15][3] = "9 1 8  - 9 1 9 ";
      dfreqCat[15][4] = 218222.1860;
      transCat[15][4] = "3 0 3  - 2 0 2 ";
      dfreqCat[15][5] = 227583.5200;
      transCat[15][5] = "17 2 15  - 17 2 16 ";
      dfreqCat[15][6] = 236589.1012;
      transCat[15][6] = "26 3 23  - 26 3 24 ";
      dfreqCat[15][7] = 264270.1400;
      transCat[15][7] = "10 1 9  - 10 1 10 ";
      dfreqCat[15][8] = 274617.5800;
      transCat[15][8] = "18 2 16  - 18 2 17 ";
      dfreqCat[15][9] = 281526.9490;
      transCat[15][9] = "4 1 4  - 3 1 3 ";
      dfreqCat[15][10] = 283639.5509;
      transCat[15][10] = "27 3 24  - 27 3 25 ";
      dfreqCat[15][11] = 290623.5100;
      transCat[15][11] = "4 0 4  - 3 0 3 ";
      dfreqCat[15][12] = 316456.9101;
      transCat[15][12] = "11 1 10  - 11 1 11 ";
      dfreqCat[15][13] = 326655.9255;
      transCat[15][13] = "19 2 17  - 19 2 18 ";
      dfreqCat[15][14] = 336140.0951;
      transCat[15][14] = "28 3 25  - 28 3 26 ";
      dfreqCat[15][15] = 351768.6577;
      transCat[15][15] = "5 1 5  - 4 1 4 ";
      dfreqCat[15][16] = 372986.3487;
      transCat[15][16] = "12 1 11  - 12 1 12 ";
      dfreqCat[15][17] = 375893.2314;
      transCat[15][17] = "5 1 4  - 4 1 3 ";
      dfreqCat[15][18] = 383592.1960;
      transCat[15][18] = "20 2 18  - 20 2 19 ";
      dfreqCat[15][19] = 394068.5174;
      transCat[15][19] = "29 3 26  - 29 3 27 ";
      dfreqCat[15][20] = 421920.7686;
      transCat[15][20] = "6 1 6  - 5 1 5 ";
      dfreqCat[15][21] = 433677.8655;
      transCat[15][21] = "13 1 12  - 13 1 13 ";
      dfreqCat[15][22] = 434493.1016;
      transCat[15][22] = "6 0 6  - 5 0 5 ";
      dfreqCat[15][23] = 445273.5792;
      transCat[15][23] = "21 2 19  - 21 2 20 ";
      dfreqCat[15][24] = 450844.6679;
      transCat[15][24] = "6 1 5  - 5 1 4 ";
      dfreqCat[15][25] = 457331.0273;
      transCat[15][25] = "30 3 27  - 30 3 28 ";
      dfreqCat[15][26] = 491968.9364;
      transCat[15][26] = "7 1 7  - 6 1 6 ";
      dfreqCat[15][27] = 498308.3524;
      transCat[15][27] = "14 1 13  - 14 1 14 ";
      dfreqCat[15][28] = 505834.2731;
      transCat[15][28] = "7 0 7  - 6 0 6 ";
      dfreqCat[15][29] = 511506.0620;
      transCat[15][29] = "22 2 20  - 22 2 21 ";
      dfreqCat[15][30] = 513076.9313;
      transCat[15][30] = "7 2 5  - 6 2 4 ";
      dfreqCat[15][31] = 561900.7214;
      transCat[15][31] = "8 1 8  - 7 1 7 ";
      dfreqCat[15][32] = 566608.9618;
      transCat[15][32] = "15 1 14  - 15 1 15 ";
      dfreqCat[15][33] = 576709.7119;
      transCat[15][33] = "8 0 8  - 7 0 7 ";
      dfreqCat[15][34] = 582057.0679;
      transCat[15][34] = "23 2 21  - 23 2 22 ";
      dfreqCat[15][35] = 582068.2584;
      transCat[15][35] = "8 6 3  - 7 6 2 ";
      dfreqCat[15][36] = 631705.7681;
      transCat[15][36] = "9 1 9  - 8 1 8 ";
      dfreqCat[15][37] = 638263.4817;
      transCat[15][37] = "16 1 15  - 16 1 16 ";
      dfreqCat[15][38] = 647084.6802;
      transCat[15][38] = "9 0 9  - 8 0 8 ";
      dfreqCat[15][39] = 656656.4166;
      transCat[15][39] = "24 2 22  - 24 2 23 ";
      dfreqCat[15][40] = 662212.0774;
      transCat[15][40] = "9 2 7  - 8 2 6 ";
      dfreqCat[15][41] = 701375.9670;
      transCat[15][41] = "10 1 10  - 9 1 9 ";
      dfreqCat[15][42] = 712909.0289;
      transCat[15][42] = "17 1 16  - 17 1 17 ";
      dfreqCat[15][43] = 716943.8685;
      transCat[15][43] = "10 0 10  - 9 0 9 ";
      dfreqCat[15][44] = 734996.2406;
      transCat[15][44] = "25 2 23  - 25 2 24 ";
      dfreqCat[15][45] = 737348.1364;
      transCat[15][45] = "10 2 8  - 9 2 7 ";
      dfreqCat[15][46] = 770905.5525;
      transCat[15][46] = "11 1 11  - 10 1 10 ";
      dfreqCat[15][47] = 790139.7374;
      transCat[15][47] = "18 1 17  - 18 1 18 ";
      dfreqCat[15][48] = 798200.9127;
      transCat[15][48] = "11 10 2  - 10 10 1 ";
      dfreqCat[15][49] = 816730.6717;
      transCat[15][49] = "26 2 24  - 26 2 25 ";
      dfreqCat[15][50] = 823092.2715;
      transCat[15][50] = "11 1 10  - 10 1 9 ";
      dfreqCat[15][51] = 840291.1310;
      transCat[15][51] = "12 1 12  - 11 1 11 ";
      dfreqCat[15][52] = 869514.0090;
      transCat[15][52] = "19 1 18  - 19 1 19 ";
      dfreqCat[15][53] = 870001.2549;
      transCat[15][53] = "12 11 2  - 11 11 1 ";
      dfreqCat[15][54] = 901476.1421;
      transCat[15][54] = "27 2 25  - 27 2 26 ";
      dfreqCat[15][55] = 909531.6354;
      transCat[15][55] = "13 1 13  - 12 1 12 ";
      specCat[15] = "H2CO";
      nlines[15] = 56;

      dfreqCat[16][0] = 183675.9620;
      transCat[16][0] = "10 9 0 10  - 9 9 0 9 ";
      dfreqCat[16][1] = 201966.6057;
      transCat[16][1] = "11 10 0 11  - 10 10 0 10 ";
      dfreqCat[16][2] = 220234.5936;
      transCat[16][2] = "12 11 0 12  - 11 11 0 11 ";
      dfreqCat[16][3] = 238477.8151;
      transCat[16][3] = "13 12 0 13  - 12 12 0 12 ";
      dfreqCat[16][4] = 256816.8411;
      transCat[16][4] = "14 12 0 14  - 13 12 0 13 ";
      dfreqCat[16][5] = 275023.2536;
      transCat[16][5] = "15 13 0 15  - 14 13 0 14 ";
      dfreqCat[16][6] = 293199.9963;
      transCat[16][6] = "16 14 0 16  - 15 14 0 15 ";
      dfreqCat[16][7] = 311345.0332;
      transCat[16][7] = "17 15 0 17  - 16 15 0 16 ";
      dfreqCat[16][8] = 329650.4836;
      transCat[16][8] = "18 15 0 18  - 17 15 0 17 ";
      dfreqCat[16][9] = 347954.3768;
      transCat[16][9] = "19 15 0 19  - 18 15 0 18 ";
      dfreqCat[16][10] = 366256.6289;
      transCat[16][10] = "20 15 0 20  - 19 15 0 19 ";
      dfreqCat[16][11] = 384557.1552;
      transCat[16][11] = "21 15 0 21  - 20 15 0 20 ";
      dfreqCat[16][12] = 402856.0020;
      transCat[16][12] = "22 15 0 22  - 21 15 0 21 ";
      dfreqCat[16][13] = 420905.2391;
      transCat[16][13] = "23 16 0 23  - 22 16 0 22 ";
      dfreqCat[16][14] = 439189.4583;
      transCat[16][14] = "24 16 0 24  - 23 16 0 23 ";
      dfreqCat[16][15] = 457471.6272;
      transCat[16][15] = "25 16 0 25  - 24 16 0 24 ";
      dfreqCat[16][16] = 475751.6605;
      transCat[16][16] = "26 16 0 26  - 25 16 0 25 ";
      dfreqCat[16][17] = 494029.4730;
      transCat[16][17] = "27 16 0 27  - 26 16 0 26 ";
      dfreqCat[16][18] = 512304.9792;
      transCat[16][18] = "28 16 0 28  - 27 16 0 27 ";
      dfreqCat[16][19] = 530578.0935;
      transCat[16][19] = "29 16 0 29  - 28 16 0 28 ";
      dfreqCat[16][20] = 548848.7304;
      transCat[16][20] = "30 16 0 30  - 29 16 0 29 ";
      dfreqCat[16][21] = 567116.8042;
      transCat[16][21] = "31 16 0 31  - 30 16 0 30 ";
      dfreqCat[16][22] = 585382.2291;
      transCat[16][22] = "32 16 0 32  - 31 16 0 31 ";
      dfreqCat[16][23] = 603644.9192;
      transCat[16][23] = "33 16 0 33  - 32 16 0 32 ";
      dfreqCat[16][24] = 621904.7888;
      transCat[16][24] = "34 16 0 34  - 33 16 0 33 ";
      dfreqCat[16][25] = 640161.7518;
      transCat[16][25] = "35 16 0 35  - 34 16 0 34 ";
      dfreqCat[16][26] = 658415.7221;
      transCat[16][26] = "36 16 0 36  - 35 16 0 35 ";
      dfreqCat[16][27] = 676666.6138;
      transCat[16][27] = "37 16 0 37  - 36 16 0 36 ";
      dfreqCat[16][28] = 694914.3407;
      transCat[16][28] = "38 16 0 38  - 37 16 0 37 ";
      dfreqCat[16][29] = 713158.8165;
      transCat[16][29] = "39 16 0 39  - 38 16 0 38 ";
      dfreqCat[16][30] = 731399.9551;
      transCat[16][30] = "40 16 0 40  - 39 16 0 39 ";
      dfreqCat[16][31] = 749637.6700;
      transCat[16][31] = "41 16 0 41  - 40 16 0 40 ";
      dfreqCat[16][32] = 767871.8748;
      transCat[16][32] = "42 16 0 42  - 41 16 0 41 ";
      dfreqCat[16][33] = 786102.4832;
      transCat[16][33] = "43 16 0 43  - 42 16 0 42 ";
      dfreqCat[16][34] = 804329.4086;
      transCat[16][34] = "44 16 0 44  - 43 16 0 43 ";
      dfreqCat[16][35] = 822552.5643;
      transCat[16][35] = "45 16 0 45  - 44 16 0 44 ";
      dfreqCat[16][36] = 840771.8638;
      transCat[16][36] = "46 16 0 46  - 45 16 0 45 ";
      dfreqCat[16][37] = 858987.2202;
      transCat[16][37] = "47 16 0 47  - 46 16 0 46 ";
      dfreqCat[16][38] = 877198.5469;
      transCat[16][38] = "48 16 0 48  - 47 16 0 47 ";
      dfreqCat[16][39] = 895405.7568;
      transCat[16][39] = "49 16 0 49  - 48 16 0 48 ";
      dfreqCat[16][40] = 913608.7632;
      transCat[16][40] = "50 16 0 50  - 49 16 0 49 ";
      specCat[16] = "CH3CN v8=0,1";
      nlines[16] = 41;

      dfreqCat[17][0] = 183310.0910;
      transCat[17][0] = "3 1 3  - 2 2 0 ";
      dfreqCat[17][1] = 325152.9200;
      transCat[17][1] = "5 1 5  - 4 2 2 ";
      dfreqCat[17][2] = 380197.3700;
      transCat[17][2] = "4 1 4  - 3 2 1 ";
      dfreqCat[17][3] = 437346.6700;
      transCat[17][3] = "7 5 3  - 6 6 0 ";
      dfreqCat[17][4] = 439150.8100;
      transCat[17][4] = "6 4 3  - 5 5 0 ";
      dfreqCat[17][5] = 443018.3000;
      transCat[17][5] = "7 5 2  - 6 6 1 ";
      dfreqCat[17][6] = 448001.0800;
      transCat[17][6] = "4 2 3  - 3 3 0 ";
      dfreqCat[17][7] = 470888.9500;
      transCat[17][7] = "6 4 2  - 5 5 1 ";
      dfreqCat[17][8] = 474689.1300;
      transCat[17][8] = "5 3 3  - 4 4 0 ";
      dfreqCat[17][9] = 488491.1300;
      transCat[17][9] = "6 2 4  - 7 1 7 ";
      dfreqCat[17][10] = 556936.0000;
      transCat[17][10] = "1 1 0  - 1 0 1 ";
      dfreqCat[17][11] = 620700.8100;
      transCat[17][11] = "5 3 2  - 4 4 1 ";
      dfreqCat[17][12] = 752033.2300;
      transCat[17][12] = "2 1 1  - 2 0 2 ";
      dfreqCat[17][13] = 906207.3247;
      transCat[17][13] = "9 2 8  - 8 3 5 ";
      dfreqCat[17][14] = 916171.5800;
      transCat[17][14] = "4 2 2  - 3 3 1 ";
      specCat[17] = "H2O";
      nlines[17] = 15;

      dfreqCat[18][0] = 178875.2474;
      transCat[18][0] = "2 -1 3 3  - 2 1 2 2 ";
      dfreqCat[18][1] = 532723.3105;
      transCat[18][1] = "1 1 2 1  - 1 -1 1 1 ";
      specCat[18] = "CH";
      nlines[18] = 2;
      specCat[19] = "OH";
      nlines[19] = 0;
      dfreqCat[20][0] = 572498.0678;
      transCat[20][0] = "1 0 0  - 0 0 1 ";
      specCat[20] = "NH3";
      nlines[20] = 1;

      dfreqCat[21][0] = 364797.4270;
      transCat[21][0] = "3 2 0  - 2 2 1 ";
      specCat[21] = "H3O+";
      nlines[21] = 1;

      dfreqCat[22][0] = 226287.4265;
      transCat[22][0] = "2 0 2 1  - 1 0 2 1 ";
      dfreqCat[22][1] = 339446.7770;
      transCat[22][1] = "3 0 3 2  - 2 0 3 2 ";
      dfreqCat[22][2] = 452589.7255;
      transCat[22][2] = "4 0 4 3  - 3 0 4 3 ";
      dfreqCat[22][3] = 565713.3526;
      transCat[22][3] = "5 0 5 4  - 4 0 5 4 ";
      dfreqCat[22][4] = 678813.5261;
      transCat[22][4] = "6 0 6 5  - 5 0 6 5 ";
      dfreqCat[22][5] = 791885.8149;
      transCat[22][5] = "7 0 7 6  - 6 0 7 6 ";
      dfreqCat[22][6] = 904925.6911;
      transCat[22][6] = "8 0 8 7  - 7 0 8 7 ";
      specCat[22] = "CN, v = 0, 1";
      nlines[22] = 7;

      dfreqCat[23][0] = 216559.9736;
      transCat[23][0] = "2 3 2 1  - 1 2 2 1 ";
      dfreqCat[23][1] = 325047.1376;
      transCat[23][1] = "3 4 3 2  - 2 3 3 2 ";
      dfreqCat[23][2] = 433513.6415;
      transCat[23][2] = "4 5 4 3  - 3 4 4 3 ";
      dfreqCat[23][3] = 541958.6686;
      transCat[23][3] = "5 6 5 4  - 4 5 5 4 ";
      dfreqCat[23][4] = 650379.7588;
      transCat[23][4] = "6 7 6 5  - 5 6 6 5 ";
      dfreqCat[23][5] = 758773.6601;
      transCat[23][5] = "7 8 7 6  - 6 7 7 6 ";
      dfreqCat[23][6] = 867136.7178;
      transCat[23][6] = "8 9 8 7  - 7 8 8 7 ";
      specCat[23] = "C-13-N";
      nlines[23] = 7;

      dfreqCat[24][0] = 186344.7710;
      transCat[24][0] = "2  - 1 ";
      dfreqCat[24][1] = 279511.7010;
      transCat[24][1] = "3  - 2 ";
      dfreqCat[24][2] = 372672.5090;
      transCat[24][2] = "4  - 3 ";
      dfreqCat[24][3] = 465824.9470;
      transCat[24][3] = "5  - 4 ";
      dfreqCat[24][4] = 558966.6656;
      transCat[24][4] = "6  - 5 ";
      dfreqCat[24][5] = 652095.8651;
      transCat[24][5] = "7  - 6 ";
      dfreqCat[24][6] = 745210.3361;
      transCat[24][6] = "8  - 7 ";
      dfreqCat[24][7] = 838307.9748;
      transCat[24][7] = "9  - 8 ";
      specCat[24] = "N2H+";
      nlines[24] = 8;

      dfreqCat[25][0] = 217104.9800;
      transCat[25][0] = "5  - 4 ";
      dfreqCat[25][1] = 260518.0200;
      transCat[25][1] = "6  - 5 ";
      dfreqCat[25][2] = 303926.9600;
      transCat[25][2] = "7  - 6 ";
      dfreqCat[25][3] = 347330.6310;
      transCat[25][3] = "8  - 7 ";
      dfreqCat[25][4] = 390728.4483;
      transCat[25][4] = "9  - 8 ";
      dfreqCat[25][5] = 434119.5521;
      transCat[25][5] = "10  - 9 ";
      dfreqCat[25][6] = 477503.0965;
      transCat[25][6] = "11  - 10 ";
      dfreqCat[25][7] = 520878.2039;
      transCat[25][7] = "12  - 11 ";
      dfreqCat[25][8] = 564243.9620;
      transCat[25][8] = "13  - 12 ";
      dfreqCat[25][9] = 607599.4207;
      transCat[25][9] = "14  - 13 ";
      dfreqCat[25][10] = 650943.5888;
      transCat[25][10] = "15  - 14 ";
      dfreqCat[25][11] = 694275.4309;
      transCat[25][11] = "16  - 15 ";
      dfreqCat[25][12] = 737593.8640;
      transCat[25][12] = "17  - 16 ";
      dfreqCat[25][13] = 780897.7550;
      transCat[25][13] = "18  - 17 ";
      dfreqCat[25][14] = 824185.9168;
      transCat[25][14] = "19  - 18 ";
      dfreqCat[25][15] = 867457.1055;
      transCat[25][15] = "20  - 19 ";
      dfreqCat[25][16] = 910710.0172;
      transCat[25][16] = "21  - 20 ";
      specCat[25] = "SiO";
      nlines[25] = 17;

      dfreqCat[26][0] = 178605.4030;
      transCat[26][0] = "4 5  - 3 4 ";
      dfreqCat[26][1] = 206176.0050;
      transCat[26][1] = "5 4  - 4 3 ";
      dfreqCat[26][2] = 214357.0390;
      transCat[26][2] = "8 7  - 7 7 ";
      dfreqCat[26][3] = 215220.6530;
      transCat[26][3] = "5 5  - 4 4 ";
      dfreqCat[26][4] = 236452.3254;
      transCat[26][4] = "2 1  - 1 2 ";
      dfreqCat[26][5] = 246404.6867;
      transCat[26][5] = "3 2  - 2 3 ";
      dfreqCat[26][6] = 251825.7700;
      transCat[26][6] = "6 5  - 5 4 ";
      dfreqCat[26][7] = 254573.5004;
      transCat[26][7] = "9 8  - 8 8 ";
      dfreqCat[26][8] = 258255.8130;
      transCat[26][8] = "6 6  - 5 5 ";
      dfreqCat[26][9] = 267197.8968;
      transCat[26][9] = "4 3  - 3 4 ";
      dfreqCat[26][10] = 286340.2070;
      transCat[26][10] = "1 1  - 0 1 ";
      dfreqCat[26][11] = 294768.5694;
      transCat[26][11] = "5 4  - 4 5 ";
      dfreqCat[26][12] = 295355.3053;
      transCat[26][12] = "10 9  - 9 9 ";
      dfreqCat[26][13] = 296550.0450;
      transCat[26][13] = "7 6  - 6 5 ";
      dfreqCat[26][14] = 309502.4440;
      transCat[26][14] = "2 2  - 1 2 ";
      dfreqCat[26][15] = 336553.3459;
      transCat[26][15] = "11 10  - 10 10 ";
      dfreqCat[26][16] = 339341.4590;
      transCat[26][16] = "3 3  - 2 3 ";
      dfreqCat[26][17] = 340714.1550;
      transCat[26][17] = "8 7  - 7 6 ";
      dfreqCat[26][18] = 373344.2892;
      transCat[26][18] = "4 4  - 3 4 ";
      dfreqCat[26][19] = 378064.6926;
      transCat[26][19] = "12 11  - 11 11 ";
      dfreqCat[26][20] = 384527.0956;
      transCat[26][20] = "9 8  - 8 7 ";
      dfreqCat[26][21] = 408636.1950;
      transCat[26][21] = "3 2  - 0 1 ";
      dfreqCat[26][22] = 409959.5775;
      transCat[26][22] = "5 5  - 4 5 ";
      dfreqCat[26][23] = 419816.2134;
      transCat[26][23] = "13 12  - 12 12 ";
      dfreqCat[26][24] = 428110.4589;
      transCat[26][24] = "10 9  - 9 8 ";
      dfreqCat[26][25] = 448265.9932;
      transCat[26][25] = "6 6  - 5 6 ";
      dfreqCat[26][26] = 461754.5957;
      transCat[26][26] = "14 13  - 13 13 ";
      dfreqCat[26][27] = 471537.3786;
      transCat[26][27] = "11 10  - 10 9 ";
      dfreqCat[26][28] = 487708.3564;
      transCat[26][28] = "7 7  - 6 7 ";
      dfreqCat[26][29] = 503840.0719;
      transCat[26][29] = "15 14  - 14 14 ";
      dfreqCat[26][30] = 504676.4122;
      transCat[26][30] = "4 3  - 1 2 ";
      dfreqCat[26][31] = 514853.2107;
      transCat[26][31] = "12 11  - 11 10 ";
      dfreqCat[26][32] = 527941.1269;
      transCat[26][32] = "8 8  - 7 8 ";
      dfreqCat[26][33] = 546042.3609;
      transCat[26][33] = "16 15  - 15 15 ";
      dfreqCat[26][34] = 558086.9374;
      transCat[26][34] = "13 12  - 12 11 ";
      dfreqCat[26][35] = 568741.2727;
      transCat[26][35] = "9 9  - 8 9 ";
      dfreqCat[26][36] = 588337.9718;
      transCat[26][36] = "17 16  - 16 16 ";
      dfreqCat[26][37] = 601257.5619;
      transCat[26][37] = "14 13  - 13 12 ";
      dfreqCat[26][38] = 609959.6920;
      transCat[26][38] = "10 10  - 9 10 ";
      dfreqCat[26][39] = 611552.5834;
      transCat[26][39] = "5 4  - 2 3 ";
      dfreqCat[26][40] = 630708.3696;
      transCat[26][40] = "18 17  - 17 17 ";
      dfreqCat[26][41] = 644377.8137;
      transCat[26][41] = "15 14  - 14 13 ";
      dfreqCat[26][42] = 651493.4553;
      transCat[26][42] = "11 11  - 10 11 ";
      dfreqCat[26][43] = 673138.7015;
      transCat[26][43] = "19 18  - 18 18 ";
      dfreqCat[26][44] = 687456.3635;
      transCat[26][44] = "16 15  - 15 14 ";
      dfreqCat[26][45] = 693269.4306;
      transCat[26][45] = "12 12  - 11 12 ";
      dfreqCat[26][46] = 715616.8933;
      transCat[26][46] = "20 19  - 19 19 ";
      dfreqCat[26][47] = 725199.6910;
      transCat[26][47] = "6 5  - 3 4 ";
      dfreqCat[26][48] = 730499.1854;
      transCat[26][48] = "17 16  - 16 15 ";
      dfreqCat[26][49] = 735234.3051;
      transCat[26][49] = "13 13  - 12 13 ";
      dfreqCat[26][50] = 758132.9986;
      transCat[26][50] = "21 20  - 20 20 ";
      dfreqCat[26][51] = 773510.4200;
      transCat[26][51] = "18 17  - 17 16 ";
      dfreqCat[26][52] = 777348.3116;
      transCat[26][52] = "14 14  - 13 14 ";
      dfreqCat[26][53] = 800678.7212;
      transCat[26][53] = "22 21  - 21 21 ";
      dfreqCat[26][54] = 816492.9334;
      transCat[26][54] = "19 18  - 18 17 ";
      dfreqCat[26][55] = 819581.1687;
      transCat[26][55] = "15 15  - 14 15 ";
      dfreqCat[26][56] = 843144.3253;
      transCat[26][56] = "7 6  - 4 5 ";
      dfreqCat[26][57] = 843247.0601;
      transCat[26][57] = "23 22  - 22 22 ";
      dfreqCat[26][58] = 859448.6885;
      transCat[26][58] = "20 19  - 19 18 ";
      dfreqCat[26][59] = 861909.3855;
      transCat[26][59] = "16 16  - 15 16 ";
      dfreqCat[26][60] = 885832.0424;
      transCat[26][60] = "24 23  - 23 23 ";
      dfreqCat[26][61] = 902378.9972;
      transCat[26][61] = "21 20  - 20 19 ";
      dfreqCat[26][62] = 904314.4272;
      transCat[26][62] = "17 17  - 16 17 ";
      specCat[26] = "SO";
      nlines[26] = 63;

      dfreqCat[27][0] = 216112.6045;
      transCat[27][0] = "3 - 2 ";
      dfreqCat[27][1] = 288143.9110;
      transCat[27][1] = "4 - 3 ";
      dfreqCat[27][2] = 360169.8810;
      transCat[27][2] = "5 - 4 ";
      dfreqCat[27][3] = 432189.0330;
      transCat[27][3] = "6 - 5 ";
      dfreqCat[27][4] = 504200.2000;
      transCat[27][4] = "7 - 6 ";
      dfreqCat[27][5] = 576201.9724;
      transCat[27][5] = "8 - 7 ";
      dfreqCat[27][6] = 648193.0137;
      transCat[27][6] = "9 - 8 ";
      dfreqCat[27][7] = 720171.9825;
      transCat[27][7] = "10 - 9 ";
      dfreqCat[27][8] = 792137.5375;
      transCat[27][8] = "11 - 10 ";
      specCat[27] = "DCO+ v=0";
      nlines[27] = 9;

      dfreqCat[28][0] = 213360.5300;
      transCat[28][0] = "5 - 4 ";
      dfreqCat[28][1] = 256027.8000;
      transCat[28][1] = "6 - 5 ";
      dfreqCat[28][2] = 298690.8925;
      transCat[28][2] = "7 - 6 ";
      dfreqCat[28][3] = 341350.8260;
      transCat[28][3] = "8 - 7 ";
      dfreqCat[28][4] = 384006.6819;
      transCat[28][4] = "9 - 8 ";
      dfreqCat[28][5] = 426657.9505;
      transCat[28][5] = "10 - 9 ";
      dfreqCat[28][6] = 469304.1221;
      transCat[28][6] = "11 - 10 ";
      dfreqCat[28][7] = 511944.6870;
      transCat[28][7] = "12 - 11 ";
      dfreqCat[28][8] = 554579.1355;
      transCat[28][8] = "13 - 12 ";
      specCat[28] = "HCS+";
      nlines[28] = 9;

      dfreqCat[29][0] = 181944.9230;
      transCat[29][0] = "20  - 19 ";
      dfreqCat[29][1] = 191040.2990;
      transCat[29][1] = "21  - 20 ";
      dfreqCat[29][2] = 200135.3920;
      transCat[29][2] = "22  - 21 ";
      dfreqCat[29][3] = 209230.2340;
      transCat[29][3] = "23  - 22 ";
      dfreqCat[29][4] = 218324.7880;
      transCat[29][4] = "24  - 23 ";
      dfreqCat[29][5] = 227418.9062;
      transCat[29][5] = "25  - 24 ";
      dfreqCat[29][6] = 236512.7768;
      transCat[29][6] = "26  - 25 ";
      dfreqCat[29][7] = 245606.3080;
      transCat[29][7] = "27  - 26 ";
      dfreqCat[29][8] = 254699.5000;
      transCat[29][8] = "28  - 27 ";
      dfreqCat[29][9] = 263792.3080;
      transCat[29][9] = "29  - 28 ";
      dfreqCat[29][10] = 272884.7343;
      transCat[29][10] = "30  - 29 ";
      dfreqCat[29][11] = 281976.7772;
      transCat[29][11] = "31  - 30 ";
      dfreqCat[29][12] = 291068.4270;
      transCat[29][12] = "32  - 31 ";
      dfreqCat[29][13] = 300159.6470;
      transCat[29][13] = "33  - 32 ";
      dfreqCat[29][14] = 309250.4300;
      transCat[29][14] = "34  - 33 ";
      dfreqCat[29][15] = 318340.7714;
      transCat[29][15] = "35  - 34 ";
      dfreqCat[29][16] = 327430.6710;
      transCat[29][16] = "36  - 35 ";
      dfreqCat[29][17] = 336520.0840;
      transCat[29][17] = "37  - 36 ";
      dfreqCat[29][18] = 345609.0100;
      transCat[29][18] = "38  - 37 ";
      dfreqCat[29][19] = 354697.4555;
      transCat[29][19] = "39  - 38 ";
      dfreqCat[29][20] = 363785.3970;
      transCat[29][20] = "40  - 39 ";
      dfreqCat[29][21] = 372872.8110;
      transCat[29][21] = "41  - 40 ";
      dfreqCat[29][22] = 381959.6694;
      transCat[29][22] = "42  - 41 ";
      dfreqCat[29][23] = 391045.9951;
      transCat[29][23] = "43  - 42 ";
      dfreqCat[29][24] = 400131.7596;
      transCat[29][24] = "44  - 43 ";
      dfreqCat[29][25] = 409216.9498;
      transCat[29][25] = "45  - 44 ";
      dfreqCat[29][26] = 418301.5529;
      transCat[29][26] = "46  - 45 ";
      dfreqCat[29][27] = 427385.5556;
      transCat[29][27] = "47  - 46 ";
      dfreqCat[29][28] = 436468.9450;
      transCat[29][28] = "48  - 47 ";
      dfreqCat[29][29] = 445551.7220;
      transCat[29][29] = "49  - 48 ";
      dfreqCat[29][30] = 454633.8316;
      transCat[29][30] = "50  - 49 ";
      dfreqCat[29][31] = 463715.3029;
      transCat[29][31] = "51  - 50 ";
      dfreqCat[29][32] = 472796.1087;
      transCat[29][32] = "52  - 51 ";
      dfreqCat[29][33] = 481876.2360;
      transCat[29][33] = "53  - 52 ";
      dfreqCat[29][34] = 490955.6719;
      transCat[29][34] = "54  - 53 ";
      dfreqCat[29][35] = 500034.4032;
      transCat[29][35] = "55  - 54 ";
      dfreqCat[29][36] = 509112.4170;
      transCat[29][36] = "56  - 55 ";
      dfreqCat[29][37] = 518189.7002;
      transCat[29][37] = "57  - 56 ";
      dfreqCat[29][38] = 527266.2399;
      transCat[29][38] = "58  - 57 ";
      dfreqCat[29][39] = 536342.0230;
      transCat[29][39] = "59  - 58 ";
      dfreqCat[29][40] = 545417.0365;
      transCat[29][40] = "60  - 59 ";
      dfreqCat[29][41] = 554491.2673;
      transCat[29][41] = "61  - 60 ";
      dfreqCat[29][42] = 563564.7026;
      transCat[29][42] = "62  - 61 ";
      dfreqCat[29][43] = 572637.3290;
      transCat[29][43] = "63  - 62 ";
      dfreqCat[29][44] = 581709.1290;
      transCat[29][44] = "64  - 63 ";
      dfreqCat[29][45] = 590780.0960;
      transCat[29][45] = "65  - 64 ";
      dfreqCat[29][46] = 599850.2270;
      transCat[29][46] = "66  - 65 ";
      dfreqCat[29][47] = 608919.4840;
      transCat[29][47] = "67  - 66 ";
      dfreqCat[29][48] = 617987.8760;
      transCat[29][48] = "68  - 67 ";
      dfreqCat[29][49] = 627055.3780;
      transCat[29][49] = "69  - 68 ";
      dfreqCat[29][50] = 636121.9780;
      transCat[29][50] = "70  - 69 ";
      dfreqCat[29][51] = 645187.6690;
      transCat[29][51] = "71  - 70 ";
      dfreqCat[29][52] = 654252.4260;
      transCat[29][52] = "72  - 71 ";
      dfreqCat[29][53] = 663316.2570;
      transCat[29][53] = "73  - 72 ";
      dfreqCat[29][54] = 672379.1310;
      transCat[29][54] = "74  - 73 ";
      dfreqCat[29][55] = 681441.0390;
      transCat[29][55] = "75  - 74 ";
      dfreqCat[29][56] = 690501.9750;
      transCat[29][56] = "76  - 75 ";
      dfreqCat[29][57] = 699561.9190;
      transCat[29][57] = "77  - 76 ";
      dfreqCat[29][58] = 708620.8500;
      transCat[29][58] = "78  - 77 ";
      dfreqCat[29][59] = 717678.7679;
      transCat[29][59] = "79  - 78 ";
      dfreqCat[29][60] = 726735.6584;
      transCat[29][60] = "80  - 79 ";
      dfreqCat[29][61] = 735791.5063;
      transCat[29][61] = "81  - 80 ";
      dfreqCat[29][62] = 744846.2987;
      transCat[29][62] = "82  - 81 ";
      dfreqCat[29][63] = 753899.7000;
      transCat[29][63] = "83  - 82 ";
      dfreqCat[29][64] = 762952.6650;
      transCat[29][64] = "84  - 83 ";
      dfreqCat[29][65] = 772004.2129;
      transCat[29][65] = "85  - 84 ";
      dfreqCat[29][66] = 781054.6534;
      transCat[29][66] = "86  - 85 ";
      dfreqCat[29][67] = 790104.3000;
      transCat[29][67] = "87  - 86 ";
      dfreqCat[29][68] = 799152.1603;
      transCat[29][68] = "88  - 87 ";
      dfreqCat[29][69] = 808199.2007;
      transCat[29][69] = "89  - 88 ";
      dfreqCat[29][70] = 817245.0818;
      transCat[29][70] = "90  - 89 ";
      dfreqCat[29][71] = 826289.7908;
      transCat[29][71] = "91  - 90 ";
      dfreqCat[29][72] = 835333.3145;
      transCat[29][72] = "92  - 91 ";
      dfreqCat[29][73] = 844375.6400;
      transCat[29][73] = "93  - 92 ";
      dfreqCat[29][74] = 853416.7545;
      transCat[29][74] = "94  - 93 ";
      dfreqCat[29][75] = 862456.6449;
      transCat[29][75] = "95  - 94 ";
      dfreqCat[29][76] = 871495.2983;
      transCat[29][76] = "96  - 95 ";
      dfreqCat[29][77] = 880532.7017;
      transCat[29][77] = "97  - 96 ";
      dfreqCat[29][78] = 889568.8423;
      transCat[29][78] = "98  - 97 ";
      dfreqCat[29][79] = 898603.7070;
      transCat[29][79] = "99  - 98 ";
      dfreqCat[29][80] = 907637.2830;
      transCat[29][80] = "0  - 99 ";
      dfreqCat[29][81] = 916669.5573;
      transCat[29][81] = "1  - 0 ";
      specCat[29] = "HCCCN";
      nlines[29] = 82;

      dfreqCat[30][0] = 179446.4960;
      transCat[30][0] = "8 0 8  - 7 0 7 ";
      dfreqCat[30][1] = 192860.7013;
      transCat[30][1] = "16 2 14  - 16 2 15 ";
      dfreqCat[30][2] = 193412.3700;
      transCat[30][2] = "9 2 8  - 9 0 9 ";
      dfreqCat[30][3] = 196359.0131;
      transCat[30][3] = "8 2 6  - 7 2 5 ";
      dfreqCat[30][4] = 200162.4377;
      transCat[30][4] = "9 0 9  - 8 0 8 ";
      dfreqCat[30][5] = 205172.8150;
      transCat[30][5] = "10 2 9  - 10 0 10 ";
      dfreqCat[30][6] = 209891.9912;
      transCat[30][6] = "9 2 8  - 8 2 7 ";
      dfreqCat[30][7] = 218786.5206;
      transCat[30][7] = "11 2 10  - 11 0 11 ";
      dfreqCat[30][8] = 220773.7018;
      transCat[30][8] = "10 0 10  - 9 0 9 ";
      dfreqCat[30][9] = 221545.8207;
      transCat[30][9] = "17 2 15  - 17 2 16 ";
      dfreqCat[30][10] = 222009.3598;
      transCat[30][10] = "9 2 7  - 8 2 6 ";
      dfreqCat[30][11] = 232534.0669;
      transCat[30][11] = "10 2 9  - 9 2 8 ";
      dfreqCat[30][12] = 234024.7682;
      transCat[30][12] = "12 2 11  - 12 0 12 ";
      dfreqCat[30][13] = 234534.0110;
      transCat[30][13] = "10 8 2  - 9 8 1 ";
      dfreqCat[30][14] = 241367.7204;
      transCat[30][14] = "11 0 11  - 10 0 10 ";
      dfreqCat[30][15] = 247529.1149;
      transCat[30][15] = "10 2 8  - 9 2 7 ";
      dfreqCat[30][16] = 250443.3962;
      transCat[30][16] = "18 2 16  - 18 2 17 ";
      dfreqCat[30][17] = 250642.5000;
      transCat[30][17] = "13 2 12  - 13 0 13 ";
      dfreqCat[30][18] = 254981.4940;
      transCat[30][18] = "11 2 10  - 10 2 9 ";
      dfreqCat[30][19] = 261990.7450;
      transCat[30][19] = "12 0 12  - 11 0 11 ";
      dfreqCat[30][20] = 268401.0900;
      transCat[30][20] = "14 2 13  - 14 0 14 ";
      dfreqCat[30][21] = 272787.8140;
      transCat[30][21] = "11 2 9  - 10 2 8 ";
      dfreqCat[30][22] = 277229.0010;
      transCat[30][22] = "12 2 11  - 11 2 10 ";
      dfreqCat[30][23] = 279073.0208;
      transCat[30][23] = "19 2 17  - 19 2 18 ";
      dfreqCat[30][24] = 280043.3330;
      transCat[30][24] = "12 10 2  - 11 10 1 ";
      dfreqCat[30][25] = 282659.2830;
      transCat[30][25] = "13 0 13  - 12 0 12 ";
      dfreqCat[30][26] = 283196.6349;
      transCat[30][26] = "12 6 7  - 11 6 6 ";
      dfreqCat[30][27] = 287080.9935;
      transCat[30][27] = "15 2 14  - 15 0 15 ";
      dfreqCat[30][28] = 297687.7235;
      transCat[30][28] = "12 2 10  - 11 2 9 ";
      dfreqCat[30][29] = 299277.0321;
      transCat[30][29] = "13 2 12  - 12 2 11 ";
      dfreqCat[30][30] = 303373.1940;
      transCat[30][30] = "14 0 14  - 13 0 13 ";
      dfreqCat[30][31] = 303440.3491;
      transCat[30][31] = "13 10 3  - 12 10 2 ";
      dfreqCat[30][32] = 306487.7981;
      transCat[30][32] = "16 2 15  - 16 0 16 ";
      dfreqCat[30][33] = 307007.6126;
      transCat[30][33] = "13 6 8  - 12 6 7 ";
      dfreqCat[30][34] = 307058.5824;
      transCat[30][34] = "20 2 18  - 20 2 19 ";
      dfreqCat[30][35] = 309286.5098;
      transCat[30][35] = "13 4 10  - 12 4 9 ";
      dfreqCat[30][36] = 321131.8035;
      transCat[30][36] = "14 2 13  - 13 2 12 ";
      dfreqCat[30][37] = 322151.4381;
      transCat[30][37] = "13 2 11  - 12 2 10 ";
      dfreqCat[30][38] = 324125.1267;
      transCat[30][38] = "15 0 15  - 14 0 14 ";
      dfreqCat[30][39] = 324781.4924;
      transCat[30][39] = "14 12 2  - 13 12 1 ";
      dfreqCat[30][40] = 326454.9815;
      transCat[30][40] = "17 2 16  - 17 0 17 ";
      dfreqCat[30][41] = 326852.1251;
      transCat[30][41] = "14 10 4  - 13 10 3 ";
      dfreqCat[30][42] = 334165.6101;
      transCat[30][42] = "21 2 19  - 21 2 20 ";
      dfreqCat[30][43] = 335289.7038;
      transCat[30][43] = "14 4 10  - 13 4 9 ";
      dfreqCat[30][44] = 342805.0009;
      transCat[30][44] = "15 2 14  - 14 2 13 ";
      dfreqCat[30][45] = 344906.0340;
      transCat[30][45] = "16 0 16  - 15 0 15 ";
      dfreqCat[30][46] = 345586.2172;
      transCat[30][46] = "15 14 1  - 14 14 0 ";
      dfreqCat[30][47] = 346109.9950;
      transCat[30][47] = "14 2 12  - 13 2 11 ";
      dfreqCat[30][48] = 346843.8333;
      transCat[30][48] = "18 2 17  - 18 0 18 ";
      dfreqCat[30][49] = 348018.9465;
      transCat[30][49] = "15 12 3  - 14 12 2 ";
      dfreqCat[30][50] = 356928.3011;
      transCat[30][50] = "20 4 17  - 20 2 18 ";
      dfreqCat[30][51] = 357425.5538;
      transCat[30][51] = "19 4 16  - 19 2 17 ";
      dfreqCat[30][52] = 357473.4230;
      transCat[30][52] = "15 4 12  - 14 4 11 ";
      dfreqCat[30][53] = 359653.7562;
      transCat[30][53] = "21 4 18  - 21 2 19 ";
      dfreqCat[30][54] = 360304.0206;
      transCat[30][54] = "22 2 20  - 22 2 21 ";
      dfreqCat[30][55] = 360472.2050;
      transCat[30][55] = "15 4 11  - 14 4 10 ";
      dfreqCat[30][56] = 361049.7098;
      transCat[30][56] = "18 4 15  - 18 2 16 ";
      dfreqCat[30][57] = 364312.8332;
      transCat[30][57] = "16 2 15  - 15 2 14 ";
      dfreqCat[30][58] = 365516.3091;
      transCat[30][58] = "22 4 19  - 22 2 20 ";
      dfreqCat[30][59] = 365707.4900;
      transCat[30][59] = "17 0 17  - 16 0 16 ";
      dfreqCat[30][60] = 367541.9324;
      transCat[30][60] = "19 2 18  - 19 0 19 ";
      dfreqCat[30][61] = 368632.4882;
      transCat[30][61] = "16 14 2  - 15 14 1 ";
      dfreqCat[30][62] = 369498.2160;
      transCat[30][62] = "15 2 13  - 14 2 12 ";
      dfreqCat[30][63] = 371264.7787;
      transCat[30][63] = "16 12 4  - 15 12 3 ";
      dfreqCat[30][64] = 385674.6759;
      transCat[30][64] = "17 2 16  - 16 2 15 ";
      dfreqCat[30][65] = 386034.6961;
      transCat[30][65] = "16 4 12  - 15 4 11 ";
      dfreqCat[30][66] = 386522.6441;
      transCat[30][66] = "18 0 18  - 17 0 17 ";
      dfreqCat[30][67] = 388460.5316;
      transCat[30][67] = "20 2 19  - 20 0 20 ";
      dfreqCat[30][68] = 388670.0571;
      transCat[30][68] = "17 16 1  - 16 16 0 ";
      dfreqCat[30][69] = 392259.1789;
      transCat[30][69] = "16 2 14  - 15 2 13 ";
      dfreqCat[30][70] = 394519.6745;
      transCat[30][70] = "17 12 5  - 16 12 4 ";
      dfreqCat[30][71] = 406911.4959;
      transCat[30][71] = "18 2 17  - 17 2 16 ";
      dfreqCat[30][72] = 407346.2113;
      transCat[30][72] = "19 0 19  - 18 0 18 ";
      dfreqCat[30][73] = 409531.3308;
      transCat[30][73] = "21 2 20  - 21 0 21 ";
      dfreqCat[30][74] = 411497.7586;
      transCat[30][74] = "18 16 2  - 17 16 1 ";
      dfreqCat[30][75] = 412000.3361;
      transCat[30][75] = "17 4 13  - 16 4 12 ";
      dfreqCat[30][76] = 414730.2639;
      transCat[30][76] = "18 14 4  - 17 14 3 ";
      dfreqCat[30][77] = 428044.3105;
      transCat[30][77] = "19 2 18  - 18 2 17 ";
      dfreqCat[30][78] = 428174.2980;
      transCat[30][78] = "20 0 20  - 19 0 19 ";
      dfreqCat[30][79] = 429340.5406;
      transCat[30][79] = "18 4 15  - 17 4 14 ";
      dfreqCat[30][80] = 430703.0356;
      transCat[30][80] = "22 2 21  - 22 0 22 ";
      dfreqCat[30][81] = 430739.5398;
      transCat[30][81] = "19 18 1  - 18 18 0 ";
      dfreqCat[30][82] = 435809.0714;
      transCat[30][82] = "18 2 16  - 17 2 15 ";
      dfreqCat[30][83] = 437782.1904;
      transCat[30][83] = "19 14 5  - 18 14 4 ";
      dfreqCat[30][84] = 438346.1536;
      transCat[30][84] = "18 4 14  - 17 4 13 ";
      dfreqCat[30][85] = 441059.5456;
      transCat[30][85] = "19 12 7  - 18 12 6 ";
      dfreqCat[30][86] = 449004.0860;
      transCat[30][86] = "21 0 21  - 20 0 20 ";
      dfreqCat[30][87] = 449092.8972;
      transCat[30][87] = "20 2 19  - 19 2 18 ";
      dfreqCat[30][88] = 451103.6179;
      transCat[30][88] = "19 6 14  - 18 6 13 ";
      dfreqCat[30][89] = 453294.6884;
      transCat[30][89] = "20 18 2  - 19 18 1 ";
      dfreqCat[30][90] = 456673.9351;
      transCat[30][90] = "19 2 17  - 18 2 16 ";
      dfreqCat[30][91] = 457135.3369;
      transCat[30][91] = "20 16 4  - 19 16 3 ";
      dfreqCat[30][92] = 464986.9784;
      transCat[30][92] = "19 4 15  - 18 4 14 ";
      dfreqCat[30][93] = 467707.0079;
      transCat[30][93] = "20 10 11  - 19 10 10 ";
      dfreqCat[30][94] = 469833.5572;
      transCat[30][94] = "22 0 22  - 21 0 21 ";
      dfreqCat[30][95] = 470074.8852;
      transCat[30][95] = "21 2 20  - 20 2 19 ";
      dfreqCat[30][96] = 471137.3651;
      transCat[30][96] = "20 8 13  - 19 8 12 ";
      dfreqCat[30][97] = 471795.6306;
      transCat[30][97] = "21 20 1  - 20 20 0 ";
      dfreqCat[30][98] = 475353.7099;
      transCat[30][98] = "20 6 15  - 19 6 14 ";
      dfreqCat[30][99] = 475831.6864;
      transCat[30][99] = "21 18 3  - 20 18 2 ";
      dfreqCat[30][100] = 476581.2061;
      transCat[30][100] = "20 4 17  - 19 4 16 ";
      dfreqCat[30][101] = 479944.6949;
      transCat[30][101] = "21 16 5  - 20 16 4 ";
      dfreqCat[30][102] = 491005.2620;
      transCat[30][102] = "22 2 21  - 21 2 20 ";
      dfreqCat[30][103] = 491260.2653;
      transCat[30][103] = "21 10 12  - 20 10 11 ";
      dfreqCat[30][104] = 491775.2997;
      transCat[30][104] = "20 4 16  - 19 4 15 ";
      dfreqCat[30][105] = 493872.8089;
      transCat[30][105] = "22 20 2  - 21 20 1 ";
      dfreqCat[30][106] = 495002.3351;
      transCat[30][106] = "21 8 14  - 20 8 13 ";
      dfreqCat[30][107] = 498349.5319;
      transCat[30][107] = "22 18 4  - 21 18 3 ";
      dfreqCat[30][108] = 499671.7544;
      transCat[30][108] = "21 6 16  - 20 6 15 ";
      dfreqCat[30][109] = 502747.4423;
      transCat[30][109] = "22 16 6  - 21 16 5 ";
      specCat[30] = "SiCC";
      nlines[30] = 110;
      dfreqCat[31][0] = 182427.1956;
      transCat[31][0] = "15  - 14 ";
      dfreqCat[31][1] = 194586.4330;
      transCat[31][1] = "16  - 15 ";
      dfreqCat[31][2] = 206745.1610;
      transCat[31][2] = "17  - 16 ";
      dfreqCat[31][3] = 218903.3565;
      transCat[31][3] = "18  - 17 ";
      dfreqCat[31][4] = 231060.9830;
      transCat[31][4] = "19  - 18 ";
      dfreqCat[31][5] = 243218.0400;
      transCat[31][5] = "20  - 19 ";
      dfreqCat[31][6] = 255374.4610;
      transCat[31][6] = "21  - 20 ";
      dfreqCat[31][7] = 267530.2390;
      transCat[31][7] = "22  - 21 ";
      dfreqCat[31][8] = 279685.3180;
      transCat[31][8] = "23  - 22 ";
      dfreqCat[31][9] = 291839.6730;
      transCat[31][9] = "24  - 23 ";
      dfreqCat[31][10] = 303993.2420;
      transCat[31][10] = "25  - 24 ";
      dfreqCat[31][11] = 316146.0630;
      transCat[31][11] = "26  - 25 ";
      dfreqCat[31][12] = 328298.1073;
      transCat[31][12] = "27  - 26 ";
      dfreqCat[31][13] = 340449.2000;
      transCat[31][13] = "28  - 27 ";
      dfreqCat[31][14] = 352599.5757;
      transCat[31][14] = "29  - 28 ";
      dfreqCat[31][15] = 364748.9600;
      transCat[31][15] = "30  - 29 ";
      dfreqCat[31][16] = 376897.4201;
      transCat[31][16] = "31  - 30 ";
      dfreqCat[31][17] = 389041.0000;
      transCat[31][17] = "32  - 31 ";
      dfreqCat[31][18] = 401191.3880;
      transCat[31][18] = "33  - 32 ";
      dfreqCat[31][19] = 413336.8447;
      transCat[31][19] = "34  - 33 ";
      dfreqCat[31][20] = 425481.2366;
      transCat[31][20] = "35  - 34 ";
      dfreqCat[31][21] = 437624.5620;
      transCat[31][21] = "36  - 35 ";
      dfreqCat[31][22] = 449766.7085;
      transCat[31][22] = "37  - 36 ";
      dfreqCat[31][23] = 461907.7259;
      transCat[31][23] = "38  - 37 ";
      dfreqCat[31][24] = 474047.5600;
      transCat[31][24] = "39  - 38 ";
      dfreqCat[31][25] = 486184.2000;
      transCat[31][25] = "40  - 39 ";
      dfreqCat[31][26] = 498323.5286;
      transCat[31][26] = "41  - 40 ";
      dfreqCat[31][27] = 510457.3000;
      transCat[31][27] = "42  - 41 ";
      dfreqCat[31][28] = 522594.3763;
      transCat[31][28] = "43  - 42 ";
      dfreqCat[31][29] = 534727.8001;
      transCat[31][29] = "44  - 43 ";
      dfreqCat[31][30] = 546859.8488;
      transCat[31][30] = "45  - 44 ";
      dfreqCat[31][31] = 558990.4912;
      transCat[31][31] = "46  - 45 ";
      dfreqCat[31][32] = 571119.6958;
      transCat[31][32] = "47  - 46 ";
      dfreqCat[31][33] = 583247.4315;
      transCat[31][33] = "48  - 47 ";
      dfreqCat[31][34] = 595373.6669;
      transCat[31][34] = "49  - 48 ";
      dfreqCat[31][35] = 607498.3707;
      transCat[31][35] = "50  - 49 ";
      dfreqCat[31][36] = 619621.5116;
      transCat[31][36] = "51  - 50 ";
      dfreqCat[31][37] = 631743.0583;
      transCat[31][37] = "52  - 51 ";
      dfreqCat[31][38] = 643862.9795;
      transCat[31][38] = "53  - 52 ";
      dfreqCat[31][39] = 655981.2439;
      transCat[31][39] = "54  - 53 ";
      dfreqCat[31][40] = 668097.8201;
      transCat[31][40] = "55  - 54 ";
      dfreqCat[31][41] = 680212.6769;
      transCat[31][41] = "56  - 55 ";
      dfreqCat[31][42] = 692325.7829;
      transCat[31][42] = "57  - 56 ";
      dfreqCat[31][43] = 704437.0520;
      transCat[31][43] = "58  - 57 ";
      dfreqCat[31][44] = 716546.5590;
      transCat[31][44] = "59  - 58 ";
      dfreqCat[31][45] = 728654.2827;
      transCat[31][45] = "60  - 59 ";
      dfreqCat[31][46] = 740760.0722;
      transCat[31][46] = "61  - 60 ";
      dfreqCat[31][47] = 752863.9543;
      transCat[31][47] = "62  - 61 ";
      dfreqCat[31][48] = 764965.8975;
      transCat[31][48] = "63  - 62 ";
      dfreqCat[31][49] = 777065.8705;
      transCat[31][49] = "64  - 63 ";
      dfreqCat[31][50] = 789163.8420;
      transCat[31][50] = "65  - 64 ";
      dfreqCat[31][51] = 801259.7820;
      transCat[31][51] = "66  - 65 ";
      dfreqCat[31][52] = 813353.7060;
      transCat[31][52] = "67  - 66 ";
      dfreqCat[31][53] = 825445.4339;
      transCat[31][53] = "68  - 67 ";
      dfreqCat[31][54] = 837535.0857;
      transCat[31][54] = "69  - 68 ";
      dfreqCat[31][55] = 849622.5792;
      transCat[31][55] = "70  - 69 ";
      dfreqCat[31][56] = 861707.8830;
      transCat[31][56] = "71  - 70 ";
      dfreqCat[31][57] = 873790.9657;
      transCat[31][57] = "72  - 71 ";
      dfreqCat[31][58] = 885871.7958;
      transCat[31][58] = "73  - 72 ";
      dfreqCat[31][59] = 897950.3421;
      transCat[31][59] = "74  - 73 ";
      dfreqCat[31][60] = 910026.5732;
      transCat[31][60] = "75  - 74 ";
      specCat[31] = "OCS";
      nlines[31] = 61;
      dfreqCat[32][0] = 181525.1131;
      transCat[32][0] = "10  - 9 ";
      dfreqCat[32][1] = 199672.0843;
      transCat[32][1] = "11  - 10 ";
      dfreqCat[32][2] = 217817.4727;
      transCat[32][2] = "12  - 11 ";
      dfreqCat[32][3] = 235961.1344;
      transCat[32][3] = "13  - 12 ";
      dfreqCat[32][4] = 254102.9254;
      transCat[32][4] = "14  - 13 ";
      dfreqCat[32][5] = 272242.7018;
      transCat[32][5] = "15  - 14 ";
      dfreqCat[32][6] = 290380.3198;
      transCat[32][6] = "16  - 15 ";
      dfreqCat[32][7] = 308515.6354;
      transCat[32][7] = "17  - 16 ";
      dfreqCat[32][8] = 326648.5047;
      transCat[32][8] = "18  - 17 ";
      dfreqCat[32][9] = 344778.7840;
      transCat[32][9] = "19  - 18 ";
      dfreqCat[32][10] = 362906.3292;
      transCat[32][10] = "20  - 19 ";
      dfreqCat[32][11] = 381030.9964;
      transCat[32][11] = "21  - 20 ";
      dfreqCat[32][12] = 399152.6418;
      transCat[32][12] = "22  - 21 ";
      dfreqCat[32][13] = 417271.1215;
      transCat[32][13] = "23  - 22 ";
      dfreqCat[32][14] = 435386.2915;
      transCat[32][14] = "24  - 23 ";
      dfreqCat[32][15] = 453498.0080;
      transCat[32][15] = "25  - 24 ";
      dfreqCat[32][16] = 471606.1271;
      transCat[32][16] = "26  - 25 ";
      dfreqCat[32][17] = 489710.5049;
      transCat[32][17] = "27  - 26 ";
      dfreqCat[32][18] = 507810.9974;
      transCat[32][18] = "28  - 27 ";
      dfreqCat[32][19] = 525907.4609;
      transCat[32][19] = "29  - 28 ";
      dfreqCat[32][20] = 543999.7513;
      transCat[32][20] = "30  - 29 ";
      dfreqCat[32][21] = 562087.7248;
      transCat[32][21] = "31  - 30 ";
      dfreqCat[32][22] = 580171.2375;
      transCat[32][22] = "32  - 31 ";
      dfreqCat[32][23] = 598250.1455;
      transCat[32][23] = "33  - 32 ";
      dfreqCat[32][24] = 616324.3049;
      transCat[32][24] = "34  - 33 ";
      dfreqCat[32][25] = 634393.5718;
      transCat[32][25] = "35  - 34 ";
      dfreqCat[32][26] = 652457.8024;
      transCat[32][26] = "36  - 35 ";
      dfreqCat[32][27] = 670516.8526;
      transCat[32][27] = "37  - 36 ";
      dfreqCat[32][28] = 688570.5786;
      transCat[32][28] = "38  - 37 ";
      dfreqCat[32][29] = 706618.8366;
      transCat[32][29] = "39  - 38 ";
      dfreqCat[32][30] = 724661.4825;
      transCat[32][30] = "40  - 39 ";
      dfreqCat[32][31] = 742698.3726;
      transCat[32][31] = "41  - 40 ";
      dfreqCat[32][32] = 760729.3630;
      transCat[32][32] = "42  - 41 ";
      dfreqCat[32][33] = 778754.3096;
      transCat[32][33] = "43  - 42 ";
      dfreqCat[32][34] = 796773.0687;
      transCat[32][34] = "44  - 43 ";
      dfreqCat[32][35] = 814785.4963;
      transCat[32][35] = "45  - 44 ";
      dfreqCat[32][36] = 832791.4485;
      transCat[32][36] = "46  - 45 ";
      dfreqCat[32][37] = 850790.7815;
      transCat[32][37] = "47  - 46 ";
      dfreqCat[32][38] = 868783.3513;
      transCat[32][38] = "48  - 47 ";
      dfreqCat[32][39] = 886769.0141;
      transCat[32][39] = "49  - 48 ";
      dfreqCat[32][40] = 904747.6259;
      transCat[32][40] = "50  - 49 ";
      specCat[32] = "SiS";
      nlines[32] = 41;

      dfreqCat[33][0] = 625918.7560;
      transCat[33][0] = "1 3  - 0 2 ";
      specCat[33] = "HCl";
      nlines[33] = 1;

      dfreqCat[34][0] = 196885.2080;
      transCat[34][0] = "4 -1 5  - 3 1 4 ";
      dfreqCat[34][1] = 202472.8120;
      transCat[34][1] = "6 1 5  - 5 -1 4 ";
      dfreqCat[34][2] = 209320.7540;
      transCat[34][2] = "5 -1 5  - 4 1 4 ";
      dfreqCat[34][3] = 242968.9460;
      transCat[34][3] = "7 -1 6  - 6 1 5 ";
      dfreqCat[34][4] = 251130.4920;
      transCat[34][4] = "6 1 6  - 5 -1 5 ";
      dfreqCat[34][5] = 283465.3334;
      transCat[34][5] = "8 1 7  - 7 -1 6 ";
      dfreqCat[34][6] = 292911.6454;
      transCat[34][6] = "7 -1 7  - 6 1 6 ";
      dfreqCat[34][7] = 323961.5942;
      transCat[34][7] = "8 -1 8  - 8 1 7 ";
      dfreqCat[34][8] = 334660.3184;
      transCat[34][8] = "8 1 8  - 7 -1 7 ";
      dfreqCat[34][9] = 364457.1605;
      transCat[34][9] = "9 1 9  - 8 -1 8 ";
      dfreqCat[34][10] = 376372.9510;
      transCat[34][10] = "10 -1 9  - 8 1 8 ";
      dfreqCat[34][11] = 394042.2870;
      transCat[34][11] = "9 1 10  - 8 -1 9 ";
      dfreqCat[34][12] = 404951.3114;
      transCat[34][12] = "10 -1 10  - 9 1 9 ";
      dfreqCat[34][13] = 418046.3403;
      transCat[34][13] = "11 1 10  - 10 -1 9 ";
      dfreqCat[34][14] = 433523.3278;
      transCat[34][14] = "10 -1 11  - 9 1 10 ";
      dfreqCat[34][15] = 445443.1742;
      transCat[34][15] = "11 1 11  - 10 -1 10 ";
      dfreqCat[34][16] = 459677.6449;
      transCat[34][16] = "12 -1 11  - 11 1 10 ";
      dfreqCat[34][17] = 473022.8080;
      transCat[34][17] = "11 1 12  - 10 -1 11 ";
      dfreqCat[34][18] = 485931.7375;
      transCat[34][18] = "12 -1 12  - 11 1 11 ";
      dfreqCat[34][19] = 501264.3812;
      transCat[34][19] = "13 1 12  - 12 -1 11 ";
      dfreqCat[34][20] = 512541.0051;
      transCat[34][20] = "12 -1 13  - 11 1 12 ";
      dfreqCat[34][21] = 526415.8669;
      transCat[34][21] = "13 1 13  - 12 -1 12 ";
      dfreqCat[34][22] = 542804.4120;
      transCat[34][22] = "14 -1 13  - 13 1 12 ";
      dfreqCat[34][23] = 552077.9344;
      transCat[34][23] = "13 1 14  - 12 -1 13 ";
      dfreqCat[34][24] = 566894.3236;
      transCat[34][24] = "14 -1 14  - 13 1 13 ";
      dfreqCat[34][25] = 584295.9298;
      transCat[34][25] = "15 1 14  - 14 -1 13 ";
      dfreqCat[34][26] = 591633.3590;
      transCat[34][26] = "14 -1 15  - 13 1 14 ";
      dfreqCat[34][27] = 607365.7838;
      transCat[34][27] = "15 1 15  - 14 -1 14 ";
      dfreqCat[34][28] = 625737.4345;
      transCat[34][28] = "16 -1 15  - 15 1 14 ";
      dfreqCat[34][29] = 631206.8044;
      transCat[34][29] = "15 1 16  - 14 -1 15 ";
      dfreqCat[34][30] = 647828.8580;
      transCat[34][30] = "16 -1 16  - 15 1 15 ";
      dfreqCat[34][31] = 667127.7075;
      transCat[34][31] = "17 1 16  - 16 -1 15 ";
      dfreqCat[34][32] = 670797.5742;
      transCat[34][32] = "16 -1 17  - 15 1 16 ";
      dfreqCat[34][33] = 688282.1095;
      transCat[34][33] = "17 1 17  - 16 -1 16 ";
      dfreqCat[34][34] = 708465.7844;
      transCat[34][34] = "18 -1 17  - 17 1 16 ";
      dfreqCat[34][35] = 710404.7687;
      transCat[34][35] = "17 1 18  - 16 -1 17 ";
      dfreqCat[34][36] = 731214.4323;
      transCat[34][36] = "16 1 15  - 16 -1 16 ";
      dfreqCat[34][37] = 740866.5442;
      transCat[34][37] = "19 1 19  - 19 -1 20 ";
      dfreqCat[34][38] = 750027.3044;
      transCat[34][38] = "18 -1 19  - 17 1 18 ";
      dfreqCat[34][39] = 750171.9242;
      transCat[34][39] = "19 -1 18  - 18 1 17 ";
      dfreqCat[34][40] = 752900.8405;
      transCat[34][40] = "15 -1 14  - 15 1 15 ";
      dfreqCat[34][41] = 757210.4867;
      transCat[34][41] = "17 1 16  - 17 -1 17 ";
      dfreqCat[34][42] = 761387.6326;
      transCat[34][42] = "18 -1 18  - 18 1 19 ";
      dfreqCat[34][43] = 775575.4257;
      transCat[34][43] = "14 1 13  - 14 -1 14 ";
      dfreqCat[34][44] = 778747.7814;
      transCat[34][44] = "16 -1 15  - 16 1 16 ";
      dfreqCat[34][45] = 782699.4905;
      transCat[34][45] = "17 1 17  - 17 -1 18 ";
      dfreqCat[34][46] = 789663.9341;
      transCat[34][46] = "19 1 20  - 18 -1 19 ";
      dfreqCat[34][47] = 790982.5884;
      transCat[34][47] = "20 -1 19  - 19 1 18 ";
      dfreqCat[34][48] = 799282.2896;
      transCat[34][48] = "13 -1 12  - 13 1 13 ";
      dfreqCat[34][49] = 801218.0186;
      transCat[34][49] = "15 1 14  - 15 -1 15 ";
      dfreqCat[34][50] = 804829.1893;
      transCat[34][50] = "16 -1 16  - 16 1 17 ";
      dfreqCat[34][51] = 809568.2001;
      transCat[34][51] = "20 -1 20  - 19 1 19 ";
      dfreqCat[34][52] = 824065.5511;
      transCat[34][52] = "12 1 11  - 12 -1 12 ";
      dfreqCat[34][53] = 824660.6349;
      transCat[34][53] = "14 -1 13  - 14 1 14 ";
      dfreqCat[34][54] = 827803.5607;
      transCat[34][54] = "15 1 15  - 15 -1 16 ";
      dfreqCat[34][55] = 829313.2667;
      transCat[34][55] = "20 -1 21  - 19 1 20 ";
      dfreqCat[34][56] = 831421.1012;
      transCat[34][56] = "15 -1 15  - 15 1 16 ";
      dfreqCat[34][57] = 832160.3963;
      transCat[34][57] = "21 1 20  - 20 -1 19 ";
      dfreqCat[34][58] = 849115.1043;
      transCat[34][58] = "13 1 12  - 13 -1 13 ";
      dfreqCat[34][59] = 849967.4089;
      transCat[34][59] = "21 1 21  - 20 -1 20 ";
      dfreqCat[34][60] = 849968.9427;
      transCat[34][60] = "11 -1 10  - 11 1 11 ";
      dfreqCat[34][61] = 850350.6860;
      transCat[34][61] = "21 -1 21  - 20 1 20 ";
      dfreqCat[34][62] = 851649.0451;
      transCat[34][62] = "14 -1 14  - 14 1 15 ";
      dfreqCat[34][63] = 868973.7873;
      transCat[34][63] = "21 1 22  - 20 -1 21 ";
      dfreqCat[34][64] = 873284.1142;
      transCat[34][64] = "22 -1 21  - 21 1 20 ";
      dfreqCat[34][65] = 874620.6241;
      transCat[34][65] = "12 -1 11  - 12 1 12 ";
      dfreqCat[34][66] = 876391.5359;
      transCat[34][66] = "13 1 13  - 13 -1 14 ";
      dfreqCat[34][67] = 877035.3579;
      transCat[34][67] = "10 1 9  - 10 -1 10 ";
      dfreqCat[34][68] = 879263.8370;
      transCat[34][68] = "13 -1 13  - 13 1 14 ";
      dfreqCat[34][69] = 890349.4328;
      transCat[34][69] = "22 -1 22  - 21 1 21 ";
      dfreqCat[34][70] = 901215.7636;
      transCat[34][70] = "11 1 10  - 11 -1 11 ";
      dfreqCat[34][71] = 902056.2201;
      transCat[34][71] = "12 -1 12  - 12 1 13 ";
      dfreqCat[34][72] = 905306.3555;
      transCat[34][72] = "9 -1 8  - 9 1 9 ";
      dfreqCat[34][73] = 908643.8758;
      transCat[34][73] = "22 -1 23  - 21 1 22 ";
      dfreqCat[34][74] = 914353.6219;
      transCat[34][74] = "23 1 22  - 22 -1 21 ";
      specCat[34] = "SiC";
      nlines[34] = 75;

   }

    public static void main( String[] args )
    {
        LineCatalog lc = new LineCatalog(); // Initialisation

        String header = "#BEGIN\n" +
                        "# name  <name>_lines\n"+
                        "# system FREQ\n" +
                        "# unit MHz\n" +
                        "# StdOfRest Source\n" +
                        "# sourcevrf Topocentric\n" +
                        "# sourcevel 0.0\n" +
                        "#END\n";

        Pattern namePattern = Pattern.compile( "<name>" );
        Pattern twoSpace = Pattern.compile( "\\s\\s" );
        Pattern oneSpace = Pattern.compile( "\\s" );

        for ( int j = 0; j < nspec; j++ ) {
            System.out.println( "Species = " + specCat[j] );

            // Clean up name by replacing spaces with underscore.
            String cleanName =
                twoSpace.matcher( specCat[j] ).replaceAll( " " );
            cleanName = oneSpace.matcher( specCat[j] ).replaceAll( "_" );

            String localHeader =
                namePattern.matcher( header ).replaceAll( cleanName );

            try {
                FileOutputStream f = new FileOutputStream( cleanName+ ".ids" );
                BufferedWriter r =
                    new BufferedWriter( new OutputStreamWriter( f ) );
                r.write( localHeader ); // Need to change the name.

                for ( int i = 0; i < nlines[j]; i++ ) {

                    // Clean up the description.
                    String desc = transCat[j][i].trim();
                    desc = twoSpace.matcher( desc ).replaceAll( " " );
                    desc = oneSpace.matcher( desc ).replaceAll( "_" );

                    r.write( dfreqCat[j][i] + " " + desc + "\n" );
                }
                r.close();
                f.close();
            }
            catch ( Exception e ) {
                e.printStackTrace();
            }
        }
    }

//    public void returnLines ( double minFreq, double maxFreq,
//      int listSize, LineDetails lineRef[] )
//    {
//       int i;
//       int j;
//       int pix;
//       double invRange;

// /* Search for all lines between minFreq and maxFreq and record their
//    details in lineRef given a linear scaling between index numbers and
//    frequency. */

//       minFreq = minFreq * 1.0E-6;
//       maxFreq = maxFreq * 1.0E-6;
//       invRange = 1.0 / ( maxFreq - minFreq );

//       for ( j=0; j<nspec; j++ )
//       {
//          for ( i=0; i<nlines[j]; i++ )
//          {
//             if ( ( dfreqCat[j][i] > minFreq ) &&
//               ( dfreqCat[j][i] < maxFreq ) )
//             {
//                pix = (int) ( ((double)listSize) *
//                  ( dfreqCat[j][i] - minFreq ) * invRange );
//                lineRef[pix] = new LineDetails ( specCat[j],
//                  transCat[j][i], dfreqCat[j][i] );
//             }
//          }
//       }
//    }


//    public Vector returnSpecies ( double minFreq, double maxFreq  )
//    {
//       int i;
//       int j;
//       Vector v = new Vector();
//       SelectionList species;
//       Transition transition;

// /* Search for all lines between minFreq and maxFreq and record their
//    details. */

//       minFreq = minFreq * 1.0E-6;
//       maxFreq = maxFreq * 1.0E-6;

//       for ( j=0; j<nspec; j++ )
//       {
//          species = null;

//          for ( i=0; i<nlines[j]; i++ )
//          {
//             if ( ( dfreqCat[j][i] > minFreq ) &&
//               ( dfreqCat[j][i] < maxFreq ) )
//             {
//                if ( species == null )
//                {
//                   species = new SelectionList ( specCat[j] );
//                   v.add ( species );
//                }
//                species.objectList.add ( new Transition ( transCat[j][i],
//                  1.0E6 * dfreqCat[j][i] ) );
//             }
//          }
//       }

//       return v;
//    }

}
