/*
 * Decompiled with CFR 0.152.
 */
package jsky.app.jskycat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import jsky.app.jskycat.JSkyCatMenuBar;
import jsky.app.jskycat.JSkyCatRemoteControl;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.MainImageDisplay;
import jsky.navigator.NavigatorFrame;
import jsky.navigator.NavigatorImageDisplayFrame;
import jsky.navigator.NavigatorImageDisplayInternalFrame;
import jsky.navigator.NavigatorInternalFrame;
import jsky.util.I18N;
import jsky.util.Preferences;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.DesktopUtil;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ExampleFileFilter;
import jsky.util.gui.LookAndFeelMenu;
import jsky.util.gui.SwingUtil;

public class JSkyCat
extends JFrame {
    private static final I18N _I18N = I18N.getInstance(class$jsky$app$jskycat$JSkyCat == null ? (class$jsky$app$jskycat$JSkyCat = JSkyCat.class$("jsky.app.jskycat.JSkyCat")) : class$jsky$app$jskycat$JSkyCat);
    protected JFileChooser fileChooser;
    protected static JDesktopPane desktop;
    protected Component imageFrame;
    static /* synthetic */ Class class$jsky$app$jskycat$JSkyCat;

    public JSkyCat(String imageFileOrUrl, boolean internalFrames, boolean showNavigator, int portNum) {
        block4: {
            super("JSky");
            if (internalFrames || desktop != null) {
                this.makeInternalFrameLayout(showNavigator, imageFileOrUrl);
            } else {
                this.makeFrameLayout(showNavigator, imageFileOrUrl);
            }
            this.addWindowListener(new BasicWindowMonitor());
            if (portNum <= 0) break block4;
            try {
                new JSkyCatRemoteControl(portNum, this).start();
            }
            catch (IOException e) {
                DialogUtil.error(e);
            }
        }
    }

    public JSkyCat(String imageFileOrUrl, boolean internalFrames, boolean showNavigator) {
        this(imageFileOrUrl, internalFrames, showNavigator, 0);
    }

    public JSkyCat(String imageFileOrUrl) {
        this(imageFileOrUrl, false, false, 0);
    }

    public static JDesktopPane getDesktop() {
        return desktop;
    }

    public static void setDesktop(JDesktopPane dt) {
        desktop = dt;
    }

    protected void makeInternalFrameLayout(boolean showNavigator, String imageFileOrUrl) {
        boolean ownDesktop = false;
        if (desktop == null) {
            this.setJMenuBar(this.makeMenuBar());
            desktop = new JDesktopPane();
            desktop.setBorder(BorderFactory.createEtchedBorder());
            DialogUtil.setDesktop(desktop);
            ownDesktop = true;
            desktop.putClientProperty("JDesktopPane.dragMode", "outline");
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            int w = screen.width - 10;
            int h = screen.height - 10;
            Preferences.manageSize(desktop, new Dimension(w, h), this.getClass().getName() + ".size");
            Preferences.manageLocation(this, 0, 0);
            this.setDesktopBackground();
            this.setContentPane(desktop);
        }
        NavigatorInternalFrame navigatorFrame = null;
        NavigatorImageDisplayInternalFrame imageFrame = null;
        if (imageFileOrUrl != null || !showNavigator) {
            imageFrame = this.makeNavigatorImageDisplayInternalFrame(desktop, imageFileOrUrl);
            this.imageFrame = imageFrame;
            desktop.add((Component)imageFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(imageFrame);
            imageFrame.setVisible(true);
        }
        if (showNavigator) {
            if (imageFrame != null) {
                DivaMainImageDisplay imageDisplay = imageFrame.getImageDisplayControl().getImageDisplay();
                navigatorFrame = this.makeNavigatorInternalFrame(desktop, imageDisplay);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.min(screen.width - imageFrame.getWidth(), navigatorFrame.getWidth());
                imageFrame.setLocation(x, 0);
                imageFrame.setNavigator(navigatorFrame.getNavigator());
            } else {
                navigatorFrame = this.makeNavigatorInternalFrame(desktop, null);
            }
            desktop.add((Component)navigatorFrame, JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront(navigatorFrame);
            navigatorFrame.setLocation(0, 0);
            navigatorFrame.setVisible(true);
        }
        if (ownDesktop) {
            LookAndFeelMenu.addWindow(this);
            this.pack();
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    JSkyCat.this.exit();
                }
            });
            this.setVisible(true);
        }
        this.setTitle(this.getAppName() + " - version " + this.getAppVersion());
    }

    protected void makeFrameLayout(boolean showNavigator, String imageFileOrUrl) {
        NavigatorFrame navigatorFrame = null;
        NavigatorImageDisplayFrame imageFrame = null;
        if (imageFileOrUrl != null || !showNavigator) {
            imageFrame = this.makeNavigatorImageDisplayFrame(imageFileOrUrl);
            this.imageFrame = imageFrame;
        }
        if (showNavigator) {
            if (imageFrame != null) {
                DivaMainImageDisplay imageDisplay = imageFrame.getImageDisplayControl().getImageDisplay();
                navigatorFrame = this.makeNavigatorFrame(imageDisplay);
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = Math.min(screen.width - imageFrame.getWidth(), navigatorFrame.getWidth());
                imageFrame.setLocation(x, 0);
                imageFrame.setNavigator(navigatorFrame.getNavigator());
            } else {
                navigatorFrame = this.makeNavigatorFrame(null);
            }
            navigatorFrame.setLocation(0, 0);
            navigatorFrame.setVisible(true);
        }
    }

    protected JMenuBar makeMenuBar() {
        return new JSkyCatMenuBar(this);
    }

    protected NavigatorImageDisplayInternalFrame makeNavigatorImageDisplayInternalFrame(JDesktopPane desktop, String imageFileOrUrl) {
        NavigatorImageDisplayInternalFrame f = new NavigatorImageDisplayInternalFrame(desktop, imageFileOrUrl);
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getAppName());
        return f;
    }

    protected String getAppName() {
        return "JSkyCat";
    }

    protected String getAppVersion() {
        return "jsky-2.0".substring(5);
    }

    protected NavigatorImageDisplayFrame makeNavigatorImageDisplayFrame(String imageFileOrUrl) {
        NavigatorImageDisplayFrame f = new NavigatorImageDisplayFrame(imageFileOrUrl);
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getAppName() + " - version " + this.getAppVersion());
        f.setVisible(true);
        return f;
    }

    protected NavigatorInternalFrame makeNavigatorInternalFrame(JDesktopPane desktop, MainImageDisplay imageDisplay) {
        NavigatorInternalFrame f = new NavigatorInternalFrame(desktop, imageDisplay);
        f.setVisible(true);
        return f;
    }

    protected NavigatorFrame makeNavigatorFrame(MainImageDisplay imageDisplay) {
        return new NavigatorFrame(imageDisplay);
    }

    protected void setDesktopBackground() {
        new DesktopUtil(desktop, "stars.gif");
    }

    public JFileChooser makeFileChooser() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        ExampleFileFilter configFileFilter = new ExampleFileFilter(new String[]{"cfg"}, _I18N.getString("catalogConfigFilesSkycat"));
        fileChooser.addChoosableFileFilter(configFileFilter);
        ExampleFileFilter skycatLocalCatalogFilter = new ExampleFileFilter(new String[]{"table", "tbl", "cat"}, _I18N.getString("localCatalogFilesSkycat"));
        fileChooser.addChoosableFileFilter(skycatLocalCatalogFilter);
        ExampleFileFilter fitsFilter = new ExampleFileFilter(new String[]{"fit", "fits", "fts"}, _I18N.getString("fitsFileWithTableExt"));
        fileChooser.addChoosableFileFilter(fitsFilter);
        fileChooser.setFileFilter(fitsFilter);
        return fileChooser;
    }

    public void open() {
        int option;
        if (this.fileChooser == null) {
            this.fileChooser = this.makeFileChooser();
        }
        if ((option = this.fileChooser.showOpenDialog(this)) == 0 && this.fileChooser.getSelectedFile() != null) {
            this.open(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void open(String fileOrUrl) {
        if (desktop != null) {
            if (fileOrUrl.endsWith(".fits") || fileOrUrl.endsWith(".fts")) {
                NavigatorImageDisplayInternalFrame frame = new NavigatorImageDisplayInternalFrame(desktop);
                desktop.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
                desktop.moveToFront(frame);
                frame.setVisible(true);
                frame.getImageDisplayControl().getImageDisplay().setFilename(fileOrUrl);
            } else {
                NavigatorInternalFrame frame = new NavigatorInternalFrame(desktop);
                frame.getNavigator().open(fileOrUrl);
                desktop.add((Component)frame, JLayeredPane.DEFAULT_LAYER);
                desktop.moveToFront(frame);
                frame.setVisible(true);
            }
        }
    }

    public void exit() {
        System.exit(0);
    }

    public Component getImageFrame() {
        return this.imageFrame;
    }

    protected MainImageDisplay getImageDisplay() {
        if (this.imageFrame instanceof NavigatorImageDisplayFrame) {
            return ((NavigatorImageDisplayFrame)this.imageFrame).getImageDisplayControl().getImageDisplay();
        }
        if (this.imageFrame instanceof NavigatorImageDisplayInternalFrame) {
            return ((NavigatorImageDisplayInternalFrame)this.imageFrame).getImageDisplayControl().getImageDisplay();
        }
        return null;
    }

    public void setImageFrameVisible(boolean visible) {
        if (this.imageFrame != null) {
            this.imageFrame.setVisible(visible);
            if (visible) {
                SwingUtil.showFrame(this.imageFrame);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        String imageFileOrUrl = null;
        boolean internalFrames = File.separatorChar == '\\';
        boolean showNavigator = false;
        int portNum = 0;
        boolean ok = true;
        int tilecache = 64;
        int i = 0;
        while (i < args.length) {
            block9: {
                block10: {
                    String opt;
                    block13: {
                        block12: {
                            block11: {
                                if (args[i].charAt(0) != '-') break block10;
                                opt = args[i];
                                if (!opt.equals("-internalframes")) break block11;
                                internalFrames = true;
                                break block9;
                            }
                            if (!opt.equals("-nointernalframes")) break block12;
                            internalFrames = false;
                            break block9;
                        }
                        if (!opt.equals("-shownavigator")) break block13;
                        showNavigator = true;
                        break block9;
                    }
                    if (opt.equals("-port")) {
                        String arg = args[++i];
                        portNum = Integer.parseInt(arg);
                        break block9;
                    } else if (opt.equals("-tilecache")) {
                        try {
                            tilecache = Integer.parseInt(args[++i]);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Warning: bad value for -tilecache option: " + args[i]);
                        }
                        break block9;
                    } else {
                        System.out.println(_I18N.getString("unknownOption") + ": " + opt);
                        ok = false;
                        break;
                    }
                }
                if (imageFileOrUrl != null) {
                    System.out.println(_I18N.getString("specifyOneImageOrURL") + ": " + imageFileOrUrl);
                    ok = false;
                    break;
                }
                imageFileOrUrl = args[i];
            }
            ++i;
        }
        if (!ok) {
            System.out.println("Usage: java [-Djsky.catalog.skycat.config=$SKYCAT_CONFIG] JSkyCat [-[no]internalframes] [-shownavigator] [-port portNum] [imageFileOrUrl]");
            System.exit(1);
        }
        TileCache cache = JAI.getDefaultInstance().getTileCache();
        cache.setMemoryCapacity((long)(tilecache * 1024 * 1024));
        new JSkyCat(imageFileOrUrl, internalFrames, showNavigator, portNum);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

