/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import jsky.catalog.Catalog;

public class CatalogFactory {
    private static TreeSet _catalogSet = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Catalog)o1).getName().compareTo(((Catalog)o2).getName());
        }
    });
    private static List _catalogList = new ArrayList();

    public static void registerCatalog(Catalog catalog, boolean overwrite) {
        if (CatalogFactory.getCatalogByName(catalog.getName()) != null) {
            if (overwrite) {
                _catalogSet.remove(catalog);
                _catalogList.remove(catalog);
            } else {
                return;
            }
        }
        _catalogSet.add(catalog);
        _catalogList.add(catalog);
    }

    public static Catalog getCatalogByName(String catalogName) {
        Iterator it = _catalogSet.iterator();
        while (it.hasNext()) {
            Catalog catalog = (Catalog)it.next();
            String s = catalog.getName();
            if (s == null || !s.equals(catalogName)) continue;
            return catalog;
        }
        return null;
    }

    public static List getCatalogsByType(String type) {
        ArrayList<Catalog> l = new ArrayList<Catalog>();
        Iterator it = _catalogList.iterator();
        while (it.hasNext()) {
            Catalog catalog = (Catalog)it.next();
            String s = catalog.getType();
            if (s == null || !s.equals(type)) continue;
            l.add(catalog);
        }
        return l;
    }

    public static void unregisterCatalog(Catalog catalog) {
        if (_catalogSet.contains(catalog)) {
            _catalogSet.remove(catalog);
            _catalogList.remove(catalog);
        }
    }

    public static Iterator iterator() {
        return _catalogSet.iterator();
    }
}

