/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.PlotableCatalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.RowCoordinates;
import jsky.catalog.SearchCondition;
import jsky.catalog.TablePlotSymbol;
import jsky.catalog.TableQueryResult;
import jsky.coords.CoordinateRadius;
import jsky.coords.Coordinates;
import jsky.coords.WorldCoordinates;
import jsky.util.Saveable;
import jsky.util.SaveableAsHTML;
import jsky.util.StringTokenizerUtil;

public class MemoryCatalog
extends DefaultTableModel
implements TableQueryResult,
Saveable,
SaveableAsHTML {
    public static final String EQUINOX = "equinox";
    public static final String SYMBOL = "symbol";
    public static final String ID_COL = "id_col";
    public static final String RA_COL = "ra_col";
    public static final String DEC_COL = "dec_col";
    public static final String X_COL = "x_col";
    public static final String Y_COL = "y_col";
    private Catalog _catalog;
    private String _name;
    private String _id;
    private String _title;
    private String _description;
    private URL _docURL;
    private RowCoordinates _rowCoordinates;
    private FieldDesc[] _fields;
    private boolean _more = false;
    private boolean _readOnly = true;
    private Properties _properties = new Properties();
    private String _columnSeparator = "\t";
    private Vector _columnClasses;
    private String _filename;
    private QueryArgs _queryArgs;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public MemoryCatalog(FieldDesc[] fields, Vector dataVector) {
        this._fields = fields;
        this.dataVector = dataVector;
        if (this._fields == null) {
            throw new RuntimeException("No columns defined for MemoryCatalog");
        }
        this.columnIdentifiers = this.makeColumnIdentifiers(this._fields);
    }

    public MemoryCatalog(Catalog catalog, InputStream in, int maxRows) throws IOException {
        this._catalog = catalog;
        this._init(in, maxRows);
        if (this._catalog != null) {
            this.setId(catalog.getId());
            this.setTitle("Query Results from: " + this._catalog.getTitle());
        }
    }

    public MemoryCatalog(Catalog catalog, InputStream in) throws IOException {
        this(catalog, in, -1);
    }

    public MemoryCatalog(Catalog catalog, InputStream in, QueryArgs queryArgs) throws IOException {
        this(catalog, in, queryArgs.getMaxRows());
        this._queryArgs = queryArgs;
    }

    public MemoryCatalog(Catalog catalog, String filename) throws IOException {
        this(catalog, new FileInputStream(filename));
        this._filename = filename;
        String name = new File(filename).getName();
        this.setName(name);
        this.setId(name);
        this.setTitle(name);
    }

    public MemoryCatalog(String filename) throws IOException {
        this((Catalog)null, filename);
    }

    public MemoryCatalog(MemoryCatalog table, FieldDesc[] fields, Vector dataRows) {
        this(fields, dataRows);
        this.setName(table.getName());
        this.setId(table.getId());
        this.setTitle("Query Results from: " + table.getTitle());
        this._initColumnClasses();
    }

    protected MemoryCatalog() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public void setCatalog(Catalog cat) {
        this._catalog = cat;
    }

    public Catalog getCatalog() {
        return this._catalog;
    }

    protected void _init(InputStream in, int maxRows) throws IOException {
        Vector columnIdentifiers;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        String line = null;
        String prevLine = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("***")) {
                throw new RuntimeException(line.substring(3));
            }
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            if (line.charAt(0) == '-') {
                if (prevLine == null) {
                    throw new IOException("Can't parse tab table header");
                }
                this.setColumnIdentifiers(this._parseHeading(prevLine));
                this._initFields();
                break;
            }
            prevLine = line;
            this._parseProperty(line);
        }
        if ((columnIdentifiers = this.getColumnIdentifiers()) == null) {
            this.setColumnIdentifiers(new Vector());
            this.dataVector = new Vector();
            return;
        }
        int n = columnIdentifiers.size();
        this._columnClasses = new Vector(n, 1);
        int i = 0;
        while (i < n) {
            this._columnClasses.add(null);
            ++i;
        }
        this.dataVector = new Vector(1024, 256);
        int nrows = 1;
        while ((line = reader.readLine()) != null && !line.equals("[EOD]")) {
            this.dataVector.add(this._parseRow(line));
            if (maxRows <= 0 || nrows++ < maxRows) continue;
            break;
        }
    }

    protected void _parseProperty(String s) {
        int i = s.indexOf(58);
        if (i != -1) {
            String key = s.substring(0, i).trim();
            String value = s.substring(i + 1).trim();
            this._properties.setProperty(key, value);
        }
    }

    protected Vector _parseHeading(String s) {
        StringTokenizerUtil st = new StringTokenizerUtil(s, this._columnSeparator);
        Vector<String> v = new Vector<String>(st.countTokens(), 1);
        while (st.hasMoreTokens()) {
            v.add(st.nextToken().trim());
        }
        return v;
    }

    protected void _initFields() {
        int n = this.getColumnIdentifiers().size();
        FieldDesc[] fields = new FieldDescAdapter[n];
        int i = 0;
        while (i < n) {
            fields[i] = new FieldDescAdapter((String)this.getColumnIdentifiers().get(i));
            ++i;
        }
        RowCoordinates rowCoordinates = this.getRowCoordinates();
        if (rowCoordinates != null && rowCoordinates.isWCS()) {
            int decCol;
            int raCol = rowCoordinates.getRaCol();
            if (raCol >= 0 && raCol < n) {
                ((FieldDescAdapter)fields[raCol]).setIsRA(true);
            }
            if ((decCol = rowCoordinates.getDecCol()) >= 0 && decCol < n) {
                ((FieldDescAdapter)fields[decCol]).setIsDec(true);
            }
        }
        this.setFields(fields);
    }

    protected Vector _parseRow(String lineStr) {
        StringTokenizerUtil st = new StringTokenizerUtil(lineStr, this._columnSeparator);
        int numCols = this.getColumnIdentifiers().size();
        int i = 0;
        Vector<Object> row = new Vector<Object>(numCols, 1);
        while (st.hasMoreTokens()) {
            if (i++ >= numCols) break;
            String s = st.nextToken().trim();
            if (s.length() != 0) {
                Object o = this._parseItem(s);
                this._checkColumnClass(i - 1, o);
                row.add(o);
                continue;
            }
            row.add(null);
        }
        while (i++ < numCols) {
            row.add(null);
        }
        return row;
    }

    protected Object _parseItem(String s) {
        try {
            return new Double(s);
        }
        catch (NumberFormatException e) {
            return s;
        }
    }

    protected void _checkColumnClass(int col, Object o) {
        Class t = (Class)this._columnClasses.get(col);
        Class<?> c = o.getClass();
        if (t == null) {
            this._columnClasses.set(col, c);
        } else if (!c.equals(t)) {
            this._columnClasses.set(col, class$java$lang$Object == null ? (class$java$lang$Object = MemoryCatalog.class$("java.lang.Object")) : class$java$lang$Object);
        }
    }

    public Vector getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    protected Vector makeColumnIdentifiers(FieldDesc[] fields) {
        Vector<String> v = new Vector<String>(fields.length, 1);
        int i = 0;
        while (i < fields.length) {
            String label = fields[i].getName();
            if (label == null) {
                label = "";
            }
            v.add(label);
            ++i;
        }
        return v;
    }

    public String getName() {
        if (this._name != null) {
            return this._name;
        }
        if (this._id != null) {
            return this._id;
        }
        if (this._filename != null) {
            return new File(this._filename).getName();
        }
        return "unknown";
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public URL getDocURL() {
        return this._docURL;
    }

    public void setDocURL(URL docURL) {
        this._docURL = docURL;
    }

    public int getNumParams() {
        return this._fields.length;
    }

    public FieldDesc getParamDesc(int i) {
        return this._fields[i];
    }

    public FieldDesc getParamDesc(String name) {
        int i = 0;
        while (i < this._fields.length) {
            if (this._fields[i] != null && this._fields[i].getName().equals(name)) {
                return this._fields[i];
            }
            ++i;
        }
        return null;
    }

    public int getNumColumns() {
        return this._fields.length;
    }

    public FieldDesc getColumnDesc(int i) {
        return this._fields[i];
    }

    public void setRegionArgs(QueryArgs queryArgs, CoordinateRadius region) {
    }

    public boolean isLocal() {
        return true;
    }

    public boolean isImageServer() {
        return false;
    }

    public String getType() {
        return "local";
    }

    public void setParent(CatalogDirectory catDir) {
    }

    public CatalogDirectory getParent() {
        return null;
    }

    public Catalog[] getPath() {
        return null;
    }

    public QueryResult query(QueryArgs queryArgs) throws IOException {
        int maxRows = queryArgs.getMaxRows();
        String objectId = queryArgs.getId();
        Vector<Vector> dataRows = new Vector<Vector>(Math.min(maxRows, 1024), Math.min(maxRows, 256));
        CoordinateRadius region = queryArgs.getRegion();
        SearchCondition[] conditions = queryArgs.getConditions();
        int[] searchCols = null;
        if (conditions != null) {
            searchCols = new int[conditions.length];
            int i = 0;
            while (i < conditions.length) {
                searchCols[i] = this.getColumnIndex(conditions[i].getName());
                ++i;
            }
        }
        int n = 0;
        int numRows = this.dataVector.size();
        int i = 0;
        while (i < numRows) {
            Vector row = (Vector)this.dataVector.get(i);
            if (this.compareRow(row, objectId, region, conditions, searchCols)) {
                dataRows.add(row);
                if (maxRows != 0 && ++n >= maxRows + 1) break;
            }
            ++i;
        }
        MemoryCatalog result = this.makeQueryResult(this._fields, dataRows);
        result.setName(this._name);
        result.setTitle(this._title);
        result.setDescription(this._description);
        result.setDocURL(this._docURL);
        result.setRowCoordinates(this._rowCoordinates);
        if (maxRows != 0 && n > maxRows) {
            result.setMore(true);
            result.setNumRows(maxRows);
        } else {
            result.setMore(false);
        }
        return result;
    }

    protected MemoryCatalog makeQueryResult(FieldDesc[] fields, Vector dataRows) {
        MemoryCatalog table = new MemoryCatalog(this, fields, dataRows);
        table.setProperties(this.getProperties());
        return table;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getName();
    }

    protected boolean compareRow(Vector row, String objectId, CoordinateRadius region, SearchCondition[] conditions, int[] searchCols) {
        if (this._rowCoordinates != null) {
            Comparable tableValue;
            Coordinates pos;
            if (!(region == null || (pos = this._rowCoordinates.getCoordinates(row)) != null && region.contains(pos))) {
                return false;
            }
            int idCol = this._rowCoordinates.getIdCol();
            if (!(objectId == null || idCol < 0 || (tableValue = (Comparable)row.get(idCol)) != null && tableValue.equals(objectId))) {
                return false;
            }
        }
        if (conditions == null) {
            return true;
        }
        int n = conditions.length;
        if (n > 0) {
            int i = 0;
            while (i < n) {
                Comparable tableValue = (Comparable)row.get(searchCols[i]);
                if (tableValue == null || !conditions[i].isTrueFor(tableValue)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isMore() {
        return this._more;
    }

    public void setMore(boolean more) {
        this._more = more;
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.columnIdentifiers = columnIdentifiers;
    }

    public void addRow(Vector row) {
        this.dataVector.add(row);
    }

    public boolean hasCol(String name) {
        return this.getColumnIndex(name) >= 0;
    }

    public Object getValueAt(int row, String name) {
        return this.getValueAt(row, this.getColumnIndex(name));
    }

    public int getColumnIndex(String name) {
        int numCols = this.columnIdentifiers.size();
        int i = 0;
        while (i < numCols) {
            if (name.equalsIgnoreCase((String)this.columnIdentifiers.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getColumnName(int index) {
        return (String)this.columnIdentifiers.get(index);
    }

    public Class getColumnClass(int columnIndex) {
        Object o = this._columnClasses.get(columnIndex);
        if (o != null && o instanceof Class) {
            return (Class)o;
        }
        return class$java$lang$String == null ? (class$java$lang$String = MemoryCatalog.class$("java.lang.String")) : class$java$lang$String;
    }

    public Vector getColumnClasses() {
        return this._columnClasses;
    }

    public void setColumnClasses(Vector v) {
        this._columnClasses = v;
    }

    public FieldDesc[] getFields() {
        return this._fields;
    }

    public void setFields(FieldDesc[] fields) {
        this._fields = fields;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return !this._readOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean b) {
        this._readOnly = b;
    }

    public void sort(String[] sortCols, String sortOrder) {
    }

    public boolean hasCoordinates() {
        return this._rowCoordinates != null;
    }

    public Coordinates getCoordinates(int rowIndex) {
        if (this._rowCoordinates != null) {
            Vector row = (Vector)this.dataVector.get(rowIndex);
            return this._rowCoordinates.getCoordinates(row);
        }
        return null;
    }

    public void print() {
        System.out.println("table: " + this.getTitle());
        int numCols = this.getColumnCount();
        int numRows = this.getRowCount();
        int i = 0;
        while (i < numCols) {
            System.out.println("col(" + i + ") = " + this.getColumnName(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < numRows) {
            int j = 0;
            while (j < numCols) {
                System.out.println("table(" + i2 + "," + j + ") = " + this.getValueAt(i2, j));
                ++j;
            }
            ++i2;
        }
    }

    public void saveAs(String filename) throws IOException {
        this.saveAs(new FileOutputStream(filename));
    }

    public void saveAs(OutputStream os) {
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        int n = numCols - 1;
        if (numCols == 0) {
            return;
        }
        PrintStream out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        String newline = System.getProperty("line.separator");
        this._saveHeader(out);
        int col = 0;
        while (col < numCols) {
            out.print(this.getColumnIdentifiers().get(col));
            if (col < n) {
                out.print(this._columnSeparator);
            }
            ++col;
        }
        out.print(newline);
        int col2 = 0;
        while (col2 < numCols) {
            int l = ((String)this.getColumnIdentifiers().get(col2)).length();
            int i = 0;
            while (i < l) {
                out.print("-");
                ++i;
            }
            if (col2 < n) {
                out.print(this._columnSeparator);
            }
            ++col2;
        }
        out.print(newline);
        int row = 0;
        while (row < numRows) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            int col3 = 0;
            while (col3 < numCols) {
                out.print(rowVec.get(col3));
                if (col3 < n) {
                    out.print(this._columnSeparator);
                }
                ++col3;
            }
            out.print(newline);
            ++row;
        }
    }

    protected void _saveHeader(PrintStream out) {
        TablePlotSymbol[] symbols;
        String symbolInfo;
        Catalog cat;
        out.println("Table");
        out.println("");
        RowCoordinates rowCoordinates = this.getRowCoordinates();
        if (rowCoordinates != null) {
            int decCol;
            int raCol;
            int idCol = rowCoordinates.getIdCol();
            if (idCol != 0) {
                this.setProperty(ID_COL, String.valueOf(idCol));
            }
            if ((raCol = rowCoordinates.getRaCol()) != 1) {
                this.setProperty(RA_COL, String.valueOf(raCol));
            }
            if ((decCol = rowCoordinates.getDecCol()) != 2) {
                this.setProperty(DEC_COL, String.valueOf(decCol));
            }
        }
        if ((cat = this.getCatalog()) instanceof PlotableCatalog && (symbolInfo = TablePlotSymbol.getPlotSymbolInfo(symbols = ((PlotableCatalog)cat).getSymbols())) != null) {
            this.setProperty(SYMBOL, symbolInfo);
        }
        if (this._properties.size() > 0) {
            this._saveProperties(out);
        }
    }

    protected void _saveProperties(PrintStream out) {
        out.println("# Begin properties");
        Enumeration<?> e = this._properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            out.println(key + ": " + this._properties.getProperty(key));
        }
        out.println("# End properties");
        out.println("");
    }

    public void saveAsHTML(String filename) throws IOException {
        FileOutputStream os = new FileOutputStream(filename);
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        int n = numCols - 1;
        if (numCols == 0) {
            return;
        }
        PrintStream out = new PrintStream(os);
        out.println("<html>");
        out.println("<body>");
        out.println("<table BORDER COLS=" + numCols + " WIDTH=\"100%\" NOSAVE>");
        out.println("<caption>" + this.getTitle() + "</caption>");
        out.println("<tr>");
        int col = 0;
        while (col < numCols) {
            out.println("<th>" + this.getColumnIdentifiers().get(col) + "</th>");
            ++col;
        }
        out.println("</tr>");
        int row = 0;
        while (row < numRows) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            out.println("<tr>");
            int col2 = 0;
            while (col2 < numCols) {
                out.println("<td>" + rowVec.get(col2) + "</td>");
                ++col2;
            }
            out.println("</tr>");
            ++row;
        }
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
    }

    public QueryArgs getQueryArgs() {
        return this._queryArgs;
    }

    public void setQueryArgs(QueryArgs queryArgs) {
        this._queryArgs = queryArgs;
    }

    public RowCoordinates getRowCoordinates() {
        PlotableCatalog cat;
        if (this._rowCoordinates != null) {
            return this._rowCoordinates;
        }
        if (this._catalog instanceof PlotableCatalog && (cat = (PlotableCatalog)this._catalog).getNumSymbols() != 0) {
            TablePlotSymbol plotSym = cat.getSymbolDesc(0);
            this._rowCoordinates = plotSym.getRowCoordinates();
        }
        return this._rowCoordinates;
    }

    public void setRowCoordinates(RowCoordinates rowCoordinates) {
        this._rowCoordinates = rowCoordinates;
    }

    public WorldCoordinates getWCSCenter() {
        Vector<Vector> dataVec;
        Vector rowVec;
        Coordinates pos;
        RowCoordinates rowCoordinates;
        Coordinates pos2;
        if (this._queryArgs != null && this._queryArgs.getRegion() != null && (pos2 = this._queryArgs.getRegion().getCenterPosition()) instanceof WorldCoordinates) {
            return (WorldCoordinates)pos2;
        }
        int nrows = this.getRowCount();
        if (nrows != 0 && (rowCoordinates = this.getRowCoordinates()) != null && rowCoordinates.isWCS() && (pos = rowCoordinates.getCoordinates(rowVec = (dataVec = this.getDataVector()).get(0))) instanceof WorldCoordinates) {
            return (WorldCoordinates)pos;
        }
        return null;
    }

    protected void _initColumnClasses() {
        int numCols = this.getColumnIdentifiers().size();
        int numRows = this.dataVector.size();
        this._columnClasses = new Vector(numCols, 1);
        int col = 0;
        while (col < numCols) {
            this._columnClasses.add(null);
            ++col;
        }
        int row = 0;
        while (row < numRows) {
            Vector rowVec = (Vector)this.dataVector.get(row);
            int n = rowVec.size();
            int col2 = 0;
            while (col2 < n) {
                Object o = rowVec.get(col2);
                if (o != null) {
                    this._checkColumnClass(col2, o);
                }
                ++col2;
            }
            ++row;
        }
    }

    public Properties getProperties() {
        return this._properties;
    }

    public void setProperties(Properties p) {
        this._properties = p;
    }

    public String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this._properties.setProperty(key, value);
    }

    public static void main(String[] args) {
        int numRows = 6;
        int numCols = 4;
        FieldDesc[] columns = new FieldDescAdapter[numCols];
        int i = 0;
        while (i < numCols) {
            columns[i] = new FieldDescAdapter("Col-" + i);
            ++i;
        }
        Vector rows = new Vector(numRows, 1);
        int i2 = 0;
        while (i2 < numRows) {
            Vector<String> cols = new Vector<String>(numCols, 1);
            int j = 0;
            while (j < numCols) {
                cols.add("item-" + i2 + "," + j);
                ++j;
            }
            rows.add(cols);
            ++i2;
        }
        MemoryCatalog cat = new MemoryCatalog(columns, rows);
        cat.setName("test cat");
        System.out.println("test row,col access:");
        int i3 = 0;
        while (i3 < numCols) {
            System.out.println("col(" + i3 + ") = " + cat.getColumnName(i3));
            ++i3;
        }
        int i4 = 0;
        while (i4 < numRows) {
            int j = 0;
            while (j < numCols) {
                System.out.println("table(" + i4 + "," + j + ") = " + cat.getValueAt(i4, j));
                ++j;
            }
            ++i4;
        }
        try {
            System.out.println("test query:");
            BasicQueryArgs queryArgs = new BasicQueryArgs(cat);
            queryArgs.setParamValue("Col-2", (Object)"item-2,2");
            TableQueryResult result = (TableQueryResult)cat.query(queryArgs);
            System.out.println("result rows: " + result.getRowCount());
            int i5 = 0;
            while (i5 < result.getColumnCount()) {
                System.out.println("col(" + i5 + ") = " + result.getColumnName(i5));
                ++i5;
            }
            int i6 = 0;
            while (i6 < result.getRowCount()) {
                int j = 0;
                while (j < result.getColumnCount()) {
                    System.out.println("table(" + i6 + "," + j + ") = " + result.getValueAt(i6, j));
                    ++j;
                }
                ++i6;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

