/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog;

import java.io.Serializable;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.util.StringUtil;

public class SearchCondition
implements Serializable {
    private FieldDesc _fieldDesc;
    private Comparable _minVal;
    private Comparable _maxVal;
    private boolean _minInclusive = true;
    private boolean _maxInclusive = true;

    public SearchCondition(FieldDesc fieldDesc, Comparable minVal, Comparable maxVal) {
        this._fieldDesc = fieldDesc;
        this._minVal = minVal;
        this._maxVal = maxVal;
    }

    public SearchCondition(FieldDesc fieldDesc, Comparable minVal, boolean minInclusive, Comparable maxVal, boolean maxInclusive) {
        this._fieldDesc = fieldDesc;
        this._minVal = minVal;
        this._minInclusive = minInclusive;
        this._maxVal = maxVal;
        this._maxInclusive = maxInclusive;
    }

    public SearchCondition(FieldDesc fieldDesc, Comparable val) {
        this._fieldDesc = fieldDesc;
        this._minVal = this._maxVal = val;
    }

    public SearchCondition(FieldDesc fieldDesc, double minVal, double maxVal) {
        this(fieldDesc, new Double(minVal), new Double(maxVal));
    }

    public SearchCondition(FieldDesc fieldDesc, double val) {
        this(fieldDesc, val, val);
    }

    public SearchCondition(FieldDesc fieldDesc, String minVal, String maxVal) {
        this(fieldDesc, (Comparable)((Object)minVal.trim()), (Comparable)((Object)maxVal.trim()));
    }

    public SearchCondition(FieldDesc fieldDesc, String val) {
        this(fieldDesc, (Comparable)((Object)val.trim()), (Comparable)((Object)val.trim()));
    }

    public Comparable getVal() {
        return this._minVal;
    }

    public Comparable getMinVal() {
        return this._minVal;
    }

    public Comparable getMaxVal() {
        return this._maxVal;
    }

    public boolean isMinInclusive() {
        return this._minInclusive;
    }

    public boolean isMaxInclusive() {
        return this._maxInclusive;
    }

    public boolean isTrueFor(Comparable val) {
        if (this._minVal == this._maxVal) {
            if (this._minVal instanceof String && val instanceof String) {
                return StringUtil.match((String)((Object)this._minVal), (String)((Object)val));
            }
            return this._minVal.compareTo(val) == 0;
        }
        if (this._minInclusive && this._maxInclusive) {
            return this._minVal.compareTo(val) <= 0 && this._maxVal.compareTo(val) >= 0;
        }
        if (this._minInclusive && !this._maxInclusive) {
            return this._minVal.compareTo(val) <= 0 && this._maxVal.compareTo(val) > 0;
        }
        if (!this._minInclusive && this._maxInclusive) {
            return this._minVal.compareTo(val) < 0 && this._maxVal.compareTo(val) >= 0;
        }
        return this._minVal.compareTo(val) < 0 && this._maxVal.compareTo(val) > 0;
    }

    public boolean isTrueFor(double val) {
        return this.isTrueFor(new Double(val));
    }

    public FieldDesc getFieldDesc() {
        return this._fieldDesc;
    }

    public String getName() {
        return this._fieldDesc.getName();
    }

    public String getId() {
        return this._fieldDesc.getId();
    }

    public boolean isRange() {
        return this._minVal != this._maxVal;
    }

    public String toString() {
        String name = this._fieldDesc.getName();
        if (this._minVal == this._maxVal) {
            return name + "=" + this._minVal;
        }
        return name + "=" + this._minVal + "," + this._maxVal;
    }

    public static void main(String[] args) {
        SearchCondition s = new SearchCondition((FieldDesc)new FieldDescAdapter("X"), 0.0, 1.0);
        if (!s.isTrueFor(0.5)) {
            throw new RuntimeException("test failed for 0.5: " + s);
        }
        if (s.isTrueFor(1.5)) {
            throw new RuntimeException("test failed for 1.5: " + s);
        }
        s = new SearchCondition((FieldDesc)new FieldDescAdapter("S"), "aaa", "kkk");
        if (!s.isTrueFor((Comparable)((Object)"bbb"))) {
            throw new RuntimeException("test failed for \"bbb\": " + s);
        }
        if (s.isTrueFor((Comparable)((Object)"mmm"))) {
            throw new RuntimeException("test failed for \"mmm\": " + s);
        }
        System.out.println("All tests passed");
    }
}

