/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.astrocat;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import jsky.catalog.AbstractCatalogDirectory;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.CatalogFactory;
import jsky.catalog.FieldDesc;
import jsky.catalog.FieldDescAdapter;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.astrocat.AstroCatXML;
import jsky.catalog.astrocat.AstroCatalog;
import jsky.catalog.skycat.SkycatConfigFile;
import jsky.util.FileUtil;
import jsky.util.Resources;
import jsky.util.StringUtil;
import jsky.util.gui.DialogUtil;

public class AstroCatConfig
extends AbstractCatalogDirectory {
    private static AstroCatConfig _configFile;
    private static URL _defaultURL;

    public AstroCatConfig(String name, URL url) {
        super(name);
        this.setURL(url);
        this._load();
    }

    public AstroCatConfig(String name, String configFileOrURL) {
        this(name, FileUtil.makeURL(null, configFileOrURL));
    }

    public AstroCatConfig(String configFileOrURL) {
        this(configFileOrURL, FileUtil.makeURL(null, configFileOrURL));
    }

    public AstroCatConfig(URL url, HTMLQueryResultHandler handler) {
        super(new File(url.toString()).getPath());
        this.setURL(url);
        this.setHTMLQueryResultHandler(handler);
        this._load();
    }

    private void _load() {
        URL url = this.getURL();
        if (url == null) {
            return;
        }
        AstroCatXML astroCatXML = new AstroCatXML();
        astroCatXML.parse(url);
        this.setCatalogs(astroCatXML.getCatalogs());
    }

    public static CatalogDirectory getDirectory() {
        return AstroCatConfig.getConfigFile();
    }

    public static AstroCatConfig getConfigFile() {
        if (_configFile != null) {
            return _configFile;
        }
        String[] urls = new String[4];
        int index = 0;
        String urlStr = System.getProperty("jsky.catalog.astrocat.config");
        if (urlStr != null && urlStr.length() != 0) {
            urls[index++] = urlStr;
        }
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        String filename = home + sep + ".jsky" + sep + "AstroCat.xml";
        if (new File(filename).exists()) {
            urlStr = "file:" + filename;
            if (!sep.equals("/")) {
                urlStr = StringUtil.replace(urlStr, sep, "/");
            }
            urls[index++] = urlStr;
        }
        if (_defaultURL == null) {
            _defaultURL = Resources.getResource("conf/AstroCat.xml");
        }
        if (_defaultURL == null) {
            throw new RuntimeException("Can't find the default catalog config file resource (AstroCat.xml).");
        }
        urls[index++] = _defaultURL.toString();
        _configFile = new AstroCatConfig(urls[0]);
        int i = 1;
        while (i < index) {
            if (urls[i] != null) {
                _configFile.addCatalogDirectory(urls[i]);
            }
            ++i;
        }
        return _configFile;
    }

    public CatalogDirectory reload() {
        _configFile = null;
        AstroCatConfig.getConfigFile();
        return _configFile;
    }

    public CatalogDirectory loadSubDir(URL url) {
        String filename = url.getFile();
        if (filename.endsWith(".xml")) {
            AstroCatConfig cf = new AstroCatConfig(url, this.getHTMLQueryResultHandler());
            return cf;
        }
        if (filename.endsWith(".cfg")) {
            SkycatConfigFile cf = new SkycatConfigFile(url, this.getHTMLQueryResultHandler());
            return cf;
        }
        throw new RuntimeException("Expected an AstroCat XML file, or a Skycat style .cfg file");
    }

    public static void setConfigFile(URL url) {
        _defaultURL = url;
    }

    public void addCatalogDirectory(String urlStr) {
        if (this.getCatalog(urlStr) != null) {
            return;
        }
        try {
            URL url = new URL(urlStr);
            AstroCatConfig cat = new AstroCatConfig(urlStr, url);
            this.addCatalog(cat);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public List getNameServers() {
        List l = super.getNameServers();
        if (l.size() != 0) {
            return l;
        }
        this._addDefaultNameServers();
        return CatalogFactory.getCatalogsByType("namesvr");
    }

    private void _addDefaultNameServers() {
        AstroCatalog cat = new AstroCatalog();
        cat.setId("simbad_ns@eso");
        cat.setName("SIMBAD Names");
        cat.setType("namesvr");
        cat.setHost("archive.eso.org");
        cat.setURLPath("/skycat/servers/sim-server");
        FieldDesc[] params = new FieldDescAdapter[]{new FieldDescAdapter()};
        FieldDesc param = params[0];
        ((FieldDescAdapter)param).setName("Object Name");
        ((FieldDescAdapter)param).setId("o");
        ((FieldDescAdapter)param).setDescription("Enter the name of the object (star, galaxy)");
        cat.setParams(params);
        CatalogFactory.registerCatalog(cat, false);
        cat = new AstroCatalog();
        cat.setId("ned@eso");
        cat.setName("NED Names");
        cat.setType("namesvr");
        cat.setHost("archive.eso.org");
        cat.setURLPath("/skycat/servers/ned-server");
        params = new FieldDescAdapter[]{new FieldDescAdapter()};
        param = params[0];
        ((FieldDescAdapter)param).setName("Object Name");
        ((FieldDescAdapter)param).setId("o");
        ((FieldDescAdapter)param).setDescription("Enter the name of the object (star, galaxy)");
        cat.setParams(params);
        CatalogFactory.registerCatalog(cat, false);
    }

    public void save() {
        String home = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        String fileName = home + sep + ".jsky" + sep + "AstroCat.xml";
        try {
            this.save(fileName);
        }
        catch (Exception e) {
            DialogUtil.error(e);
        }
    }

    public void save(String filename) {
        File file = new File(filename + ".tmp");
        File dir = file.getParentFile();
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        try {
            AstroCatXML.save(file, this.getCatalogs());
        }
        catch (Exception e) {
            file.delete();
            throw new RuntimeException(e);
        }
        File newFile = new File(filename);
        newFile.delete();
        if (!file.renameTo(newFile)) {
            DialogUtil.error("Rename " + file + " to " + filename + " failed");
        }
    }

    public static void main(String[] args) {
        String catalogName;
        AstroCatConfig configFile = AstroCatConfig.getConfigFile();
        Catalog cat = configFile.getCatalog(catalogName = "Guide Star Catalog at ESO");
        if (cat == null) {
            System.out.println("Can't find entry for catalog: " + catalogName);
            System.exit(1);
        } else {
            System.out.println("Test passed");
        }
    }

    static {
        _defaultURL = null;
    }
}

