/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.catalog.HTMLQueryResultHandler;
import jsky.catalog.QueryResult;
import jsky.catalog.QueryResultHandler;
import jsky.catalog.URLQueryResult;
import jsky.catalog.astrocat.AstroCatConfig;
import jsky.catalog.gui.CatalogTreeCellRenderer;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.I18N;
import jsky.util.SwingWorker;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.ClipboardHelper;
import jsky.util.gui.DialogUtil;
import jsky.util.gui.ProgressPanel;

public class CatalogTree
extends JPanel
implements QueryResultDisplay,
QueryResultHandler {
    private static final I18N _I18N = I18N.getInstance(class$jsky$catalog$gui$CatalogTree == null ? (class$jsky$catalog$gui$CatalogTree = CatalogTree.class$("jsky.catalog.gui.CatalogTree")) : class$jsky$catalog$gui$CatalogTree);
    private JTree _tree;
    private boolean _ignoreSelection = false;
    private HTMLQueryResultHandler _htmlQueryResultHandler;
    private QueryResultDisplay _queryResultDisplay;
    private QueryResult _queryResult;
    private CatalogDirectory _rootCatDir;
    private Hashtable _treeNodeTable = new Hashtable(10);
    private CatalogLoader _loader;
    private ProgressPanel _progressPanel;
    private JPopupMenu _nodeMenu;
    private AbstractAction _cutAction = new AbstractAction(_I18N.getString("cut")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.cut();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _copyAction = new AbstractAction(_I18N.getString("copy")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.copy();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _pasteAction = new AbstractAction(_I18N.getString("paste")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.paste();
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _moveUpAction = new AbstractAction(_I18N.getString("moveUp")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.moveNode(true);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _moveDownAction = new AbstractAction(_I18N.getString("moveDown")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.moveNode(false);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _toTopAction = new AbstractAction(_I18N.getString("toTop")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.moveNodeToEnd(true);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    private AbstractAction _toBottomAction = new AbstractAction(_I18N.getString("toBottom")){

        public void actionPerformed(ActionEvent evt) {
            try {
                CatalogTree.this.moveNodeToEnd(false);
            }
            catch (Exception e) {
                DialogUtil.error(e);
            }
        }
    };
    static /* synthetic */ Class class$jsky$catalog$gui$CatalogTree;

    public CatalogTree(CatalogDirectory catDir) {
        this.setMinimumSize(new Dimension(250, 250));
        this._rootCatDir = catDir;
        this._tree = new JTree(this._rootCatDir);
        this._tree.setShowsRootHandles(true);
        this._tree.setBackground(this.getBackground());
        this._nodeMenu = this.makeNodeMenu();
        this._tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CatalogTree.this._nodeMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    CatalogTree.this._nodeMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this._cutAction.setEnabled(false);
        this._copyAction.setEnabled(false);
        this._pasteAction.setEnabled(false);
        this._toTopAction.setEnabled(false);
        this._moveUpAction.setEnabled(false);
        this._moveDownAction.setEnabled(false);
        this._toBottomAction.setEnabled(false);
        this._tree.setCellRenderer(this._getTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                try {
                    CatalogTree.this._nodeSelected();
                    CatalogTree.this.updateEnabledStates();
                }
                catch (Exception ex) {
                    DialogUtil.error(ex);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this._tree);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 0));
        panel.add(scrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    public void setHTMLQueryResultHandler(HTMLQueryResultHandler handler) {
        this._htmlQueryResultHandler = handler;
    }

    private TreeCellRenderer _getTreeCellRenderer() {
        return new CatalogTreeCellRenderer();
    }

    public void setQueryResultDisplay(QueryResultDisplay q) {
        this._queryResultDisplay = q;
    }

    public QueryResultDisplay getQueryResultDisplay() {
        return this._queryResultDisplay;
    }

    public JTree getTree() {
        return this._tree;
    }

    public void setQueryResult(QueryResult queryResult) {
        if (queryResult instanceof URLQueryResult) {
            this._addURLQueryResult(null, ((URLQueryResult)queryResult).getURL());
        } else if (queryResult instanceof CatalogDirectory) {
            this._queryResult = queryResult;
            this._tree.setModel((CatalogDirectory)queryResult);
        } else {
            throw new RuntimeException("Expected a CatalogDirectory object, not: " + this._queryResult);
        }
    }

    public QueryResult getQueryResult() {
        return this._queryResult;
    }

    private void _addURLQueryResult(Catalog node, URL url) {
        if (this._progressPanel == null) {
            this._progressPanel = ProgressPanel.makeProgressPanel(_I18N.getString("downloadingCatalogDesc"), this);
        }
        if (this._loader == null) {
            this._loader = new CatalogLoader(node, url);
            this._loader.start();
        }
    }

    private void _nodeSelected() {
        if (this._ignoreSelection) {
            return;
        }
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (selectedNode == this._rootCatDir) {
            if (this._queryResultDisplay != null) {
                this._queryResultDisplay.setQueryResult(null);
            }
            return;
        }
        this._addCatalog(selectedNode, selectedNode);
    }

    public void selectNode(Catalog node) {
        this._ignoreSelection = true;
        try {
            this._tree.setSelectionPath(new TreePath(node.getPath()));
        }
        catch (Exception e) {
            System.out.println(_I18N.getString("noTreeNodeSelectWarning"));
        }
        this._ignoreSelection = false;
    }

    public Catalog getSelectedNode() {
        return (Catalog)this._tree.getLastSelectedPathComponent();
    }

    public void addQueryResult(QueryResult queryResult) {
        Catalog selectedNode = (Catalog)this._tree.getLastSelectedPathComponent();
        if (selectedNode == null) {
            this.setQueryResult(queryResult);
        } else {
            this._addQueryResult(selectedNode, queryResult);
        }
    }

    private void _addQueryResult(Catalog node, QueryResult queryResult) {
        if (queryResult instanceof URLQueryResult) {
            this._addURLQueryResult(node, ((URLQueryResult)queryResult).getURL());
        } else if (queryResult instanceof CatalogDirectory) {
            this._addCatalogDirectory(node, (CatalogDirectory)queryResult);
        } else if (queryResult instanceof Catalog) {
            this._addCatalog(node, (Catalog)queryResult);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _addCatalogDirectory(Catalog node, CatalogDirectory catDir) {
        int numCatalogs = catDir.getNumCatalogs();
        if (numCatalogs > 0) {
            CatalogDirectory parent = node.getParent();
            if (parent != null) {
                parent.replaceCatalog(node, catDir);
                this._tree.expandPath(new TreePath(catDir.getPath()));
                return;
            } else {
                if (!(node instanceof CatalogDirectory)) throw new RuntimeException("No parent node specified for: " + node.getName());
                this.setQueryResult(catDir);
            }
            return;
        } else {
            this._addCatalog(node, catDir);
        }
    }

    private void _addCatalog(Catalog node, Catalog catalog) {
        if (this._queryResultDisplay != null) {
            if (catalog.getNumParams() == 0) {
                QueryResult queryResult;
                try {
                    queryResult = catalog.query(new BasicQueryArgs(catalog));
                }
                catch (Exception e) {
                    DialogUtil.error(e);
                    return;
                }
                this._addQueryResult(node, queryResult);
            } else {
                this._queryResultDisplay.setQueryResult(catalog);
            }
        }
    }

    private void _displayQueryResult(Catalog node, CatalogDirectory catDir) {
        Catalog queryResult = catDir;
        if (catDir.getNumCatalogs() == 1) {
            queryResult = catDir.getCatalog(0);
        }
        if (node == null) {
            this.setQueryResult(queryResult);
        } else {
            this._addQueryResult(node, queryResult);
        }
    }

    private JPopupMenu makeNodeMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this._cutAction);
        menu.add(this._copyAction);
        menu.add(this._pasteAction);
        menu.addSeparator();
        menu.add(this._toTopAction);
        menu.add(this._moveUpAction);
        menu.add(this._moveDownAction);
        menu.add(this._toBottomAction);
        return menu;
    }

    public JMenuItem makeReloadMenuItem() {
        JMenuItem menuItem = new JMenuItem(_I18N.getString("reloadConfigFile"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CatalogTree.this.reload();
            }
        });
        return menuItem;
    }

    public void reload() {
        this._rootCatDir = this._rootCatDir.reload();
        this.setQueryResult(this._rootCatDir);
    }

    public QueryResult getQueryResult(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String contentType = connection.getContentType();
        if (contentType == null || !contentType.equals("text/html")) {
            CatalogDirectory dir;
            String filename = url.getFile();
            CatalogDirectory parentDir = this._rootCatDir;
            Catalog selectedNode = this.getSelectedNode();
            if (selectedNode != null && selectedNode != this._rootCatDir && (dir = selectedNode.getParent()) != null) {
                parentDir = dir;
            }
            return parentDir.loadSubDir(url);
        }
        this._htmlQueryResultHandler.displayHTMLPage(url);
        throw new RuntimeException(_I18N.getString("urlAccessError") + ": " + url.toString());
    }

    private void updateEnabledStates() {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Catalog[] path = selectedNode.getPath();
        int pathLen = 0;
        if (path != null) {
            pathLen = path.length;
        }
        boolean b = pathLen == 2;
        this._cutAction.setEnabled(b);
        this._copyAction.setEnabled(true);
        this._pasteAction.setEnabled(pathLen == 1 && ClipboardHelper.getClipboard() instanceof Catalog);
        this._toTopAction.setEnabled(b);
        this._moveUpAction.setEnabled(b);
        this._moveDownAction.setEnabled(b);
        this._toBottomAction.setEnabled(b);
    }

    public void cut() {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        ClipboardHelper.setClipboard(selectedNode);
        this._rootCatDir.removeCatalog(selectedNode);
        this._rootCatDir.save();
    }

    public void copy() {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        ClipboardHelper.setClipboard(selectedNode);
    }

    public void paste() {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        Object o = ClipboardHelper.getClipboard();
        if (o instanceof Catalog) {
            Catalog cat = (Catalog)o;
            this._rootCatDir.addCatalog(cat);
            this._rootCatDir.save();
        } else if (o == null) {
            DialogUtil.error(_I18N.getString("noCatalogObjInClipboard"));
        } else {
            DialogUtil.error(_I18N.getString("noSuitableObjInClipboard"));
        }
    }

    public void moveNode(boolean up) {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        this._rootCatDir.moveCatalog(selectedNode, up);
        this._rootCatDir.save();
    }

    public void moveNodeToEnd(boolean up) {
        Catalog selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        this._rootCatDir.moveCatalogToEnd(selectedNode, up);
        this._rootCatDir.save();
    }

    public AbstractAction getCutAction() {
        return this._cutAction;
    }

    public AbstractAction getCopyAction() {
        return this._copyAction;
    }

    public AbstractAction getPasteAction() {
        return this._pasteAction;
    }

    public AbstractAction getMoveUpAction() {
        return this._moveUpAction;
    }

    public AbstractAction getMoveDownAction() {
        return this._moveDownAction;
    }

    public AbstractAction getToTopAction() {
        return this._toTopAction;
    }

    public AbstractAction getToBottomAction() {
        return this._toBottomAction;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("CatalogTree");
        AstroCatConfig catDir = AstroCatConfig.getConfigFile();
        CatalogTree catTree = new CatalogTree(catDir);
        frame.getContentPane().add((Component)catTree, "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CatalogLoader
    extends SwingWorker {
        private Catalog _node;
        private URL _url;

        public CatalogLoader(Catalog node, URL url) {
            this._node = node;
            this._url = url;
            CatalogTree.this._progressPanel.start();
        }

        public Object construct() {
            try {
                return CatalogTree.this.getQueryResult(this._url);
            }
            catch (Exception e) {
                return e;
            }
        }

        public void finished() {
            CatalogTree.this._progressPanel.stop();
            CatalogTree.this._loader = null;
            Object result = this.getValue();
            if (result instanceof Exception) {
                DialogUtil.error((Exception)result);
                return;
            }
            if (result == null || !(result instanceof QueryResult)) {
                DialogUtil.error(_I18N.getString("urlLoadError") + ": " + this._url.toString());
                return;
            }
            if (result instanceof CatalogDirectory) {
                CatalogTree.this._displayQueryResult(this._node, (CatalogDirectory)result);
            } else if (CatalogTree.this._queryResultDisplay != null) {
                CatalogTree.this._queryResultDisplay.setQueryResult(new URLQueryResult(this._url));
            }
        }
    }
}

