/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jsky.catalog.Catalog;
import jsky.catalog.CatalogDirectory;
import jsky.util.Resources;

public class CatalogTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Icon _imagesvrIcon = Resources.getIcon("imagesvr.gif");
    private Icon _catalogIcon = Resources.getIcon("catalog.gif");
    private Icon _archiveIcon = Resources.getIcon("archive.gif");
    private Icon _namesvrIcon = Resources.getIcon("namesvr.gif");

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setBackgroundNonSelectionColor(tree.getBackground());
        if (this instanceof JLabel && value instanceof Catalog) {
            if (value instanceof CatalogDirectory) {
                this.setIcon(this.getOpenIcon());
                this.setToolTipText(((CatalogDirectory)value).getDescription());
            } else {
                String servType = ((Catalog)value).getType();
                if (servType.equals("directory")) {
                    this.setIcon(this.getOpenIcon());
                }
                if (servType.equals("catalog")) {
                    this.setIcon(this._catalogIcon);
                }
                if (servType.equals("archive")) {
                    this.setIcon(this._archiveIcon);
                }
                if (servType.equals("namesvr")) {
                    this.setIcon(this._namesvrIcon);
                }
                if (servType.equals("imagesvr")) {
                    this.setIcon(this._imagesvrIcon);
                }
                this.setToolTipText(this.getText());
            }
        }
        return this;
    }
}

