/*
 * Decompiled with CFR 0.152.
 */
package jsky.catalog.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import jsky.catalog.FieldDesc;
import jsky.catalog.QueryResult;
import jsky.catalog.TableQueryResult;
import jsky.catalog.gui.QueryResultDisplay;
import jsky.util.gui.DialogUtil;

public class HyperlinkTableCellEditor
extends JButton
implements TableCellEditor,
ActionListener {
    protected FieldDesc field;
    protected TableQueryResult tableQueryResult;
    protected Object value;
    protected int row;
    QueryResultDisplay queryResultDisplay;

    public HyperlinkTableCellEditor(FieldDesc field, TableQueryResult tableQueryResult, QueryResultDisplay queryResultDisplay) {
        this.field = field;
        this.tableQueryResult = tableQueryResult;
        this.queryResultDisplay = queryResultDisplay;
        this.addActionListener(this);
        this.setHorizontalAlignment(2);
    }

    public void actionPerformed(ActionEvent ev) {
        block2: {
            try {
                QueryResult queryResult = this.field.getLinkValue(this.tableQueryResult, this.value, this.row);
                this.queryResultDisplay.setQueryResult(queryResult);
            }
            catch (Exception e) {
                if (this.getText().length() == 0) break block2;
                DialogUtil.error(e);
            }
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.value = value;
        try {
            this.field.getLinkValue(this.tableQueryResult, value, row);
            this.setText(this.field.getLinkText(this.tableQueryResult, value, row, column));
        }
        catch (Exception e) {
            this.setText("");
        }
        return this;
    }

    public Object getCellEditorValue() {
        return this.value;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return anEvent instanceof MouseEvent;
    }

    public boolean stopCellEditing() {
        return true;
    }

    public void cancelCellEditing() {
    }

    public void addCellEditorListener(CellEditorListener l) {
    }

    public void removeCellEditorListener(CellEditorListener l) {
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(Rectangle r) {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

